/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.msdrepo;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.artifactrepo.ScanForDiskUtil;
import com.ibm.cic.common.core.internal.repository.RepositoryList;
import com.ibm.cic.common.core.internal.volrepo.DiskMounter;
import com.ibm.cic.common.core.internal.volrepo.IDiskMounterFactory;
import com.ibm.cic.common.core.internal.volrepo.VolumeAtocUtil;
import com.ibm.cic.common.core.internal.volrepo.VolumeSetReader;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.msdrepo.MasterSetupDiskConstants;
import com.ibm.cic.common.core.msdrepo.MasterSetupDiskRepository;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRepositoryPool;
import com.ibm.cic.common.core.repository.PrivateRepositoryPools;
import com.ibm.cic.common.core.repository.RepositoryContext;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.volrepo.DiskTagFile;
import com.ibm.cic.common.core.volrepo.VolumeBase;
import com.ibm.cic.common.core.volrepo.VolumeRepository;
import com.ibm.cic.common.core.volrepo.VolumesArtifactTableOfContents;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class MasterSetupDiskReader
extends MasterSetupDiskConstants {
    private final ICicLocation root;
    private final TempUtil.UniqueTempDir cacheFolder;
    private final IRepositoryPool privatePool;
    private final RepositoryGroup innerGroup;
    private RepositoryGroup mdGroup;
    private IRepository masterRepo;
    private List diskSets;
    private final List cachedPaths = new ArrayList();

    public MasterSetupDiskReader(ICicLocation root, TempUtil.UniqueTempDir cdsetCacheFolder) {
        this.root = root;
        this.cacheFolder = cdsetCacheFolder;
        String name = "MasterSetupDisk at " + root;
        this.privatePool = PrivateRepositoryPools.INSTANCE.createPrivateRepositoryPool(name);
        this.innerGroup = new RepositoryGroup(name, new RepositoryList(), this.privatePool);
    }

    public DiskMounter findDisk(String wantedDiskSetId, int wantedDiskNumber) {
        File dir = this.getFindAvailableDisksRootDir();
        if (dir == null) {
            return null;
        }
        return ScanForDiskUtil.findOfferingThenDiskFolder(dir, wantedDiskSetId, wantedDiskNumber);
    }

    private File getFindAvailableDisksRootDir() {
        File file = null;
        try {
            file = FileURLUtil.locationToFile(this.root.toString());
        }
        catch (MalformedURLException e) {
            MasterSetupDiskRepository.log.error(e);
            return null;
        }
        String dirName = file.getName();
        if (!MasterSetupDiskConstants.isCanFindAvailableDisksFolder(dirName)) {
            return null;
        }
        File p = file.getParentFile();
        if (p == null) {
            return null;
        }
        return p;
    }

    public boolean canFindAvailableDisks() {
        File dir = this.getFindAvailableDisksRootDir();
        return dir != null;
    }

    private ICicLocation getSuggestedDiskLocation() {
        ICicLocation location = this.canFindAvailableDisks() ? (this.root.getSize() > 1 ? this.root.removeLastSegment() : this.root) : this.root;
        return location;
    }

    public List getDiskSets(IProgressMonitor monitor) throws CoreException, IOException {
        if (this.diskSets == null) {
            this.cacheDiskSetInfo(monitor);
        }
        return this.diskSets;
    }

    public void dispose() {
        if (this.diskSets != null) {
            for (DiskSetInfo diskSetInfo : this.diskSets) {
                diskSetInfo.dispose();
            }
        }
        if (this.innerGroup != null) {
            this.innerGroup.removeAllRepositories();
        }
        if (this.mdGroup != null) {
            this.mdGroup.removeAllRepositories();
        }
        if (this.privatePool != null) {
            PrivateRepositoryPools.INSTANCE.releasePrivatePool(this.privatePool);
        }
        for (File dir : this.cachedPaths) {
            FileUtil.rm_r(dir, true);
        }
        this.cacheFolder.cleanEmptyDirsLogIOE();
        this.masterRepo = null;
        this.diskSets = null;
        this.cachedPaths.clear();
    }

    public void refresh() {
        if (this.diskSets != null) {
            for (DiskSetInfo diskSetInfo : this.diskSets) {
                diskSetInfo.refresh();
            }
        }
        if (this.innerGroup != null) {
            this.innerGroup.refresh();
        }
        if (this.mdGroup != null) {
            this.mdGroup.refresh();
        }
    }

    private File cacheDir(File srcRoot, String tmpArea, IProgressMonitor monitor) throws IOException {
        File cacheDir = this.getCacheDir(tmpArea);
        this.cachedPaths.add(cacheDir);
        FileUtil.rm_r(cacheDir, false);
        FileUtil.copyDir(srcRoot, cacheDir, monitor);
        return cacheDir;
    }

    private File getCacheDir(String tmpArea) {
        Path cacheDir = new Path(this.cacheFolder.getUniqueTempDir().getAbsolutePath());
        cacheDir = cacheDir.append("msd@" + this.hashCode());
        cacheDir = cacheDir.append(tmpArea);
        File cacheDirFile = cacheDir.toFile();
        FileUtil.ensureDestinationDirectory(cacheDirFile);
        return cacheDirFile;
    }

    private static IRepository openMasterRepo(IRepositoryGroup group, ICicLocation location) throws CoreException, IOException {
        IRepositoryInfo repInfo = group.createRepositoryInfo("msd/repo", null, null, location, null);
        RepositoryContext.setRequiredContext(repInfo, "EnclosingRepository");
        return group.addExistingRepository(repInfo, true);
    }

    public void initMasterRepo(IRepository msdRepo, IProgressMonitor monitor) throws IOException, CoreException {
        monitor.beginTask("", 1);
        try {
            IRepository repo;
            ICicLocation metaRoot = this.root.append("msd/repo");
            File metaRootFile = FileURLUtil.locationToFile(metaRoot.toString());
            File cacheDirFile = this.cacheDir(metaRootFile, "repo", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CicFileLocation location = new CicFileLocation(cacheDirFile.toString());
            this.masterRepo = repo = MasterSetupDiskReader.openMasterRepo(this.innerGroup, location);
        }
        finally {
            monitor.done();
        }
    }

    public IRepository getMasterRepo(IProgressMonitor monitor) {
        return this.getMasterRepo();
    }

    public IRepository getMasterRepo() {
        return this.masterRepo;
    }

    public IRepositoryGroup getMetaRepoGroup(IRepository msdRepo, IProgressMonitor monitor) throws IOException, CoreException {
        if (this.mdGroup == null) {
            String name = "MasterSetupDisk metadatagroup at " + this.root;
            this.mdGroup = new RepositoryGroup(name, new RepositoryList(), this.privatePool);
            IRepository repo = this.getMasterRepo(monitor);
            try (IArtifactSession session = IArtifactSessionFactory.INSTANCE.createArtifactSession();){
                try {
                    if (repo != null) {
                        this.mdGroup.addExistingRepository(repo, false);
                    }
                    List sets = this.getDiskSets((IProgressMonitor)new SubProgressMonitor(monitor, 0));
                    SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)sets.size());
                    for (DiskSetInfo diskSetInfo : sets) {
                        repo = diskSetInfo.getDiskSetRepository(session, (IProgressMonitor)sm.newChild(1));
                        this.mdGroup.addExistingRepository(repo, false);
                    }
                }
                catch (CoreException e) {
                    this.mdGroup.removeAllRepositories();
                    this.mdGroup = null;
                    throw e;
                }
                catch (IOException e) {
                    this.mdGroup.removeAllRepositories();
                    this.mdGroup = null;
                    throw e;
                }
            }
        }
        return this.mdGroup;
    }

    private void cacheDiskSetInfo(IProgressMonitor monitor) throws CoreException, IOException {
        ICicLocation msd = this.root.append("msd");
        File folder = FileURLUtil.locationToFile(msd.toString());
        String[] files = folder.list();
        if (files == null) {
            this.diskSets = new ArrayList();
            return;
        }
        ArrayList<Integer> fileMatches = new ArrayList<Integer>(files.length);
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String fileName = stringArray[n2];
                int index = fileName.indexOf("diskSet");
                if (index == 0) {
                    String r = fileName.substring("diskSet".length());
                    Integer diskSetNum = null;
                    try {
                        diskSetNum = Integer.valueOf(r);
                    }
                    catch (NumberFormatException e) {
                        String msg = NLS.bind((String)"Ignoring path {0}. Failed to parse {1} as number.", (Object)new File(folder, fileName), (Object)r);
                        MasterSetupDiskRepository.log.debug(msg);
                        break block6;
                    }
                    File diskSet = new File(folder, fileName);
                    File f = new File(diskSet, VolumeBase.PATH_DATOC_FILE.toString());
                    this.checkFileExists(f);
                    f = new File(diskSet, "diskTag.inf");
                    this.checkFileExists(f);
                    fileMatches.add(diskSetNum);
                }
            }
            ++n2;
        }
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, fileMatches.size());
        this.diskSets = new ArrayList(fileMatches.size());
        Collections.sort(fileMatches);
        for (Integer diskSetNum : fileMatches) {
            String diskSet = "diskSet" + diskSetNum.toString();
            File sourceDir = new File(folder, diskSet);
            File cacheDir = this.cacheDir(sourceDir, diskSet, spm.next());
            this.diskSets.add(new DiskSetInfo(sourceDir, cacheDir, diskSetNum));
        }
    }

    private void checkFileExists(File f) throws CoreException {
        if (!f.exists()) {
            String msg = NLS.bind((String)Messages.MasterSetupDiskReader_ExpectedFileNotFound, (Object)f);
            ICicStatus status = Statuses.ERROR.get(msg, new Object[0]);
            throw new CoreException((IStatus)status);
        }
    }

    public class DiskSetInfo {
        private final Integer diskSetNum;
        private DiskTagFile.DiskTagProperties dtp;
        private VolumeAtocUtil datoc;
        private IRepository diskSetRepo;
        private IRepository diskSetMetaRepo;
        private IRepository diskSetArtifactRepo;
        private final File originalLocation;
        private final File cacheDir;
        private IRepository previousDiskSetMetaDataReference;

        public DiskSetInfo(File originalLocation, File cacheDir, Integer diskSetNum) {
            this.originalLocation = originalLocation;
            this.cacheDir = cacheDir;
            this.diskSetNum = diskSetNum;
        }

        public String toString() {
            return "diskSetNum=" + this.diskSetNum + " at " + this.originalLocation.toString();
        }

        public void dispose() {
            if (this.diskSetRepo != null) {
                this.diskSetRepo.refresh();
            }
            if (this.previousDiskSetMetaDataReference != null) {
                this.diskSetMetaRepo.setRepositoryReference(this.previousDiskSetMetaDataReference);
            }
        }

        public void refresh() {
            if (this.diskSetRepo != null) {
                this.diskSetRepo.refresh();
            }
        }

        public void refreshThisOnly() {
            if (this.diskSetMetaRepo != null) {
                this.diskSetMetaRepo.refresh();
            }
            if (this.diskSetArtifactRepo != null) {
                this.diskSetArtifactRepo.refresh();
            }
            this.datoc = null;
        }

        public DiskTagFile.DiskTagProperties getDiskTagProperties() throws CoreException {
            if (this.dtp == null) {
                try {
                    boolean askForDisk = false;
                    String diskLabel = null;
                    String diskSetId = null;
                    CicFileLocation diskLocation = new CicFileLocation(this.cacheDir.toString());
                    int diskIndex = 0;
                    DiskMounter diskMounter = new DiskMounter(askForDisk, diskLocation, diskLabel, diskSetId, diskIndex);
                    this.dtp = diskMounter.getMountedDisk().getDiskTagProperties();
                }
                catch (CoreException e) {
                    MasterSetupDiskRepository.log.status(e.getStatus());
                    throw new CoreException(e.getStatus());
                }
            }
            return this.dtp;
        }

        private void initDatoc(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
            if (this.datoc == null) {
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                try {
                    ArtifactTableOfContents.TocHolder tocHolder = VolumeAtocUtil.readVolumeArtifactToc(session, new File(this.cacheDir, "toc/"), (IProgressMonitor)sm.newChild(1));
                    String diskSetId = this.getDiskTagProperties().getProperty("diskSetId");
                    String label = null;
                    IRepository diskRepo = this.getDiskSetRepository(session, (IProgressMonitor)sm.newChild(1));
                    if (diskRepo != null) {
                        label = VolumeRepository.readDiskLabel(diskRepo, null, this.getDiskTagProperties(), (IProgressMonitor)sm.newChild(1));
                    }
                    this.datoc = VolumeAtocUtil.create(session, diskSetId, label, tocHolder, (IProgressMonitor)sm.newChild(1));
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        }

        public VolumeAtocUtil.OrderedDisks getUsedDisks(IArtifactSession session, Collection artifacts, Collection outArtifactsNotOnDisks, IProgressMonitor monitor) throws CoreException, IOException {
            this.initDatoc(session, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
            return this.datoc.getUsedDisks(session, artifacts, outArtifactsNotOnDisks, monitor);
        }

        public String getDiskSetId() throws CoreException {
            String diskSetId = this.getDiskTagProperties().getProperty("diskSetId");
            return diskSetId;
        }

        public IVolumeAccessByDisk.IDiskSet getDiskSetsWithCount(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
            this.initDatoc(session, monitor);
            return this.datoc.getDiskSet();
        }

        public VolumeAtocUtil getDiskArtifactTocUtil(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
            this.initDatoc(session, monitor);
            return this.datoc;
        }

        public VolumesArtifactTableOfContents.DiskInfo getDiskInfo(IArtifactSession session, IArtifact iartifact, IProgressMonitor monitor) throws IOException, CoreException {
            this.initDatoc(session, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
            return this.datoc.getDiskInfo(session, iartifact, monitor);
        }

        public IRepository getDiskSetMetaRepository(IProgressMonitor monitor) throws CoreException {
            if (this.diskSetMetaRepo == null) {
                File metaRootDir = new File(this.cacheDir, "md");
                CicFileLocation location = new CicFileLocation(metaRootDir.toString());
                IRepositoryInfo repInfo = MasterSetupDiskReader.this.innerGroup.createRepositoryInfo("md", "Remote", "0.0.0.1", location, null);
                RepositoryContext.setRequiredContext(repInfo, "EnclosingRepository");
                this.diskSetMetaRepo = RepositoryUtils.addSpecificInnerRepository(MasterSetupDiskReader.this.innerGroup, repInfo, false, monitor);
            }
            return this.diskSetMetaRepo;
        }

        public IRepository getDiskSetArtifactRepository(IProgressMonitor monitor) throws CoreException {
            if (this.diskSetArtifactRepo == null) {
                File metaRootDir = new File(this.cacheDir, "ad");
                CicFileLocation location = new CicFileLocation(metaRootDir.toString());
                IRepositoryInfo repInfo = MasterSetupDiskReader.this.innerGroup.createRepositoryInfo("ad", "ShortName", "0.0.0.1", location, null);
                RepositoryContext.setRequiredContext(repInfo, "EnclosingRepository");
                CoreException e1 = null;
                try {
                    this.diskSetArtifactRepo = RepositoryUtils.addSpecificInnerRepository(MasterSetupDiskReader.this.innerGroup, repInfo, false, monitor);
                }
                catch (CoreException e) {
                    e1 = e;
                }
                if (this.diskSetArtifactRepo == null) {
                    repInfo = MasterSetupDiskReader.this.innerGroup.createRepositoryInfo("ad", "Remote", "0.0.0.1", location, null);
                    try {
                        this.diskSetArtifactRepo = RepositoryUtils.addSpecificInnerRepository(MasterSetupDiskReader.this.innerGroup, repInfo, false, monitor);
                    }
                    catch (CoreException e) {
                        throw e1;
                    }
                }
            }
            return this.diskSetArtifactRepo;
        }

        public IRepository getDiskSetRepository(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
            if (this.diskSetRepo == null) {
                ICicLocation location = null;
                final String diskSetId = this.getDiskTagProperties().getProperty("diskSetId");
                final DiskMounter disk1Mounter = MasterSetupDiskReader.this.findDisk(diskSetId, 1);
                File fileDisk1 = disk1Mounter != null ? disk1Mounter.getMountedDisk().getRoot().toFile() : null;
                location = fileDisk1 != null ? new CicFileLocation(fileDisk1.toString()) : MasterSetupDiskReader.this.getSuggestedDiskLocation();
                final DiskTagFile.DiskTagProperties diskTagProperties = this.getDiskTagProperties();
                IRepositoryInfo repInfo = MasterSetupDiskReader.this.innerGroup.createRepositoryInfo("diskSet" + diskSetId, "Volume", "0.0.0.1", location, null);
                repInfo.setProperty("AskForDisk1", Boolean.FALSE);
                repInfo.setProperty("diskSetId", diskSetId);
                VolumeRepository.IExtDisk1Info disk1Info = new VolumeRepository.IExtDisk1Info(){

                    @Override
                    public boolean canFindAvailableDisks(DiskMounter currentDisk) {
                        if (currentDisk != null) {
                            return currentDisk.canFindAvailableDisks();
                        }
                        return MasterSetupDiskReader.this.canFindAvailableDisks();
                    }

                    @Override
                    public DiskMounter findDisk(int diskNum) {
                        if (diskNum == 1) {
                            IStatus status;
                            if (disk1Mounter != null && (status = disk1Mounter.ensureInsertedDiskNoPrompting(0, (IProgressMonitor)new NullProgressMonitor())).isOK()) {
                                return disk1Mounter;
                            }
                            return null;
                        }
                        return MasterSetupDiskReader.this.findDisk(diskSetId, diskNum);
                    }

                    public ICicLocation getSuggestedDiskLocation(int i) {
                        return MasterSetupDiskReader.this.getSuggestedDiskLocation();
                    }

                    @Override
                    public String getDiskSetId() {
                        return diskSetId;
                    }

                    @Override
                    public IRepository getMasterDiskSetArtifactRepo(IProgressMonitor m) throws CoreException {
                        return DiskSetInfo.this.getDiskSetArtifactRepository(m);
                    }

                    @Override
                    public void createMasterDiskSetMetadataRepoInVolumeRepo(IRepository volumeRepo, IProgressMonitor m) throws CoreException {
                        IRepository metadataRepo = DiskSetInfo.this.getDiskSetMetaRepository(m);
                        DiskSetInfo.this.previousDiskSetMetaDataReference = metadataRepo.getRepositoryReference();
                        IRepository diskSetRef = volumeRepo.getRepositoryReference();
                        metadataRepo.setRepositoryReference(diskSetRef);
                    }

                    @Override
                    public IRepository getInnerMetaRepo() {
                        return DiskSetInfo.this.diskSetMetaRepo;
                    }

                    @Override
                    public VolumeAtocUtil getVolumeAtocUtil(IArtifactSession s, IProgressMonitor m) throws CoreException, IOException {
                        return DiskSetInfo.this.getDiskArtifactTocUtil(s, m);
                    }

                    @Override
                    public DiskTagFile.DiskTagProperties getDiskTagProperties() {
                        return diskTagProperties;
                    }

                    @Override
                    public IDiskMounterFactory getDiskMounterFactory(final String diskLabel) {
                        return new IDiskMounterFactory(){

                            @Override
                            public DiskMounter mount(Boolean argAskForDisk, Integer argDiskIndex) throws CoreException {
                                int diskIndex = argDiskIndex != null ? argDiskIndex : 0;
                                DiskMounter diskMounter = this.findDisk(diskIndex + 1);
                                if (diskMounter != null) {
                                    return diskMounter;
                                }
                                ICicLocation diskLocation = this.getSuggestedDiskLocation(diskIndex + 1);
                                boolean askForDisk1 = argAskForDisk == null || argAskForDisk != false;
                                diskMounter = new DiskMounter(askForDisk1, diskLocation, diskLabel, this.getDiskSetId(), diskIndex);
                                VolumeSetReader.checkLayoutVersionCompatible(diskMounter.getMountedDisk());
                                return diskMounter;
                            }
                        };
                    }

                    @Override
                    public void refresh() {
                        DiskSetInfo.this.refreshThisOnly();
                    }
                };
                repInfo.setProperty("extDisk1Info", disk1Info);
                this.diskSetRepo = MasterSetupDiskReader.this.innerGroup.addExistingRepository(repInfo, true);
                if (this.diskSetRepo != null) {
                    disk1Info.createMasterDiskSetMetadataRepoInVolumeRepo(this.diskSetRepo, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                }
            }
            return this.diskSetRepo;
        }
    }
}

