/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.msdrepo;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactsOnDisks;
import com.ibm.cic.common.core.artifactrepo.impl.DiskUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactGet;
import com.ibm.cic.common.core.artifactrepo.impl.IMasterSetupDiskExtensions;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.msdrepo.MasterSetupDiskReader;
import com.ibm.cic.common.core.internal.msdrepo.VisibleDiskSetFilteredMasterSetupDiskRepository;
import com.ibm.cic.common.core.internal.volrepo.DiskMounter;
import com.ibm.cic.common.core.internal.volrepo.VolumeArtifactRepository;
import com.ibm.cic.common.core.internal.volrepo.VolumeAtocUtil;
import com.ibm.cic.common.core.internal.volrepo.WrappedLocator;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.msdrepo.MasterSetupDiskRepository;
import com.ibm.cic.common.core.repository.IFilterRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.volrepo.VolumesArtifactTableOfContents;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class MasterSetupDiskArtifactRepository
implements IReadArtifactRepo,
IArtifactGet,
IVolumeAccessByDisk,
IMasterSetupDiskExtensions {
    @Override
    public abstract IRepository getRepository();

    public abstract MasterSetupDiskReader getMasterReader();

    @Override
    public IVolumeAccessByDisk.IDiskSet[] getDiskSets(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
        MasterSetupDiskReader msr = this.getMasterReader();
        List diskSets = msr.getDiskSets((IProgressMonitor)new SubProgressMonitor(monitor, 0));
        ArrayList<IVolumeAccessByDisk.IDiskSet> extDiskSets = new ArrayList<IVolumeAccessByDisk.IDiskSet>(diskSets.size());
        extDiskSets.add(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)diskSets.size());
        for (MasterSetupDiskReader.DiskSetInfo diskSetInfo : diskSets) {
            IVolumeAccessByDisk.IDiskSet diskSet = diskSetInfo.getDiskSetsWithCount(session, (IProgressMonitor)sm.newChild(1));
            extDiskSets.add(diskSet);
        }
        return extDiskSets.toArray(new IVolumeAccessByDisk.IDiskSet[extDiskSets.size()]);
    }

    @Override
    public IVolumeAccessByDisk.IDiskSet[] getPackageDiskSets(IArtifactSession session, IOfferingOrFix pkg, IProgressMonitor monitor) throws CoreException, IOException {
        IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter = null;
        return this.getPackageDiskSets(filter, session, pkg, monitor);
    }

    private IVolumeAccessByDisk.IDiskSet[] getPackageDiskSets(IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter, IArtifactSession session, IOfferingOrFix pkg, IProgressMonitor monitor) throws CoreException, IOException {
        IRepository masterRep;
        MasterSetupDiskReader msr = this.getMasterReader();
        List diskSets = msr.getDiskSets((IProgressMonitor)new SubProgressMonitor(monitor, 0));
        ArrayList<IVolumeAccessByDisk.IDiskSet> extDiskSets = new ArrayList<IVolumeAccessByDisk.IDiskSet>(diskSets.size() + 1);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)((diskSets.size() + 1) * 2));
        if (MasterSetupDiskArtifactRepository.isVisible(filter, MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET) && (masterRep = msr.getMasterRepo()) != null && VolumeArtifactRepository.hasPackage(msr.getMasterRepo(), session, pkg, (IProgressMonitor)sm.newChild(2))) {
            extDiskSets.add(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET);
        }
        sm.setWorkRemaining(diskSets.size() * 2);
        for (MasterSetupDiskReader.DiskSetInfo diskSetInfo : diskSets) {
            if (!MasterSetupDiskArtifactRepository.isVisible(filter, diskSetInfo)) {
                sm.worked(2);
                continue;
            }
            IRepository repo = diskSetInfo.getDiskSetRepository(session, (IProgressMonitor)sm.newChild(1));
            IVolumeAccessByDisk diskRepo = RepoAs.IVolumeAccessByDisk(repo);
            IVolumeAccessByDisk.IDiskSet[] subDiskSets = diskRepo.getPackageDiskSets(session, pkg, (IProgressMonitor)sm.newChild(1));
            if (subDiskSets == null) continue;
            extDiskSets.addAll(Arrays.asList(subDiskSets));
        }
        return extDiskSets.toArray(new IVolumeAccessByDisk.IDiskSet[extDiskSets.size()]);
    }

    public void visitArtifactsOnDisk(IArtifactSession session, IVolumeAccessByDisk.IDiskSet[] arrDiskSetsRequested, Collection artifacts, final IVolumeAccessByDisk.IArtifactOnDiskCallback aodCallback, IProgressMonitor monitor) throws CoreException, IOException {
        HashSet<IVolumeAccessByDisk.IDiskSet> diskSetsRequested = arrDiskSetsRequested != null ? new HashSet<IVolumeAccessByDisk.IDiskSet>(Arrays.asList(arrDiskSetsRequested)) : null;
        MasterSetupDiskReader msr = this.getMasterReader();
        List diskSets = msr.getDiskSets((IProgressMonitor)new SubProgressMonitor(monitor, 0));
        final LinkedHashSet artifactsOnAnyDiskSet = artifacts != null && artifacts.size() > 0 ? new LinkedHashSet(artifacts.size()) : new LinkedHashSet();
        IVolumeAccessByDisk.IArtifactOnDiskCallback myCallback = new IVolumeAccessByDisk.IArtifactOnDiskCallback(){

            @Override
            public void notOnAnyDisk(IArtifact artifact) {
                aodCallback.notOnAnyDisk(artifact);
            }

            @Override
            public void onDisk(IArtifact artifact, IVolumeAccessByDisk.IDisk disk) {
                artifactsOnAnyDiskSet.add(artifact);
                aodCallback.onDisk(artifact, disk);
            }
        };
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(diskSets.size() + 1));
        ArrayList artifactsNotOnDisk = new ArrayList();
        if (diskSetsRequested == null || diskSetsRequested.contains(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET)) {
            this.visitArtifactsOnSelf(session, MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET, artifacts, myCallback, artifactsNotOnDisk, (IProgressMonitor)sm.newChild(1));
        }
        sm.setWorkRemaining(diskSets.size());
        for (MasterSetupDiskReader.DiskSetInfo diskSetInfo : diskSets) {
            SubMonitor sm2 = SubMonitor.convert((IProgressMonitor)sm.newChild(1), (int)12);
            IVolumeAccessByDisk.IDiskSet diskSet = diskSetInfo.getDiskSetsWithCount(session, (IProgressMonitor)sm2.newChild(1));
            if (diskSetsRequested != null && !diskSetsRequested.contains(diskSet)) continue;
            VolumeAtocUtil datoc = diskSetInfo.getDiskArtifactTocUtil(session, (IProgressMonitor)sm2.newChild(1));
            datoc.artifactsOnDisks(session, artifacts, myCallback, artifactsNotOnDisk, (IProgressMonitor)sm2.newChild(10));
        }
        for (IArtifact artifact : artifactsNotOnDisk) {
            if (artifactsOnAnyDiskSet.contains(artifact)) continue;
            aodCallback.notOnAnyDisk(artifact);
        }
    }

    private void visitArtifactsOnSelf(IArtifactSession session, IVolumeAccessByDisk.IDiskSet selfDiskSet, Collection artifacts, IVolumeAccessByDisk.IArtifactOnDiskCallback aodCallback, ArrayList outArtifactsNotOnDisks, IProgressMonitor monitor) throws CoreException {
        MasterSetupDiskReader msr = this.getMasterReader();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)102);
        IRepository masterRepo = msr.getMasterRepo((IProgressMonitor)sm.newChild(1));
        try {
            if (masterRepo != null) {
                DiskUtil.Disk disk = new DiskUtil.Disk(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET, 1);
                if (artifacts == null) {
                    this.visitAllArtifactsOnSelfDisk(session, masterRepo, aodCallback, disk, (IProgressMonitor)sm.newChild(100));
                    return;
                }
                sm.setWorkRemaining(artifacts.size());
                ArrayList<IArtifact> notOnDisk = new ArrayList<IArtifact>(artifacts.size());
                for (IArtifact artifact : artifacts) {
                    IStatus status = RepoAs.IArtifactGet(masterRepo).existsArtifact(session, artifact, (IProgressMonitor)sm.newChild(1));
                    if (status.matches(8)) {
                        throw new CoreException(status);
                    }
                    if (status.matches(4)) {
                        throw new CoreException(status);
                    }
                    if (StatusCodes.isContentFound(status)) {
                        aodCallback.onDisk(artifact, disk);
                        continue;
                    }
                    if (!StatusCodes.isContentNotFound(status)) continue;
                    notOnDisk.add(artifact);
                }
                if (outArtifactsNotOnDisks != null && notOnDisk.size() > 0) {
                    outArtifactsNotOnDisks.addAll(notOnDisk);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void visitAllArtifactsOnSelfDisk(IArtifactSession session, IRepository masterRepo, IVolumeAccessByDisk.IArtifactOnDiskCallback aodCallback, IVolumeAccessByDisk.IDisk disk, IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IReadArtifactRepo.IArtifactToc atoc = masterRepo.readArtifactToc(session, (IProgressMonitor)sm.newChild(1));
        List categories = atoc.getContainedCategories();
        sm.setWorkRemaining(categories.size());
        for (IReadArtifactRepo.ICategory category : categories) {
            this.visitAllArtifactsOnSelfDisk(session, atoc, category, aodCallback, disk, (IProgressMonitor)sm.newChild(1));
        }
        sm.done();
    }

    private void visitAllArtifactsOnSelfDisk(IArtifactSession session, IReadArtifactRepo.IArtifactToc atoc, IReadArtifactRepo.ICategory category, IVolumeAccessByDisk.IArtifactOnDiskCallback aodCallback, IVolumeAccessByDisk.IDisk disk, IProgressMonitor monitor) throws CoreException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{1, 10});
        List contents = atoc.getContents(session, category, pm.next());
        SplitProgressMonitor pm2 = new SplitProgressMonitor(pm.next(), contents.size());
        for (Object content : contents) {
            if (content instanceof IReadArtifactRepo.ICategory) {
                this.visitAllArtifactsOnSelfDisk(session, atoc, (IReadArtifactRepo.ICategory)content, aodCallback, disk, pm2.next());
                continue;
            }
            if (content instanceof IArtifact) {
                IArtifact artifact = (IArtifact)content;
                aodCallback.onDisk(artifact, disk);
                continue;
            }
            assert (false) : "Unexpected type: " + content;
        }
        pm.done();
    }

    @Override
    public boolean disksAvailable(IArtifactSession session, IVolumeAccessByDisk.IDiskSetDisks disks, IProgressMonitor monitor) throws CoreException, IOException {
        if (disks.getDiskSet().getId().equals(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET.getId())) {
            return true;
        }
        MasterSetupDiskReader msr = this.getMasterReader();
        List diskSets = msr.getDiskSets((IProgressMonitor)new SubProgressMonitor(monitor, 0));
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)diskSets.size());
        for (MasterSetupDiskReader.DiskSetInfo diskSetInfo : diskSets) {
            IVolumeAccessByDisk.IDiskSet diskSet = diskSetInfo.getDiskSetsWithCount(session, (IProgressMonitor)sm.newChild(1));
            if (!diskSet.equals(disks.getDiskSet())) continue;
            String diskSetId = diskSet.getId();
            for (IVolumeAccessByDisk.IDisk element : disks.getDisks()) {
                IVolumeAccessByDisk.IDisk disk = element;
                DiskMounter diskMounter = msr.findDisk(diskSetId, disk.getDiskNumber());
                if (diskMounter != null) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean canFindAvailableDisks() {
        MasterSetupDiskReader msr = this.getMasterReader();
        return msr.canFindAvailableDisks();
    }

    @Override
    public void useArtifactLocatorsInOrder(IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter = null;
        this.useArtifactLocatorsInOrder(filter, session, diskOperation, artifactArgs, options, monitor);
    }

    private void useArtifactLocatorsInOrder(IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter, IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        int n = artifactArgs.getRecordCount();
        ArrayList artifacts = this.getRemainingArtifacts(diskOperation, artifactArgs, n);
        MasterSetupDiskReader msr = this.getMasterReader();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            List diskSets = msr.getDiskSets((IProgressMonitor)sm.newChild(1));
            sm.setWorkRemaining((1 + diskSets.size()) * 100);
            if (MasterSetupDiskArtifactRepository.isVisible(filter, MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET)) {
                ArtifactsOnDisks aod = new ArtifactsOnDisks(RepoAs.IVolumeAccessByDisk(this.getRepository()));
                aod.addArtifacts(artifacts);
                aod.addCheckOnlyFilter(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET);
                aod.determineArtifactsOnDisk(session, (IProgressMonitor)sm.newChild(5));
                List<IVolumeAccessByDisk.IDisk> usedDisks = aod.getUsedDisks();
                if (usedDisks.size() > 0) {
                    this.useArtifactsOnSelf(session, diskOperation, aod, artifactArgs, options, (IProgressMonitor)sm.newChild(95));
                    if (artifactArgs.getFailedOperationStatus().matches(12)) {
                        return;
                    }
                }
            }
            try {
                sm.setWorkRemaining(diskSets.size() * 100);
                for (MasterSetupDiskReader.DiskSetInfo diskSetInfo : diskSets) {
                    IVolumeAccessByDisk.IDiskSet diskSet = diskSetInfo.getDiskSetsWithCount(session, (IProgressMonitor)sm.newChild(1));
                    if (!MasterSetupDiskArtifactRepository.isVisible(filter, diskSet)) {
                        sm.worked(99);
                        continue;
                    }
                    ArtifactsOnDisks aod = new ArtifactsOnDisks(RepoAs.IVolumeAccessByDisk(this.getRepository()));
                    artifacts = this.getRemainingArtifacts(diskOperation, artifactArgs, n);
                    aod.addArtifacts(artifacts);
                    aod.addCheckOnlyFilter(diskSet);
                    aod.determineArtifactsOnDisk(session, (IProgressMonitor)sm.newChild(5));
                    List<IVolumeAccessByDisk.IDisk> usedDisks = aod.getUsedDisks();
                    if (usedDisks.size() <= 0) continue;
                    this.useArtifactsOnDiskSet(session, diskOperation, aod, diskSetInfo, diskSet, artifactArgs, options, (IProgressMonitor)sm.newChild(94));
                }
            }
            catch (CoreException e) {
                if (e.getStatus().matches(8)) {
                    artifactArgs.setCanceled();
                } else {
                    artifactArgs.setFailedOperationStatus(e.getStatus());
                }
                return;
            }
            catch (IOException e) {
                String msg = NLS.bind((String)Messages.MasterSetupDiskArtifactRepository_ExceptionAccessingRepository, (Object)this.getRepository().getLocation(), (Object)e);
                ICicStatus status = Statuses.ERROR.get(e, msg, new Object[0]);
                artifactArgs.setFailedOperationStatus(status);
                return;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void useArtifactsOnSelf(IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, ArtifactsOnDisks aod, IMultiArtifactOperationArguments artifactArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) throws CoreException {
        IVolumeAccessByDisk.IDiskSetDisks allUsedDisks;
        DiskUtil.Disk selfDisk;
        IStatus status;
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 1, 20});
        IMultiArtifactOperationArguments artifactsOnDisk = this.makeArtifactsArgsOnDiskSet(session, aod, diskOperation, artifactArgs, MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET, spm.next());
        MasterSetupDiskReader msr = this.getMasterReader();
        IRepository repo = msr.getMasterRepo(spm.next());
        if (repo != null && (status = diskOperation.useDisk(session, repo, selfDisk = new DiskUtil.Disk(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET, 1), allUsedDisks = MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET.useAllDisks(), artifactsOnDisk, options, spm.next())).matches(12)) {
            throw new CoreException(status);
        }
    }

    private ArrayList getRemainingArtifacts(IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactArgs, int n) {
        ArrayList<IArtifact> artifacts = new ArrayList<IArtifact>(n);
        for (IArtifactOperation.IArtifactOperationRecord element : artifactArgs.getRecords()) {
            IArtifact artifact;
            IArtifactOperation.IArtifactOperationRecord record = element;
            IStatus status = record.getLastStatus();
            if (status != IArtifactOperation.STATUS_OK_REQUESTED || (artifact = diskOperation.getArtifact(record)) == null) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public void useArtifactsOnDiskSet(IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, ArtifactsOnDisks aod, MasterSetupDiskReader.DiskSetInfo diskSetInfo, IVolumeAccessByDisk.IDiskSet diskSet, IMultiArtifactOperationArguments artifactArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) throws CoreException, IOException {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 1, 40});
        IMultiArtifactOperationArguments artifactsOnDisk = this.makeArtifactsArgsOnDiskSet(session, aod, diskOperation, artifactArgs, diskSet, spm.next());
        IRepository repo = diskSetInfo.getDiskSetRepository(session, spm.next());
        IVolumeAccessByDisk diskRepo = RepoAs.IVolumeAccessByDisk(repo);
        diskRepo.useArtifactLocatorsInOrder(session, diskOperation, artifactsOnDisk, options, spm.next());
        IStatus status = artifactsOnDisk.getFailedOperationStatus();
        if (status.matches(12)) {
            throw new CoreException(status);
        }
    }

    private IMultiArtifactOperationArguments makeArtifactsArgsOnDiskSet(IArtifactSession session, ArtifactsOnDisks aod, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments records, IVolumeAccessByDisk.IDiskSet diskSet, IProgressMonitor monitor) {
        monitor.beginTask("", records.getRecordCount());
        try {
            IMultiArtifactOperationArguments artifactsOnDisk = diskOperation.getOperation().createArguments();
            for (IArtifactOperation.IArtifactOperationRecord element : records.getRecords()) {
                IArtifact artifact;
                IArtifactOperation.IArtifactOperationRecord dlRecord = element;
                IStatus status = dlRecord.getLastStatus();
                if (status == IArtifactOperation.STATUS_OK_REQUESTED && (artifact = diskOperation.getArtifact(dlRecord)) != null && aod.isOnDiskSet(diskSet, artifact)) {
                    artifactsOnDisk.addRecord(dlRecord);
                }
                monitor.worked(1);
            }
            IMultiArtifactOperationArguments iMultiArtifactOperationArguments = artifactsOnDisk;
            return iMultiArtifactOperationArguments;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public boolean canGetLocatorsFromDisk1(IProgressMonitor monitor) {
        return false;
    }

    @Override
    public IStatus existsArtifact(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor) {
        IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter = null;
        return this.existsArtifact(filter, session, artifact, monitor);
    }

    private IStatus existsArtifact(IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter, IArtifactSession session, IArtifact artifact, IProgressMonitor monitor) {
        IStatus status;
        MasterSetupDiskReader msr = this.getMasterReader();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            IRepository repo = msr.getMasterRepo((IProgressMonitor)new SubProgressMonitor(monitor, 0));
            if (repo != null) {
                status = RepoAs.IArtifactGet(repo).existsArtifact(session, artifact, (IProgressMonitor)sm.newChild(1));
                if (status.matches(12)) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                if (StatusCodes.isContentFound(status)) {
                    IStatus iStatus = status;
                    return iStatus;
                }
            }
            List diskSets = msr.getDiskSets((IProgressMonitor)new SubProgressMonitor(monitor, 0));
            sm.setWorkRemaining(diskSets.size());
            for (MasterSetupDiskReader.DiskSetInfo diskSet : diskSets) {
                VolumesArtifactTableOfContents.DiskInfo diskInfo;
                if (!MasterSetupDiskArtifactRepository.isVisible(filter, diskSet) || (diskInfo = diskSet.getDiskInfo(session, artifact, (IProgressMonitor)sm.newChild(1))) == null) continue;
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IStatus iStatus = AbstractReadArtifactRepo.createArtifactNotFoundStatus(0, this.getRepository(), artifact);
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, e.getStatus(), null);
            return iStatus;
        }
        catch (IOException e) {
            IStatus iStatus = status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, null, (Exception)e);
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static boolean isVisible(IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter, MasterSetupDiskReader.DiskSetInfo diskSetInfo) throws CoreException {
        return MasterSetupDiskArtifactRepository.isVisible(filter, diskSetInfo.getDiskSetId());
    }

    private static boolean isVisible(IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter, IVolumeAccessByDisk.IDiskSet diskSet) {
        return MasterSetupDiskArtifactRepository.isVisible(filter, diskSet.getId());
    }

    private static boolean isVisible(IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter, String diskSetId) {
        IVolumeAccessByDisk.IDiskSet[] diskSets;
        if (filter == null) {
            return true;
        }
        IVolumeAccessByDisk.IDiskSet[] iDiskSetArray = diskSets = filter.getDiskSets();
        int n = diskSets.length;
        int n2 = 0;
        while (n2 < n) {
            IVolumeAccessByDisk.IDiskSet diskSet = iDiskSetArray[n2];
            if (diskSetId.equals(diskSet.getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IVolumeAccessByDisk.IDiskSet[] visibleDiskSets(IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter, IVolumeAccessByDisk.IDiskSet[] allDiskSets) {
        ArrayList<IVolumeAccessByDisk.IDiskSet> visibleDiskSets = new ArrayList<IVolumeAccessByDisk.IDiskSet>(allDiskSets.length);
        IVolumeAccessByDisk.IDiskSet[] iDiskSetArray = allDiskSets;
        int n = allDiskSets.length;
        int n2 = 0;
        while (n2 < n) {
            IVolumeAccessByDisk.IDiskSet diskSet = iDiskSetArray[n2];
            if (MasterSetupDiskArtifactRepository.isVisible(filter, diskSet)) {
                visibleDiskSets.add(diskSet);
            }
            ++n2;
        }
        return visibleDiskSets.toArray(new IVolumeAccessByDisk.IDiskSet[visibleDiskSets.size()]);
    }

    @Override
    public IStatus getArtifactLocator(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor, IArtifactLocator[] result) {
        return this.getArtifactLocator(null, session, artifact, monitor, result);
    }

    private IStatus getArtifactLocator(IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter, IArtifactSession session, IArtifact artifact, IProgressMonitor monitor, IArtifactLocator[] result) {
        IStatus status;
        MasterSetupDiskReader msr = this.getMasterReader();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            IRepository repo = msr.getMasterRepo((IProgressMonitor)new SubProgressMonitor(monitor, 0));
            if (repo != null) {
                status = RepoAs.IArtifactGet(repo).existsArtifact(session, artifact, (IProgressMonitor)sm.newChild(1));
                if (StatusCodes.isContentFound(status)) {
                    IArtifactLocator[] myResult = new IArtifactLocator[1];
                    status = RepoAs.IArtifactGet(repo).getArtifactLocator(session, artifact, (IProgressMonitor)sm.newChild(1), myResult);
                    if (result != null) {
                        if (myResult[0] != null) {
                            MasterSetupDiskRepository msdRepo = (MasterSetupDiskRepository)this.getRepository();
                            result[0] = new WrappedLocator(msdRepo.getRepositoryReference(), myResult[0]);
                        } else {
                            result[0] = null;
                        }
                    }
                    IStatus iStatus = status;
                    return iStatus;
                }
                if (status.matches(12)) {
                    IStatus iStatus = status;
                    return iStatus;
                }
            }
            List diskSets = msr.getDiskSets((IProgressMonitor)new SubProgressMonitor(monitor, 0));
            sm.setWorkRemaining(diskSets.size() * 2);
            for (MasterSetupDiskReader.DiskSetInfo diskSet : diskSets) {
                if (!MasterSetupDiskArtifactRepository.isVisible(filter, diskSet)) continue;
                VolumesArtifactTableOfContents.DiskInfo diskInfo = diskSet.getDiskInfo(session, artifact, (IProgressMonitor)sm.newChild(1));
                if (diskInfo != null) {
                    IStatus status2;
                    IRepository diskSetRepo = diskSet.getDiskSetRepository(session, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                    IStatus iStatus = status2 = RepoAs.IArtifactGet(diskSetRepo).getArtifactLocator(session, artifact, (IProgressMonitor)sm.newChild(1), result);
                    return iStatus;
                }
                sm.worked(1);
            }
            IStatus iStatus = AbstractReadArtifactRepo.createArtifactNotFoundStatus(0, this.getRepository(), artifact);
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, e.getStatus(), null);
            return iStatus;
        }
        catch (IOException e) {
            IStatus iStatus = status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, null, (Exception)e);
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IStatus getArtifactFile(IArtifactSession session, IArtifact artifact, IPath destination, IProgressMonitor monitor) {
        IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter = null;
        return this.getArtifactFile(filter, session, artifact, destination, monitor);
    }

    private IStatus getArtifactFile(IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter, IArtifactSession session, IArtifact artifact, IPath destination, IProgressMonitor monitor) {
        IStatus status;
        ICicStatus statusDestination = FileUtil.checkDestination(destination.toFile());
        if (!statusDestination.isOK()) {
            return statusDestination;
        }
        MasterSetupDiskReader msr = this.getMasterReader();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        try {
            IRepository repo = msr.getMasterRepo((IProgressMonitor)new SubProgressMonitor(monitor, 0));
            if (repo != null) {
                status = RepoAs.IArtifactGet(repo).existsArtifact(session, artifact, (IProgressMonitor)sm.newChild(1));
                if (StatusCodes.isContentFound(status)) {
                    IStatus iStatus = RepoAs.IArtifactGet(repo).getArtifactFile(session, artifact, destination, (IProgressMonitor)sm.newChild(1));
                    return iStatus;
                }
                if (status.matches(12)) {
                    IStatus iStatus = status;
                    return iStatus;
                }
            }
            List diskSets = msr.getDiskSets((IProgressMonitor)new SubProgressMonitor(monitor, 0));
            sm.setWorkRemaining(diskSets.size() * 2);
            for (MasterSetupDiskReader.DiskSetInfo diskSet : diskSets) {
                if (!MasterSetupDiskArtifactRepository.isVisible(filter, diskSet)) continue;
                VolumesArtifactTableOfContents.DiskInfo diskInfo = diskSet.getDiskInfo(session, artifact, (IProgressMonitor)sm.newChild(1));
                if (diskInfo != null) {
                    IStatus status2;
                    IRepository diskSetRepo = diskSet.getDiskSetRepository(session, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                    IStatus iStatus = status2 = RepoAs.IArtifactGet(diskSetRepo).getArtifactFile(session, artifact, destination, (IProgressMonitor)sm.newChild(1));
                    return iStatus;
                }
                sm.worked(1);
            }
            IStatus iStatus = AbstractReadArtifactRepo.createArtifactNotFoundStatus(4, this.getRepository(), artifact);
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, e.getStatus(), null);
            return iStatus;
        }
        catch (IOException e) {
            IStatus iStatus = status = AbstractReadArtifactRepo.createGetArtifactLocatorError(artifact, null, (Exception)e);
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return IReadArtifactRepo.IArtifactTocCapabilities.NOT_SUPPORTED;
    }

    @Override
    public boolean hasArtifactToc(IArtifactSession session, IProgressMonitor monitor) {
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == MasterSetupDiskArtifactRepository.class) {
            return this;
        }
        if (adapter == IMasterSetupDiskExtensions.class) {
            return this;
        }
        if (adapter == IReadArtifactRepo.class) {
            return this;
        }
        if (adapter == IArtifactGet.class) {
            return this;
        }
        if (adapter == IVolumeAccessByDisk.class) {
            return this;
        }
        return null;
    }

    @Override
    public IFilterRepository createFilteredRepositoryView(IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter) {
        return VisibleDiskSetFilteredMasterSetupDiskRepository.create(this.getRepository(), filter);
    }

    @Override
    public IVolumeAccessByDisk getUnfilteredDiskRepo() {
        return this;
    }

    IArtifactGet getArtifactGet(final IRepository filteredRepo, final IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter) {
        return new IArtifactGet(){

            @Override
            public IStatus existsArtifact(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor) {
                return MasterSetupDiskArtifactRepository.this.existsArtifact(filter, session, artifact, monitor);
            }

            @Override
            public IStatus getArtifactFile(IArtifactSession session, IArtifact artifact, IPath destination, IProgressMonitor monitor) {
                return MasterSetupDiskArtifactRepository.this.getArtifactFile(filter, session, artifact, destination, monitor);
            }

            @Override
            public IStatus getArtifactLocator(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor, IArtifactLocator[] result) {
                return MasterSetupDiskArtifactRepository.this.getArtifactLocator(filter, session, artifact, monitor, result);
            }

            @Override
            public IRepository getRepository() {
                return filteredRepo;
            }
        };
    }

    IVolumeAccessByDisk getVolumeAccessByDisk(final IRepository filteredRepo, final IMasterSetupDiskExtensions.VisibleDiskSetsFilter filter) {
        return new IVolumeAccessByDisk(){

            @Override
            public boolean canGetLocatorsFromDisk1(IProgressMonitor monitor) {
                return MasterSetupDiskArtifactRepository.this.canGetLocatorsFromDisk1(monitor);
            }

            @Override
            public boolean disksAvailable(IArtifactSession session, IVolumeAccessByDisk.IDiskSetDisks disks, IProgressMonitor monitor) throws CoreException, IOException {
                if (!MasterSetupDiskArtifactRepository.isVisible(filter, disks.getDiskSet())) {
                    return false;
                }
                return MasterSetupDiskArtifactRepository.this.disksAvailable(session, disks, monitor);
            }

            @Override
            public boolean canFindAvailableDisks() {
                return MasterSetupDiskArtifactRepository.this.canFindAvailableDisks();
            }

            @Override
            public IVolumeAccessByDisk.IDiskSet[] getDiskSets(IArtifactSession session, IProgressMonitor monitor) throws CoreException, IOException {
                IVolumeAccessByDisk.IDiskSet[] allDiskSets = MasterSetupDiskArtifactRepository.this.getDiskSets(session, monitor);
                IVolumeAccessByDisk.IDiskSet[] visibleDiskSets = MasterSetupDiskArtifactRepository.visibleDiskSets(filter, allDiskSets);
                return visibleDiskSets;
            }

            @Override
            public IVolumeAccessByDisk.IDiskSet[] getPackageDiskSets(IArtifactSession session, IOfferingOrFix pkg, IProgressMonitor monitor) throws CoreException, IOException {
                return MasterSetupDiskArtifactRepository.this.getPackageDiskSets(filter, session, pkg, monitor);
            }

            @Override
            public void useArtifactLocatorsInOrder(IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
                MasterSetupDiskArtifactRepository.this.useArtifactLocatorsInOrder(filter, session, diskOperation, artifactArgs, options, monitor);
            }

            public void visitArtifactsOnDisk(IArtifactSession session, IVolumeAccessByDisk.IDiskSet[] diskSets, Collection artifacts, IVolumeAccessByDisk.IArtifactOnDiskCallback aodCallback, IProgressMonitor monitor) throws CoreException, IOException {
                if (diskSets == null) {
                    MasterSetupDiskArtifactRepository.this.visitArtifactsOnDisk(session, filter.getDiskSets(), artifacts, aodCallback, monitor);
                } else {
                    IVolumeAccessByDisk.IDiskSet[] visibleDiskSets = MasterSetupDiskArtifactRepository.visibleDiskSets(filter, diskSets);
                    MasterSetupDiskArtifactRepository.this.visitArtifactsOnDisk(session, visibleDiskSets, artifacts, aodCallback, monitor);
                }
            }

            @Override
            public IRepository getRepository() {
                return filteredRepo;
            }
        };
    }
}

