/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.l10n;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractResourceManager {
    private static final String MESSAGES = ".messages";
    static final String KEY_LIST_SEPARATOR = "list.separator";
    static final String KEY_LIST_SEPARATOR_ONLY = "list.separator.only";
    static final String KEY_LIST_SEPARATOR_FIRST = "list.separator.first";
    static final String KEY_LIST_SEPARATOR_LAST = "list.separator.last";
    static final String KEY_LIST_PREFIX = "list.prefix";
    static final String KEY_LIST_SUFFIX = "list.suffix";
    static final String DEFAULT_LIST_SEPARATOR = ", ";
    static final String DEFAULT_LIST_PREFIX = "";
    static final String DEFAULT_LIST_SUFFIX = "";
    private ResourceBundle messagesBundle = null;
    private String messagesBundleName = this.getMessagesBundleDefaultName();

    protected AbstractResourceManager() {
        this.initializeResources();
    }

    protected ResourceBundle getMessagesBundle() {
        return this.messagesBundle;
    }

    protected String getPackageName() {
        return this.getClass().getPackage().getName();
    }

    protected String getMessagesBundleName() {
        return this.messagesBundleName;
    }

    protected abstract Plugin getPlugin();

    protected abstract void initializeResources();

    protected void initializeMessageResources() {
        this.messagesBundle = this.createMessagesBundle();
    }

    protected ResourceBundle createMessagesBundle() {
        try {
            return ResourceBundle.getBundle(this.getMessagesBundleName(), Locale.getDefault(), this.getClass().getClassLoader());
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public String getString(String key) {
        return this.getString(key, key);
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.getMessagesBundle().getString(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public String formatMessage(String patternKey, Object[] args) {
        String pattern = this.getString(patternKey);
        try {
            return MessageFormat.format(pattern, args);
        }
        catch (Exception e) {
            return pattern;
        }
    }

    public String formatList(String[] strings) {
        return this.formatList(Arrays.asList(strings));
    }

    public String formatList(Collection items) {
        return "formatList";
    }

    protected String getMessagesBundleDefaultName() {
        return String.valueOf(this.getPackageName()) + MESSAGES;
    }
}

