/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.core.internal.downloads.LastRates;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.FormatUtil;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.logging.Logger;

public class ProgressMessage {
    private static final String BLANK = "";
    Logger log = Logger.getLogger(ProgressMessage.class);
    private int mbToTransfer;
    private LastRates lastRates;

    public void startTransfer(long bytesTotal) {
        this.mbToTransfer = bytesTotal != -1L ? (int)((double)bytesTotal / 1024.0 / 1024.0 + 0.5) : -1;
        this.lastRates = new LastRates(5);
    }

    public String getRateMessage(int percentDone, long bytesTransferred, long bytesTotal, long bytesPerSecondTotal, long bytesPerLastSecond) {
        String curMsg;
        if (this.lastRates == null) {
            return BLANK;
        }
        long kbps = bytesPerSecondTotal != -1L ? bytesPerSecondTotal / 1024L : -1L;
        long remainingBytes = bytesTotal != -1L ? bytesTotal - bytesTransferred : -1L;
        this.lastRates.add(bytesPerSecondTotal);
        long bpsTrailingAvg = this.lastRates.avg();
        boolean stalled = false;
        if (bpsTrailingAvg != -1L) {
            boolean bl = stalled = bpsTrailingAvg == 0L;
        }
        if ((long)this.mbToTransfer == -1L) {
            curMsg = !stalled ? (kbps != -1L ? NLS.bind(Messages.ProgressMonitorInputStream_unknown_total_kb_datarate, (Object)(bytesTransferred / 1024L), (Object)kbps) : (bytesTransferred == 0L ? BLANK : NLS.bind(Messages.ProgressMonitorInputStream_unknown_total_kb, (Object)(bytesTransferred / 1024L)))) : NLS.bind(Messages.ProgressMonitorInputStream_unknown_total_kb_stalled, (Object)(bytesTransferred / 1024L));
        } else if (this.mbToTransfer == 0) {
            if (!stalled) {
                if (kbps != -1L && kbps != 0L) {
                    long remainingSeconds = remainingBytes / kbps / 1024L;
                    curMsg = NLS.bind(Messages.ProgressMonitorInputStream_pct_1_mb_datarate, percentDone, kbps, FormatUtil.formatTimeSpan(remainingSeconds));
                } else {
                    curMsg = percentDone != 0 ? NLS.bind(Messages.ProgressMonitorInputStream_pct_1_mb, (Object)percentDone) : BLANK;
                }
            } else {
                curMsg = NLS.bind(Messages.ProgressMonitorInputStream_pct_1_mb_stalled, (Object)percentDone);
            }
        } else if (!stalled) {
            if (kbps != -1L && kbps != 0L) {
                long remainingSeconds = remainingBytes / kbps / 1024L;
                curMsg = NLS.bind(Messages.ProgressMonitorInputStream_pct_mb_datarate, percentDone, this.mbToTransfer, kbps, FormatUtil.formatTimeSpan(remainingSeconds));
            } else {
                curMsg = NLS.bind(Messages.ProgressMonitorInputStream_pct_mb, (Object)percentDone, (Object)this.mbToTransfer);
            }
        } else {
            curMsg = NLS.bind(Messages.ProgressMonitorInputStream_pct_mb_stalled, (Object)percentDone, (Object)this.mbToTransfer);
        }
        this.log.debug(curMsg);
        return curMsg;
    }
}

