/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.core.artifactrepo.ValidationPolicy;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.downloads.IDownloadSession;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;

public class DownloadSession
implements IDownloadSession {
    private TempUtil.UniqueTempDir downloadInProgressDir;
    private final ArrayList cics = new ArrayList();
    private ValidationPolicy vp = ValidationPolicy.VP_SILENT;
    private IDownloadSession.IDownloadProgressMonitorFormatter progressFormatter = IDownloadSession.IDownloadProgressMonitorFormatter.DEFAULT_PROGRESS_FORMATTER;

    @Override
    public void log(IStatus status) {
        log.debug(status);
    }

    @Override
    public synchronized void close() {
        this.cics.clear();
        if (this.downloadInProgressDir != null) {
            this.downloadInProgressDir.cleanEmptyDirsLogIOE();
        }
    }

    @Override
    public TempUtil.UniqueTempDir getDownloadInProgressDir() {
        return this.downloadInProgressDir;
    }

    @Override
    public void setDownloadInProgressDir(TempUtil.UniqueTempDir downloadInProgressDir) {
        this.downloadInProgressDir = downloadInProgressDir;
    }

    @Override
    public ValidationPolicy getValidationPolicy() {
        return this.vp;
    }

    @Override
    public void setValidationPolicy(ValidationPolicy vp) {
        if (vp == null) {
            throw new NullPointerException();
        }
        this.vp = vp;
    }

    @Override
    public synchronized ContentInfoComputation getContentInfoComputer() {
        if (this.cics.isEmpty()) {
            return new ContentInfoComputation(new byte[4096]);
        }
        ContentInfoComputation cic = (ContentInfoComputation)this.cics.remove(this.cics.size() - 1);
        return cic;
    }

    @Override
    public synchronized void releaseContentInfoComputer(ContentInfoComputation cic) {
        if (cic == null) {
            throw new NullPointerException();
        }
        this.cics.add(cic);
    }

    @Override
    public IDownloadSession.IDownloadProgressMonitorFormatter getProgressFormatter() {
        return this.progressFormatter;
    }

    @Override
    public void setProgressFormatter(IDownloadSession.IDownloadProgressMonitorFormatter formatter) {
        this.progressFormatter = formatter;
    }
}

