/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.downloads.CredentialStoreEntry;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.XMLParser;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.logging.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CredentialStoreParser
extends XMLParser {
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 2;
    private static final int CREDENTIAL_STORE_STATE = 3;
    private static final int ENTRY_STATE = 4;
    private static final int PROTOCOL_ENTRY_STATE = 5;
    private static final int HOST_ENTRY_STATE = 6;
    private static final int PORT_ENTRY_STATE = 7;
    private static final int REALM_ENTRY_STATE = 8;
    private static final int SCHEME_ENTRY_STATE = 9;
    private static final int PROXY_ENTRY_STATE = 10;
    private List entries = null;
    protected Logger log = Logger.getLogger(this.getClass(), (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    public static final String CREDENTIAL_STORE = "store";
    public static final String ENTRY = "entry";
    public static final String PROTOCOL = "protocol";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String REALM = "realm";
    public static final String SCHEME = "scheme";
    public static final String PROXY_TYPE = "proxy";

    public CredentialStoreParser(BundleContext context, String pluginId) {
        super(context, pluginId);
        this.stateStack = new XMLParser.StateStack();
        this.status = Statuses.ST.createMultiStatus();
    }

    @Override
    protected String getErrorMessage() {
        return Messages.CredentialStoreParser_parsing_error;
    }

    @Override
    protected Logger getLogger() {
        return this.log;
    }

    @Override
    public Object getRootObject() {
        return this.entries;
    }

    @Override
    public void unexpectedAttribute(String element, String attribute, String value) {
        super.unexpectedAttribute(element, attribute, value);
        this.entries = null;
    }

    @Override
    public void unexpectedCharacterData(String cdata) {
        super.unexpectedCharacterData(cdata);
        this.entries = null;
    }

    @Override
    public void unexpectedElement(String element, Attributes attributes) {
        super.unexpectedElement(element, attributes);
        this.entries = null;
    }

    @Override
    protected void unexpectedElementError(String element, Attributes attributes) {
        super.unexpectedElementError(element, attributes);
        this.entries = null;
    }

    public List parse(IPath path) throws ParserConfigurationException, SAXException, IOException {
        return this.parse(new FileInputStream(path.toFile()));
    }

    public List parse(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = this.getParser();
        parser.parse(stream, (DefaultHandler)this);
        return (List)this.getRootObject();
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.stateStack.clear();
        this.stateStack.push(2, null);
    }

    @Override
    protected String processCharacters(String trimmedChars) {
        switch (this.stateStack.peekState()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.setValue(trimmedChars);
                break;
            }
            default: {
                this.unexpectedCharacterData(trimmedChars);
            }
        }
        return trimmedChars;
    }

    protected void setValue(String trimmedChars) {
        Object obj = this.stateStack.peekObject();
        if (obj instanceof StringBuffer) {
            StringBuffer buf = (StringBuffer)this.stateStack.peekObject();
            buf.append(trimmedChars);
        }
    }

    @Override
    public void startElement(String uri, String name, String qname, Attributes attributes) {
        if (!this.status.isOK()) {
            return;
        }
        this.finishCharacters();
        switch (this.stateStack.peekState()) {
            case 0: {
                this.stateStack.push(0, "error: " + name);
                break;
            }
            case 2: {
                this.handleInitialState(name, attributes);
                break;
            }
            case 3: {
                this.handleCredentialStoreState(name, attributes);
                break;
            }
            case 4: {
                this.handleEntryState(name, attributes);
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.finishCharacters();
        int state = this.stateStack.peekState();
        Object obj = this.stateStack.peekObject();
        this.stateStack.pop();
        this.handleEndElementStates(state, obj);
    }

    protected void handleEndElementStates(int state, Object obj) {
        Object parentObject = this.stateStack.peekObject();
        switch (state) {
            case 5: {
                CredentialStoreEntry entry = (CredentialStoreEntry)parentObject;
                entry.setProtocol(((StringBuffer)obj).toString());
                break;
            }
            case 6: {
                CredentialStoreEntry entry = (CredentialStoreEntry)parentObject;
                entry.setHost(((StringBuffer)obj).toString());
                break;
            }
            case 7: {
                CredentialStoreEntry entry = (CredentialStoreEntry)parentObject;
                entry.setPort(this.safeInt(((StringBuffer)obj).toString()));
                break;
            }
            case 8: {
                CredentialStoreEntry entry = (CredentialStoreEntry)parentObject;
                entry.setRealm(((StringBuffer)obj).toString());
                break;
            }
            case 9: {
                CredentialStoreEntry entry = (CredentialStoreEntry)parentObject;
                entry.setScheme(((StringBuffer)obj).toString());
                break;
            }
            case 10: {
                CredentialStoreEntry entry = (CredentialStoreEntry)parentObject;
                this.handleProxy(entry, ((StringBuffer)obj).toString());
                break;
            }
            case 4: {
                List list = (List)parentObject;
                list.add(obj);
                break;
            }
            case 3: {
                this.entries = (List)obj;
                break;
            }
        }
    }

    protected void handleProxy(CredentialStoreEntry entry, String value) {
        entry.setProxyType(this.getProxyType(value));
    }

    private CredentialStoreEntry.ProxyType getProxyType(String proxy) {
        if (proxy.equalsIgnoreCase(CredentialStoreEntry.ProxyType.SOCKS_PROXY.getName())) {
            return CredentialStoreEntry.ProxyType.SOCKS_PROXY;
        }
        if (proxy.equalsIgnoreCase(CredentialStoreEntry.ProxyType.HTTP_PROXY.getName())) {
            return CredentialStoreEntry.ProxyType.HTTP_PROXY;
        }
        return CredentialStoreEntry.ProxyType.NO_PROXY;
    }

    private int safeInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected void handleEntryState(String name, Attributes attributes) {
        if (name.equals(PROTOCOL)) {
            this.stateStack.push(5, new StringBuffer());
        } else if (name.equals(HOST)) {
            this.stateStack.push(6, new StringBuffer());
        } else if (name.equals(PORT)) {
            this.stateStack.push(7, new StringBuffer());
        } else if (name.equals(REALM)) {
            this.stateStack.push(8, new StringBuffer());
        } else if (name.equals(SCHEME)) {
            this.stateStack.push(9, new StringBuffer());
        } else if (name.equals(PROXY_TYPE)) {
            this.stateStack.push(10, new StringBuffer());
        } else {
            this.unexpectedElementError(name, attributes);
            return;
        }
    }

    private void handleCredentialStoreState(String name, Attributes attributes) {
        if (!name.equals(ENTRY)) {
            this.unexpectedElementError(name, attributes);
            return;
        }
        CredentialStoreEntry entry = this.createCredentialStoreEntry();
        this.stateStack.push(4, entry);
    }

    protected CredentialStoreEntry createCredentialStoreEntry() {
        return new CredentialStoreEntry();
    }

    private void handleInitialState(String name, Attributes attributes) {
        if (!name.equals(CREDENTIAL_STORE)) {
            this.unexpectedElementError(name, attributes);
            return;
        }
        this.entries = new LinkedList();
        this.stateStack.push(3, this.entries);
    }
}

