/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.FileContentLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractArtifactLocator;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class FileArtifactLocator
extends AbstractArtifactLocator {
    private final File file;

    public FileArtifactLocator(IRepository artifactRepoInstance, IArtifact locatorArtifactWithAtocContentInfo, IContentInfo expectedContentInfo, File file) {
        super(artifactRepoInstance, locatorArtifactWithAtocContentInfo, expectedContentInfo);
        this.file = file;
    }

    @Override
    public UserNames getUserNames() {
        return new UserNames(this.getLogicalName(), this.file.toString());
    }

    @Override
    public IStatus validateExists(int severity, IProgressMonitor monitor) {
        return FileContentLocator.validateFileExists(severity, this.getArtifactRepository().getUserNames(), this, this.file);
    }

    public URL getWebURL() {
        return null;
    }

    @Override
    public File revealFile() {
        return this.file;
    }

    @Override
    protected IDownloadedFile doDownloadToFileNoValidationNoResumeRetry(IDownloadSession session, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
        return FileContentLocator.downloadToFileNoValidationNoResumeRetry(this, session, this.file, destination, transferPerformance, progress, outReadBytes);
    }

    @Override
    public String toString() {
        String s = super.toString();
        return String.valueOf(s) + " at " + this.file.toString();
    }
}

