/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.ArtifactProgressFormatter;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionSettings;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.ValidationPolicy;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactSessionAtoc;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.artifactrepo.ArtifactSessionSettings;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.IndentWriter;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ArtifactSession
implements IArtifactSession,
IArtifactSessionAtoc {
    private ArtifactSessionSettings settings = new ArtifactSessionSettings();
    private final ArrayList cics = new ArrayList();
    private final HashMap artifactTocs = new HashMap();
    private final Set logListeners = new HashSet(5);
    public static final IReadArtifactRepo.IArtifactToc ATOC_UNAVAILABLE = new IReadArtifactRepo.IArtifactToc(){

        @Override
        public IReadArtifactRepo.ISummary getSummary() {
            return null;
        }

        @Override
        public List getContainedCategories() {
            return null;
        }

        @Override
        public List getContents(IDownloadSession session, IReadArtifactRepo.ICategory category, IProgressMonitor monitor) {
            return null;
        }

        @Override
        public IArtifact getTocArtifact(IDownloadSession session, IArtifactKey key, IProgressMonitor monitor) {
            return null;
        }

        @Override
        public IContentInfo getArtifactInfo(IDownloadSession session, IArtifactKey key, IProgressMonitor monitor) {
            return null;
        }

        @Override
        public Version getVersion() {
            return null;
        }
    };

    public void addLogListener(ILogListener listener) {
        this.logListeners.add(listener);
    }

    protected ArtifactSession() {
    }

    public void removeLogListener(ILogListener listener) {
        this.logListeners.remove(listener);
    }

    public Bundle getBundle() {
        return ComIbmCicCommonCorePlugin.getDefault().getBundle();
    }

    @Override
    public void log(IStatus status) {
        this.log(status, false);
    }

    public void log(IStatus status, boolean logWithPlugin) {
        if (logWithPlugin) {
            ComIbmCicCommonCorePlugin.log(status);
        }
        for (ILogListener listener : this.logListeners) {
            try {
                listener.logging(status, Statuses.pluginId);
            }
            catch (Throwable t) {
                ExceptionUtil.debugLogToReview(t);
            }
        }
    }

    @Override
    public synchronized void close() {
        this.cics.clear();
        this.artifactTocs.clear();
        TempUtil.UniqueTempDir dipRoot = this.settings.getDownloadInProgressDir();
        if (dipRoot != null) {
            dipRoot.cleanEmptyDirsLogIOE();
        }
    }

    @Override
    public synchronized ContentInfoComputation getContentInfoComputer() {
        if (this.cics.isEmpty()) {
            return new ContentInfoComputation(new byte[4096]);
        }
        ContentInfoComputation cic = (ContentInfoComputation)this.cics.remove(this.cics.size() - 1);
        return cic;
    }

    @Override
    public synchronized void releaseContentInfoComputer(ContentInfoComputation cic) {
        if (cic == null) {
            throw new NullPointerException();
        }
        this.cics.add(cic);
    }

    public static IArtifactSessionAtoc asSessionAtoc(IArtifactSession session) {
        return (IArtifactSessionAtoc)((Object)session);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc getArtifactToc(IReadArtifactRepo repo) {
        IReadArtifactRepo.IArtifactToc atoc = (IReadArtifactRepo.IArtifactToc)this.artifactTocs.get(repo);
        return atoc;
    }

    @Override
    public void setArtifactToc(IReadArtifactRepo repo, IReadArtifactRepo.IArtifactToc atoc) {
        if (atoc == null) {
            this.artifactTocs.remove(repo);
        } else {
            this.artifactTocs.put(repo, atoc);
        }
    }

    @Override
    public IArtifactSessionSettings getSettings() {
        return this.settings;
    }

    @Override
    public void restoreSettings(IArtifactSessionSettings previous) {
        if (previous == null) {
            throw new NullPointerException();
        }
        this.settings = (ArtifactSessionSettings)previous;
    }

    public boolean getUseToc() {
        return this.settings.getUseToc();
    }

    @Override
    public ValidationPolicy getValidationPolicy() {
        return this.settings.getValidationPolicy();
    }

    public void setUseToc(boolean b) {
        this.settings.setUseToc(b);
    }

    @Override
    public void setValidationPolicy(ValidationPolicy vp) {
        this.settings.setValidationPolicy(vp);
    }

    public void dump() {
        IndentWriter iw = new IndentWriter(new PrintWriter(Encodings.DEFAULT.writer(System.out), true));
        iw.enter();
        try {
            Iterator iter = this.artifactTocs.entrySet().iterator();
            while (iter.hasNext()) {
                PrintWriter pw = iw.getPrintWriter();
                Map.Entry entry = iter.next();
                IReadArtifactRepo repo = (IReadArtifactRepo)entry.getKey();
                pw.print("repo=");
                pw.print(repo.toString());
                Object val = entry.getValue();
                if (!(val instanceof ArtifactTableOfContents.TocHolder)) continue;
                ArtifactTableOfContents.TocHolder tocHolder = (ArtifactTableOfContents.TocHolder)val;
                tocHolder.dump(iw, false);
            }
        }
        finally {
            iw.leave();
        }
    }

    @Override
    public TempUtil.UniqueTempDir getDownloadInProgressDir() {
        return this.settings.getDownloadInProgressDir();
    }

    @Override
    public void setDownloadInProgressDir(TempUtil.UniqueTempDir dir) {
        this.settings.setDownloadInProgressDir(dir);
    }

    @Override
    public IDownloadSession.IDownloadProgressMonitorFormatter getProgressFormatter() {
        return this.settings.getProgressFormatter();
    }

    @Override
    public void setProgressFormatter(IDownloadSession.IDownloadProgressMonitorFormatter formatter) {
        this.settings.setProgressFormatter((ArtifactProgressFormatter.IArtifactProgressMonitorFormatter)formatter);
    }
}

