/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.internal.artifactrepo.ArtifactOperationRecord;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ArtifactRecords
implements IMultiArtifactOperationArguments {
    private final LinkedList records = new LinkedList();
    private IStatus failedStatus = Status.OK_STATUS;

    @Override
    public IArtifactOperation.IArtifactOperationRecord addInput(IArtifactOperation.IArtifactOperationInput request) {
        ArtifactOperationRecord record = new ArtifactOperationRecord(request);
        this.addArtifactOperationRecord(record);
        return record;
    }

    private void addArtifactOperationRecord(IArtifactOperation.IArtifactOperationRecord newRecord) {
        this.records.add(newRecord);
    }

    @Override
    public void addRecord(IArtifactOperation.IArtifactOperationRecord record) {
        this.addArtifactOperationRecord(record);
    }

    public void addRecords(Collection arecords) {
        this.records.addAll(arecords);
    }

    public List getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public List getModifiableRecords() {
        return this.records;
    }

    @Override
    public IStatus getFailedOperationStatus() {
        return this.failedStatus;
    }

    @Override
    public void setFailedOperationStatus(IStatus status) {
        this.failedStatus = status;
    }

    @Override
    public boolean isCanceled() {
        return this.failedStatus.getSeverity() == 8;
    }

    @Override
    public void setCanceled() {
        this.failedStatus = Status.CANCEL_STATUS;
    }

    @Override
    public IArtifactOperation.IArtifactOperationRecord getRecord(int index) {
        return (IArtifactOperation.IArtifactOperationRecord)this.records.get(index);
    }

    @Override
    public int getRecordCount() {
        return this.records.size();
    }
}

