/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal;

import com.ibm.cic.common.core.internal.IMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MessageCollector {
    private static final String MESSAGES = "messages";
    private final List<IMessage> messages;

    public MessageCollector() {
        this(3);
    }

    public MessageCollector(int initialSize) {
        this.messages = new ArrayList<IMessage>(initialSize);
    }

    public Collection<IMessage> getMessages() {
        return Collections.unmodifiableCollection(this.messages);
    }

    public void addMessage(int level, String id, String message) {
        this.messages.add(new Message(level, id, message));
    }

    public IMessage getFirstMessageOfType(int level) {
        for (IMessage message : this.messages) {
            if (level != message.getMessageType()) continue;
            return message;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.messages.size() == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messages == null ? 0 : this.messages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageCollector other = (MessageCollector)obj;
        return !(this.messages == null ? other.messages != null : !this.messages.equals(other.messages));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(MESSAGES).append("=").append(this.messages.toString());
        return sb.toString();
    }

    private class Message
    implements IMessage {
        private static final String LEVEL = "level";
        private static final String MESSAGE = "message";
        private static final String ID = "id";
        private final String id;
        private final String message;
        private final int level;

        Message(int level, String id, String message) {
            this.message = message;
            this.id = id;
            this.level = level;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public int getMessageType() {
            return this.level;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + this.level;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Message other = (Message)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.level != other.level) {
                return false;
            }
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }

        private MessageCollector getOuterType() {
            return MessageCollector.this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append(LEVEL).append("=").append(this.level).append(",").append(ID).append("=").append(this.id).append(",").append(MESSAGE).append("=").append(this.message);
            return sb.toString();
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

