/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal;

import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public abstract class BoundToOfferingOrFixFactory {
    private static final String ATT_OFFERING_ID = "offeringId";
    private static final String ATT_OFFERING_VERSION = "offeringVersion";
    private static final String ATT_FIX_ID = "fixId";
    private static final String ATT_FIX_VERSION = "fixVersion";

    protected abstract Comparable createBindingEntry(IConfigurationElement var1);

    protected SortedMap findOfferingOrFixBindings(IOfferingOrFix offeringOrFix, String offeringTag, String fixTag, IExtension[] extensions) {
        TreeMap<Comparable, IExtension> result = new TreeMap<Comparable, IExtension>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                Comparable bindingEntry;
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (BoundToOfferingOrFixFactory.elementMatches(element, offeringTag, fixTag, offeringOrFix) && (bindingEntry = this.createBindingEntry(element)) != null) {
                    result.put(bindingEntry, extension);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    protected IConfigurationElement[] findByTagAndAttr(String tagName, String attrName, String attrValue, IExtension extension) {
        IConfigurationElement[] elements;
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (tagName.equals(element.getName()) && attrValue.equals(element.getAttribute(attrName))) {
                result.add(element);
            }
            ++n2;
        }
        return result.toArray(new IConfigurationElement[result.size()]);
    }

    private static boolean elementMatches(IConfigurationElement element, String offeringTag, String fixTag, IOfferingOrFix offeringOrFix) {
        String attVersion;
        String attId;
        String tag;
        if (offeringOrFix instanceof IOffering) {
            tag = offeringTag;
            attId = ATT_OFFERING_ID;
            attVersion = ATT_OFFERING_VERSION;
        } else {
            tag = fixTag;
            attId = ATT_FIX_ID;
            attVersion = ATT_FIX_VERSION;
        }
        return element.getName().equals(tag) && CommonSharedUIUtils.offeringOrFixMatches(offeringOrFix, element.getAttribute(attId), element.getAttribute(attVersion));
    }
}

