/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdLine;
import com.ibm.cic.common.core.cmd.CmdCommand;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.UidUtil;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class CmdUtils {
    private CmdUtils() {
    }

    public static String toListParam(String ... elems) {
        return CmdUtils.toListParam(Arrays.asList(elems));
    }

    public static String toListParam(Collection<String> list) {
        return Util.toString(list, new Util.Formatter(","));
    }

    public static String toMapParam(String key, String value) {
        return String.valueOf(key) + "=" + value;
    }

    public static String toMapParam(Map<String, String> map) {
        return Util.toString(map, new Util.MapFormatter("=", ","){

            @Override
            protected String formatValue(Object value) {
                return ((String)value).replaceAll(",", ",,");
            }
        });
    }

    public static void output(ACmdLine cl, PrintWriter outWriter, String content) {
        outWriter.print(content);
        outWriter.flush();
    }

    public static IProgressMonitor consoleMonitor(ACmdLine cl) {
        Object monitor = cl.containsCommand("-showVerboseProgress") ? ConsoleProgressMonitor.createVerboseMonitor() : (cl.containsCommand("-showProgress") ? ConsoleProgressMonitor.createMonitor() : new NullProgressMonitor());
        return monitor;
    }

    public static IProgressMonitor consoleMonitorWithUnknownWork(ACmdLine cl) {
        Object monitor = cl.containsCommand("-showVerboseProgress") ? ConsoleProgressMonitor.createVerboseMonitor() : (cl.containsCommand("-showProgress") ? ConsoleProgressMonitor.createMonitorWithUnknownWork() : new NullProgressMonitor());
        return monitor;
    }

    public static void reportSuccessFailureToOutput(boolean reportSuccess, IStatus result, PrintWriter outWriter) {
        if (StatusUtil.isErrorOrCancel(result)) {
            outWriter.println(Messages.CmdUtils_failedToComplete);
        } else if (reportSuccess) {
            outWriter.println(Messages.CmdUtils_completeSuccess);
        }
    }

    public static void reportNotOKResult(IStatus result, PrintWriter outWriter, PrintWriter errWriter) {
        assert (!result.isOK());
        if (!result.isOK()) {
            if (result.matches(12)) {
                CmdUtils.printNotOKStatus(result, 0, errWriter);
            } else {
                CmdUtils.printNotOKStatus(result, 0, outWriter);
            }
        }
    }

    private static void printNotOKStatus(IStatus status, int indent, PrintWriter writer) {
        IStatus[] children;
        Throwable e;
        if (status.isOK()) {
            return;
        }
        String message = status.getMessage();
        String uid = UidUtil.getUid(status);
        if (message != null && message.length() > 0) {
            if (status.getSeverity() == 4) {
                CmdUtils.printMessage(NLS.bind((String)Messages.CmdUtils_error, (Object)message), indent, uid, writer);
            }
            if (status.getSeverity() == 2) {
                CmdUtils.printMessage(NLS.bind((String)Messages.CmdUtils_warning, (Object)message), indent, uid, writer);
            }
            ++indent;
        }
        if ((e = status.getException()) != null) {
            CmdUtils.printMessage(e.getLocalizedMessage(), indent, uid, writer);
            ++indent;
        }
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            CmdUtils.printNotOKStatus(element, indent, writer);
            ++n2;
        }
    }

    static int compareCommands(CmdCommand arg0, CmdCommand arg1) {
        String id1;
        String id0 = arg0.id();
        if (id0.equals(id1 = arg1.id())) {
            return 0;
        }
        if (id0.equals("help")) {
            return -1;
        }
        if (id1.equals("help")) {
            return 1;
        }
        if (id0.charAt(0) == '-' && id1.charAt(0) != '-') {
            return 1;
        }
        if (id0.charAt(0) != '-' && id1.charAt(0) == '-') {
            return -1;
        }
        return id0.compareToIgnoreCase(id1);
    }

    private static void printMessage(String message, int indent, String uid, PrintWriter writer) {
        String INDENT = "  ";
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < indent) {
            output.append("  ");
            ++i;
        }
        if (uid != null) {
            output.append(uid);
            output.append(" ");
        }
        output.append(message);
        writer.println(output);
    }
}

