/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdParam;
import com.ibm.cic.common.core.cmd.CmdIterator;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CmdParamList
extends ACmdParam {
    private List<String> value = null;

    public CmdParamList(String id, String header) {
        super(id, header);
    }

    @Override
    public CmdParamList makeCopy() {
        assert (this.value == null);
        return new CmdParamList(this.id(), this.getHeader());
    }

    @Override
    public Object getObjVal() {
        return this.value;
    }

    @Override
    protected IStatus loadCommandLineData(CmdIterator cmdData, boolean testOnly) {
        this.value = CmdParamList.splitParamValue(cmdData.getCurrentArg());
        if (this.value.isEmpty()) {
            return Statuses.ERROR.get(8006, Messages.Cmd_Error_Incorrect_Parameter_Format, this.id(), cmdData.getCurrentArg());
        }
        if (!testOnly) {
            this.setStrValue(cmdData.getCurrentArg());
            cmdData.consumeCurrentArg();
        }
        return Status.OK_STATUS;
    }

    @Override
    public void reset() {
        super.reset();
        this.value.clear();
    }

    private static List<String> splitParamValue(String value) {
        if ("".equals(value)) {
            return Collections.emptyList();
        }
        String SEPARATOR = ",";
        String REPLACEMENT = "\u0000";
        String replaced = Pattern.compile(",,", 16).matcher(value).replaceAll(REPLACEMENT);
        String[] split = Pattern.compile(SEPARATOR, 16).split(replaced);
        ArrayList<String> result = new ArrayList<String>(split.length);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            result.add(a.replaceAll(REPLACEMENT, SEPARATOR));
            ++n2;
        }
        return result;
    }
}

