/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.AbstractModifyArtifactsAndUpdateToc;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.SingleArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactTocUpdate;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.StatusCodes;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class RemoveArtifacts
extends AbstractModifyArtifactsAndUpdateToc {
    public static final RemoveArtifacts INSTANCE = new RemoveArtifacts();

    protected RemoveArtifacts() {
        super(false);
    }

    public static IArtifactOperation.IArtifactOperationInput createRemoveRequest(IArtifactLocator locator) {
        return new RemoveInput(locator);
    }

    @Override
    protected boolean doSingleRecord(AbstractModifyArtifactsAndUpdateToc.Context context, IReadArtifactRepo repo, IArtifactSession session, SingleArtifactOperationOptions options, IArtifactOperation.IArtifactOperationRecord record, IProgressMonitor monitor) {
        IArtifactOperation.IArtifactOperationInput input = record.getInput();
        if (input instanceof RemoveInput) {
            RemoveInput removeInput = (RemoveInput)input;
            IStatus status = RepoAs.IArtifactWrite(repo).removeArtifactNoTocUpdate(session, removeInput.getLocator(), monitor);
            record.getHistory().setHistoryStatus(session, status);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuccessRecord(IArtifactOperation.IArtifactOperationRecord record) {
        IStatus status = record.getLastStatus();
        if (StatusCodes.isContentNotFound(status)) {
            return true;
        }
        if (status.matches(12)) {
            return false;
        }
        return status != IArtifactOperation.STATUS_OK_REQUESTED;
    }

    @Override
    protected IStatus doUpdateToc(IArtifactTocUpdate tocUpdate, IArtifactSession session, IArtifact[] artifacts, IProgressMonitor monitor) {
        IStatus status = tocUpdate.updateArtifactTocRemove(session, artifacts, monitor);
        return status;
    }

    @Override
    protected IArtifact getArtifactForToc(IArtifactOperation.IArtifactOperationRecord record) {
        IArtifactOperation.IArtifactOperationInput input = record.getInput();
        if (input instanceof RemoveInput) {
            RemoveInput removeInput = (RemoveInput)input;
            return removeInput.getLocator().getArtifact();
        }
        return null;
    }

    public static class RemoveInput
    implements IArtifactOperation.IArtifactOperationInput {
        private final IArtifactLocator locator;

        RemoveInput(IArtifactLocator locator) {
            this.locator = locator;
        }

        public IArtifactLocator getLocator() {
            return this.locator;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("locator='");
            sb.append(this.locator.toString());
            sb.append("'");
            return sb.toString();
        }
    }
}

