/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.base.ArtifactsByDiskOperation;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperationMultiple;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractDiskOperation;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactsOnDisksInfo;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DetermineDisksNeeded
extends ArtifactsByDiskOperation {
    protected DetermineDisksNeeded() {
        super(true);
    }

    public static ArtifactsOnDisksInfo execute(IArtifactSession session, IVolumeAccessByDisk diskRep, Collection<IArtifact> artifacts, IProgressMonitor monitor) {
        DetermineDisksNeeded op = new DetermineDisksNeeded();
        ArtifactsOnDisksInfo aod = new ArtifactsOnDisksInfo();
        DetermineDisksNeededContext target = new DetermineDisksNeededContext(diskRep.getRepository(), aod);
        MultiArtifactOperationOptions options = MultiArtifactOperationOptions.newContinueOnErrorOptions();
        IMultiArtifactOperationArguments arguments = op.createArguments();
        for (IArtifact artifact : artifacts) {
            arguments.addInput(new ArtifactInput(artifact));
        }
        op.execute(session, target, options, arguments, monitor);
        return aod;
    }

    @Override
    protected void doExecute(IArtifactSession session, IArtifactOperation.IOperationContext target, IMultiArtifactOperationArguments args, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        DetermineDisksNeededContext context = (DetermineDisksNeededContext)target;
        if (context.getSource() == null) {
            throw new IllegalArgumentException();
        }
        DetermineDisksNeededDiskOperation diskOperation = new DetermineDisksNeededDiskOperation(this, context);
        super.doExecuteDiskOperation(session, diskOperation, target, args, options, monitor);
    }

    private static class ArtifactInput
    implements IArtifactOperation.IArtifactOperationInput {
        private final IArtifact artifact;

        public ArtifactInput(IArtifact artifact) {
            this.artifact = artifact;
        }

        public IArtifact getArtifact() {
            return this.artifact;
        }
    }

    private static class DetermineDisksNeededContext
    extends IArtifactOperation.AbstractOperationContext {
        private final IRepository source;
        private final ArtifactsOnDisksInfo aodi;

        public DetermineDisksNeededContext(IRepository source, ArtifactsOnDisksInfo aodi) {
            this.source = source;
            this.aodi = aodi;
        }

        public IRepository getSource() {
            return this.source;
        }

        public ArtifactsOnDisksInfo getArtifactsOnDisksInfo() {
            return this.aodi;
        }

        @Override
        public void release() {
        }
    }

    private static class DetermineDisksNeededDiskOperation
    extends AbstractDiskOperation
    implements IVolumeAccessByDisk.IDiskOperation {
        private final DetermineDisksNeededContext context;

        DetermineDisksNeededDiskOperation(IArtifactOperationMultiple op, DetermineDisksNeededContext context) {
            super(op);
            this.context = context;
        }

        @Override
        public boolean requiresDiskInserted() {
            return false;
        }

        @Override
        public CicMultiStatus getMultiStatus() {
            String msg = Messages.add_artifacts_failed;
            return Statuses.ST.createMultiStatus(15, msg, new Object[0]);
        }

        @Override
        public IArtifact getArtifact(IArtifactOperation.IArtifactOperationRecord record) {
            IArtifactOperation.IArtifactOperationInput input = record.getInput();
            if (input instanceof ArtifactInput) {
                ArtifactInput ai = (ArtifactInput)input;
                return ai.getArtifact();
            }
            return null;
        }

        @Override
        public IRepository getSourceRepo(IArtifactOperation.IOperationContext ctxt) {
            return ((DetermineDisksNeededContext)ctxt).getSource();
        }

        @Override
        public IArtifactOperation.IOperationContext getSubContext(IRepository repo) {
            return new DetermineDisksNeededContext(repo, this.context.getArtifactsOnDisksInfo());
        }

        @Override
        public IStatus useDisk(IArtifactSession session, IRepository repo, IVolumeAccessByDisk.IDisk disk, IVolumeAccessByDisk.IDiskSetDisks allUsedDisks, IMultiArtifactOperationArguments diskArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
            ArtifactsOnDisksInfo aods = this.context.getArtifactsOnDisksInfo();
            ArtifactsOnDisksInfo.ArtifactsOnDiskInfo aod = new ArtifactsOnDisksInfo.ArtifactsOnDiskInfo(disk, diskArgs.getRecordCount());
            for (IArtifactOperation.IArtifactOperationRecord record : diskArgs.getRecords()) {
                IArtifact artifact = this.getArtifact(record);
                if (artifact != null) {
                    aod.addArtifact(artifact);
                }
                record.getHistory().setHistoryStatus(session, Status.OK_STATUS);
            }
            aods.putArtifactsOnDisk(disk, aod);
            return Status.OK_STATUS;
        }
    }
}

