/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionSettings;
import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactFormatterUtil;
import com.ibm.cic.common.downloads.IDownloadSession;

public class ArtifactProgressFormatter {
    private IArtifactSession session;
    private IArtifactProgressMonitorFormatter prevFormatter;

    public static ArtifactProgressFormatter startFormatWithIdOnly(IArtifactSession session) {
        return new ArtifactProgressFormatter(session, 2);
    }

    private ArtifactProgressFormatter(IArtifactSession session, final int formatOptions) {
        this.session = session;
        IArtifactSessionSettings settings = session.getSettings();
        this.prevFormatter = settings.getProgressFormatter();
        settings.setProgressFormatter(new IArtifactProgressMonitorFormatter(){

            @Override
            public String format(IContentLocator locator) {
                String result = null;
                if (locator instanceof IArtifactLocator) {
                    IArtifactLocator aloc = (IArtifactLocator)locator;
                    result = ArtifactFormatterUtil.toUserString(aloc.getArtifactKey(), formatOptions);
                }
                if (result == null) {
                    result = DEFAULT_PROGRESS_FORMATTER.format(locator);
                }
                return result;
            }
        });
    }

    public void restorePrevious() {
        this.session.getSettings().setProgressFormatter(this.prevFormatter);
    }

    public static interface IArtifactProgressMonitorFormatter
    extends IDownloadSession.IDownloadProgressMonitorFormatter {
        public static final IArtifactProgressMonitorFormatter DEFAULT_PROGRESS_FORMATTER = new IArtifactProgressMonitorFormatter(){

            @Override
            public String format(IContentLocator locator) {
                return locator.getUserNames().getLogicalName();
            }
        };

        @Override
        public String format(IContentLocator var1);
    }
}

