/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.antInstallAdapter.tasks;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.antInstallAdapter.ant.AntProgress;
import com.ibm.cic.common.commonNativeAdapterData.CommonNativeAdapterUtils;
import com.ibm.cic.common.core.utils.FileReplicator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressEvent
extends Task {
    private String message;
    private String duration;
    private String resourceBundle;
    private String messageKey;
    private Path classpath = null;
    private final List<String> arguments = new ArrayList<String>();
    private static String progressTaskName = "progressMonitor";

    public static String getProgressTaskName() {
        return progressTaskName;
    }

    public String getTaskName() {
        return super.getTaskName();
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    private int getApproximateDuration() {
        int progressDuration = 0;
        if (this.duration != null && (progressDuration = CommonNativeAdapterUtils.parseTime((String)this.duration)) == -1) {
            progressDuration = 1;
        }
        return progressDuration;
    }

    private ClassLoader getClassLoader() throws BuildException {
        ArrayList<URL> urls;
        URLClassLoader ucl = null;
        FileReplicator javaFileReplicator = Agent.getInstance().getJavaFileReplicator();
        if (this.classpath != null) {
            urls = new ArrayList<URL>();
            String[] stringArray = this.classpath.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                try {
                    File o = new File(path);
                    File f = javaFileReplicator.getReplica(o);
                    urls.add(f.toURI().toURL());
                }
                catch (MalformedURLException mue) {
                    throw new BuildException((Throwable)mue);
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
                ++n2;
            }
        } else {
            return Thread.currentThread().getContextClassLoader();
        }
        ucl = new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
        return ucl;
    }

    public void execute() throws BuildException {
        IProgressMonitor monitor = AntProgress.getInstance().getMonitor();
        String monitorMessage = null;
        if (monitor != null) {
            if (this.message != null) {
                monitorMessage = this.message;
            }
            if (this.messageKey != null && this.resourceBundle != null) {
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(this.resourceBundle, Locale.getDefault(), this.getClassLoader());
                    if (bundle != null) {
                        monitorMessage = bundle.getString(this.messageKey);
                    }
                }
                catch (MissingResourceException e) {
                    throw new BuildException((Throwable)e);
                }
            }
            if (monitorMessage != null) {
                if (!this.arguments.isEmpty()) {
                    monitorMessage = MessageFormat.format(monitorMessage, this.arguments.toArray());
                }
                monitor.subTask(monitorMessage);
            }
            if (this.duration != null) {
                monitor.worked(this.getApproximateDuration());
            }
        }
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void addConfiguredArg(Commandline.Argument argument) {
        String[] stringArray = argument.getParts();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            this.arguments.add(a);
            ++n2;
        }
    }
}

