/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.antInstallAdapter;

import com.ibm.cic.agent.core.antInstallAdapter.AntInstallAdapterPlugin;
import com.ibm.cic.agent.core.antInstallAdapter.Messages;
import com.ibm.cic.agent.core.api.ILogger;
import com.ibm.cic.agent.core.api.IMLogger;
import com.ibm.cic.agent.core.api.IMStatuses;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class Util {
    public static final String EMPTY = "";
    public static final String ANT_LOGLVL_WARN = "warn";
    public static final String ANT_LOGLVL_VERBOSE = "verbose";
    public static final String ANT_LOGLVL_INFO = "info";
    public static final String ANT_LOGLVL_ERROR = "err";
    public static final String ANT_LOGLVL_DEBUG = "debug";
    public static final String ANT_LOGLVL_ERROR_N = "0";
    public static final String ANT_LOGLVL_WARN_N = "1";
    public static final String ANT_LOGLVL_INFO_N = "2";
    public static final String ANT_LOGLVL_VERBOSE_N = "3";
    public static final String ANT_LOGLVL_DEBUG_N = "4";
    public static final String ANT_VAR_ANTFILE = "ant.file";
    public static final String ANT_VAR_PROJHELPER = "ant.projectHelper";
    public static final boolean DEBUG = false;

    public static void antDebug(String msg) {
    }

    public static CoreException coreException(String msg) {
        return new CoreException(Util.errorStatus(msg, null));
    }

    public static CoreException coreException(Throwable e, String msg) {
        return new CoreException(Util.errorStatus(msg, e));
    }

    public static IStatus errorStatus(String msg, Throwable e) {
        return new Status(4, "com.ibm.cic.agent.core.antInstallAdapter", 0, msg, e);
    }

    public static CicMultiStatus antExceptionStatus(IStatus originalStatus, File antFile) {
        CicMultiStatus antErrorStatus = Statuses.ERROR.getMultiStatus(Messages.AntException, new Object[]{antFile.getAbsolutePath()});
        antErrorStatus.add(originalStatus);
        return antErrorStatus;
    }

    public static IStatus getStatus(Project project, File antFile) {
        IStatus status = null;
        String message = project.getProperty("im.status.message");
        String explanation = project.getProperty("im.status.explanation");
        String useraction = project.getProperty("im.status.useraction");
        int severity = Util.getStatusSeverity(project, antFile, message != null);
        String uid = Util.getStatusUid(project, antFile);
        if (message != null && message.trim().length() > 0) {
            switch (severity) {
                case 1: {
                    status = IMStatuses.INFO.get(uid, explanation, useraction, 0, message, new Object[0]);
                    break;
                }
                case 2: {
                    status = IMStatuses.WARNING.get(uid, explanation, useraction, 0, message, new Object[0]);
                    break;
                }
                default: {
                    status = IMStatuses.ERROR.get(uid, explanation, useraction, 0, message, new Object[0]);
                    break;
                }
            }
        } else {
            ArrayList<String> definedProperties = new ArrayList<String>();
            if (explanation != null) {
                definedProperties.add("im.status.explanation");
            }
            if (useraction != null) {
                definedProperties.add("im.status.useraction");
            }
            if (uid != null) {
                definedProperties.add("im.status.uid");
            }
            if (definedProperties.size() > 0) {
                ILogger logger = IMLogger.getLogger(Util.class, (Plugin)AntInstallAdapterPlugin.getDefault());
                logger.warning(Messages.missing_status_message_property, (Object)"im.status.message", (Object)definedProperties.toString());
            }
        }
        return status;
    }

    private static String getStatusUid(Project project, File antFile) {
        String uid = project.getProperty("im.status.uid");
        if (uid != null && !uid.matches("(.*)([E|W|I])")) {
            ILogger logger = IMLogger.getLogger(Util.class, (Plugin)AntInstallAdapterPlugin.getDefault());
            logger.warning((Object)IMStatuses.WARNING.get(Messages.BadUidFormat$uid, Messages.BadUidFormat$explanation, Messages.BadUidFormat$useraction, 0, Messages.BadUidFormat, new Object[]{antFile.getAbsolutePath(), uid}));
        }
        return uid;
    }

    public static int getStatusSeverity(Project project, File antFile, boolean warnIfNotSpecified) {
        String uid;
        int severity = -1;
        String severityValue = project.getProperty("im.status.severity");
        if (severityValue != null && severityValue.length() > 1) {
            String uppercaseSeverityValue = severityValue.toUpperCase();
            if ("ERROR".equals(uppercaseSeverityValue)) {
                severity = 4;
            } else if ("WARNING".equals(uppercaseSeverityValue)) {
                severity = 2;
            } else if ("INFO".equals(uppercaseSeverityValue)) {
                severity = 1;
            }
        }
        if (severity < 0 && (uid = Util.getStatusUid(project, antFile)) != null) {
            String letter = uid.substring(uid.length() - 1).toUpperCase();
            if ("ERROR".startsWith(letter)) {
                severity = 4;
            } else if ("WARNING".startsWith(letter)) {
                severity = 2;
            } else if ("INFO".startsWith(letter)) {
                severity = 1;
            }
        }
        if (severity < 0) {
            if (warnIfNotSpecified) {
                ILogger logger = IMLogger.getLogger(Util.class, (Plugin)AntInstallAdapterPlugin.getDefault());
                logger.warning((Object)IMStatuses.WARNING.get(Messages.BadSeverityFormat$uid, Messages.BadSeverityFormat$explanation, Messages.BadSeverityFormat$useraction, 0, Messages.BadSeverityFormat, new Object[]{antFile.getAbsolutePath(), severityValue}));
            }
            severity = 4;
        }
        return severity;
    }
}

