/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.flexlm;

import com.ibm.cic.licensing.common.core.RegScanner;
import com.ibm.cic.licensing.common.util.PolicyManager;
import com.ibm.cic.licensing.common.util.ProductInformation;
import com.ibm.cic.licensing.flexlm.FlexCheck;
import com.ibm.cic.licensing.flexlm.FlexUsageData;
import com.ibm.cic.licensing.flexlm.FlexUsageDataWriter;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class FlexlmPlugin
extends Plugin {
    public static final String NAME = "com.ibm.cic.licensing.flexlm.FlexlmPlugin";
    private static FlexlmPlugin plugin;

    public FlexlmPlugin() {
        plugin = this;
    }

    public static FlexlmPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (PolicyManager.isFlexEnabled()) {
            File file;
            List pis = RegScanner.getPiList();
            FlexUsageData oldusagedata = FlexCheck.getFlexUsageData();
            FlexUsageData newusagedata = new FlexUsageData();
            Iterator iter = pis.iterator();
            while (iter.hasNext()) {
                ProductInformation pi = (ProductInformation)iter.next();
                new FlexCheck().checkin(pi);
                if (!this.needUpdateTS(pi)) continue;
                String id = pi.getProductId();
                Version version = pi.getProductVersion();
                FlexUsageData.OfferingTagData newofferingdata = new FlexUsageData.OfferingTagData(id, version);
                FlexUsageData.LastUseTagData lastuse = new FlexUsageData.LastUseTagData(pi.getFlexLastUsageTime());
                newofferingdata.addChild(lastuse);
                FlexUsageData.AbstractData[] dataarray = oldusagedata.getRoot().getChildren();
                boolean matchfound = false;
                int i = 0;
                while (i < dataarray.length) {
                    FlexUsageData.OfferingTagData oldofferingdata = (FlexUsageData.OfferingTagData)dataarray[i];
                    if (oldofferingdata.getId().equals(newofferingdata.getId()) && oldofferingdata.getVersion().equals((Object)newofferingdata.getVersion())) {
                        matchfound = true;
                        newusagedata.getRoot().addChild(newofferingdata);
                        oldusagedata.getRoot().removeChild(oldofferingdata);
                    }
                    ++i;
                }
                if (matchfound) continue;
                newusagedata.getRoot().addChild(newofferingdata);
            }
            FlexUsageData.AbstractData[] dataarray = oldusagedata.getRoot().getChildren();
            if (dataarray.length > 0) {
                int i = 0;
                while (i < dataarray.length) {
                    newusagedata.getRoot().addChild(dataarray[i]);
                    ++i;
                }
            }
            if ((file = new File(FlexCheck.getFlexUsageDataPath())).getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FlexUsageDataWriter.write(file, newusagedata);
        }
        super.stop(context);
        plugin = null;
    }

    private boolean needUpdateTS(ProductInformation pi) {
        return pi.getFlexLastUsageTime() != null;
    }
}

