/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.flexlm;

import com.ibm.cic.licensing.common.core.ILicenseCheckProvider;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.PolicyManager;
import com.ibm.cic.licensing.common.util.ProductInformation;
import com.ibm.cic.licensing.flexlm.FlexUsageData;
import com.ibm.cic.licensing.flexlm.FlexUsageDataParser;
import com.ibm.cic.licensing.flexlm.FlexlmPlugin;
import com.ibm.cic.licensing.flexlm.HeartbeatWorker;
import com.ibm.cic.licensing.flexlm.IbmratlInfo;
import com.ibm.cic.licensing.flexlm.Messages;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.macrovision.flexlm.ConnectionData;
import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FeatureSpecifier;
import com.macrovision.flexlm.FeatureUsage;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.License;
import com.macrovision.flexlm.LicenseSource;
import com.macrovision.flexlm.VendorInfo;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class FlexCheck
implements ILicenseCheckProvider {
    public static final long ONE_DAY_IN_MILISEC = 86400000L;
    public static final long THREE_DAYS_IN_MILLISEC = 259200000L;

    public synchronized LicenseStatus checkout(ProductInformation pi) {
        License lic = null;
        LicenseStatus licstatus = new LicenseStatus(pi);
        pi.setLicenseStatus(licstatus);
        licstatus.setLocalizedLicenseType(com.ibm.cic.licensing.common.core.Messages.LicenseType_Floating);
        try {
            lic = FlexCheck.getPiLicense(pi);
            lic.checkout(1);
            int daysleft = FlexCheck.getDaysToExpire(lic);
            licstatus.setDaysToExpire(daysleft);
            String expidate = FlexCheck.getExpirationDateStr(lic);
            licstatus.setExpireDateString(expidate);
            licstatus.setLicenseGranted(true);
            licstatus.setStatusCode(0);
            licstatus.setLocalizedStatusString(com.ibm.cic.licensing.common.core.Messages.Key_Available);
            Feature feat = lic.getFeature();
            if (feat != null) {
                String sCount = feat.getCount();
                int count = 0;
                try {
                    count = Integer.parseInt(sCount);
                }
                catch (NumberFormatException nfe) {
                    count = -1;
                }
                licstatus.setLicensesCount(count);
            }
            if (LicenseStatus.isExpiringSoon((int)daysleft)) {
                licstatus.setStatusCode(1);
                licstatus.setLicenseWillExpire(true);
                licstatus.setLocalizedStatusString(NLS.bind((String)com.ibm.cic.licensing.common.core.Messages.Key_Expires_In_Days, (Object)String.valueOf(daysleft)));
            }
            pi.setLicense((Object)lic);
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((String)("Flexlm check out success for " + pi.getProductName() + " " + pi.getProductVersionStr()));
            }
            this.recordLastUsage(pi);
            return licstatus;
        }
        catch (FlexlmException e) {
            if (e.getMessage().indexOf(String.valueOf(-15)) > 0 && this.isEligibleForDisconnectedUse(pi)) {
                licstatus.setLicenseGranted(true);
                licstatus.setLicenseWillExpire(true);
                licstatus.setStatusCode(4);
                licstatus.setLocalizedStatusString(com.ibm.cic.licensing.common.core.Messages.Running_Disconnected_Mode);
                pi.setLicenseStatus(licstatus);
                if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.logNtrace((String)(String.valueOf(pi.getProductName()) + "is running in disconnected mode"));
                }
                return licstatus;
            }
            licstatus.setStatusCode(2);
            licstatus.setLocalizedStatusString(com.ibm.cic.licensing.common.core.Messages.Key_Not_Available);
            licstatus.setErrException((Exception)((Object)e));
            try {
                licstatus.setErrMsg(e.getLocalizedMessage());
            }
            catch (RuntimeException re) {
                licstatus.setErrMsg("Flexlm internel error: " + e.getMajor());
            }
            pi.setLicenseStatus(licstatus);
            Logger.logNtrace((String)NLS.bind((String)Messages.Flex_Checkout_Failed, (Object)pi.getProductName()), (Exception)((Object)e));
            return licstatus;
        }
        catch (RuntimeException re) {
            licstatus.setStatusCode(2);
            licstatus.setLocalizedStatusString(com.ibm.cic.licensing.common.core.Messages.Key_Not_Available);
            licstatus.setErrException((Exception)re);
            licstatus.setErrMsg(re.getLocalizedMessage());
            pi.setLicenseStatus(licstatus);
            Logger.logNtrace((String)NLS.bind((String)Messages.Flex_Checkout_Failed, (Object)pi.getProductName()), (Exception)re);
            return licstatus;
        }
    }

    public LicenseStatus checkStatus(ProductInformation pi) {
        return this.checkStatusFromTestCheckOut(pi);
    }

    private void recordLastUsage(ProductInformation pi) {
        pi.setFlexLastUsageTime(String.valueOf(new Date().getTime()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEligibleForDisconnectedUse(ProductInformation pi) {
        try {
            LicenseStatus licstatus = pi.getLicenseStatus();
            FlexUsageData data = FlexCheck.getFlexUsageData();
            FlexUsageData.AbstractData[] offeringdatas = data.getRoot().getChildren();
            int i = 0;
            while (true) {
                if (i >= offeringdatas.length) {
                    return false;
                }
                FlexUsageData.OfferingTagData offeringdata = (FlexUsageData.OfferingTagData)offeringdatas[i];
                if (pi.getProductId().equalsIgnoreCase(offeringdata.getId()) && pi.getProductVersion().equals((Object)offeringdata.getVersion())) {
                    String lasttime = offeringdata.getLastUseData().getTime();
                    try {
                        long lasttime_l = Long.parseLong(lasttime);
                        long nowtime_l = new Date().getTime();
                        if (nowtime_l - lasttime_l < 259200000L) {
                            if (licstatus == null) return true;
                            Date expireDate = new Date(lasttime_l + 259200000L);
                            DateFormat dateFormat = DateFormat.getDateInstance();
                            licstatus.setExpireDateString(dateFormat.format(expireDate));
                            float timeleft = expireDate.getTime() - nowtime_l;
                            int daysToExpire = (int)Math.ceil(timeleft / 8.64E7f);
                            licstatus.setDaysToExpire(daysToExpire);
                            return true;
                        }
                    }
                    catch (NumberFormatException e) {
                        Logger.logNtrace((String)"FlexCheck.isEligibleForDisconnectedUse() number format error", (Exception)e);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    private static FlexUsageData parseFlexUsageDataFile() {
        FlexUsageDataParser parser = new FlexUsageDataParser();
        String fullPath = FlexCheck.getFlexUsageDataPath();
        parser.parse(fullPath);
        return parser.getFlexUsageData();
    }

    public static FlexUsageData getFlexUsageData() {
        return FlexCheck.parseFlexUsageDataFile();
    }

    public static String getFlexUsageDataPath() {
        return LicUserUtils.getRuntimeFlexlmTSFile().toOSString();
    }

    public boolean canHandle(String lictype) {
        return lictype != null && lictype.equalsIgnoreCase("FLEX");
    }

    private synchronized LicenseStatus checkStatusFromTestCheckOut(ProductInformation pi) {
        LicenseStatus licstatus;
        block4: {
            if (pi.getLicense() != null) {
                return pi.getLicenseStatus();
            }
            licstatus = this.checkout(pi);
            License lic = (License)pi.getLicense();
            if (lic != null) {
                try {
                    lic.checkin();
                }
                catch (FlexlmException e) {
                    if (!Logger.isTracing((boolean)Logger.DEBUG_EXCEPTIONS)) break block4;
                    Logger.logNtrace((String)(String.valueOf(pi.getProductName()) + " check in failed in status check"), (Exception)((Object)e));
                }
            }
        }
        licstatus.setLicenseGranted(false);
        pi.setLicense(null);
        pi.setLicenseStatus(licstatus);
        return licstatus;
    }

    private static int getDaysToExpire(Feature f) {
        int daysToExpire = f == null ? -1 : f.daysUntilExpiration();
        return daysToExpire;
    }

    private static int getDaysToExpire(License lic) {
        Feature lf = lic.getFeature();
        return FlexCheck.getDaysToExpire(lf);
    }

    private static String getExpirationDateStr(Feature f) {
        String expidate = f.getExpirationDate();
        SimpleDateFormat aDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        Date parsedDate = null;
        try {
            parsedDate = aDateFormat.parse(expidate);
        }
        catch (ParseException pe) {
            return expidate;
        }
        aDateFormat = DateFormat.getDateInstance();
        return aDateFormat.format(parsedDate);
    }

    private static String getExpirationDateStr(License lic) {
        Feature lf = lic.getFeature();
        return FlexCheck.getExpirationDateStr(lf);
    }

    public synchronized boolean checkin(ProductInformation pi) {
        try {
            if (pi.getLicense() != null && pi.getLicense() instanceof License) {
                License lic = (License)pi.getLicense();
                lic.checkin();
                if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.trace((String)("Released Flexlm license key for : " + lic.getFeatureSpecifier().getName() + " " + lic.getFeatureSpecifier().getVersion()));
                }
            }
        }
        catch (FlexlmException e) {
            return false;
        }
        return true;
    }

    public static License getLicense(String licsource, String feature, String version) throws FlexlmException {
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)("FlexCheck getLicense for feature: " + feature + " version: " + version));
        }
        VendorInfo vInfo = FlexCheck.getVendorInfo();
        FeatureSpecifier fs = new FeatureSpecifier(feature, version);
        HeartbeatWorker connData = new HeartbeatWorker();
        License lic = new License(fs, licsource, vInfo, (ConnectionData)connData);
        return lic;
    }

    private static License getPiLicense(ProductInformation pi) throws FlexlmException {
        String licsource = PolicyManager.getLicSource();
        String feature = pi.getFlexFeatureId();
        String version = pi.getFlexVersionId();
        return FlexCheck.getLicense(licsource, feature, version);
    }

    private static VendorInfo getVendorInfo() throws FlexlmException {
        IbmratlInfo vInfo = new IbmratlInfo();
        return vInfo;
    }

    public IStatus testConnection(ProductInformation pi, String serverName, String portNum) {
        Status status = null;
        String pluginID = FlexlmPlugin.getDefault().getBundle().getSymbolicName();
        try {
            VendorInfo vInfo = FlexCheck.getVendorInfo();
            LicensePolicyData.ServerData serverdata = new LicensePolicyData.ServerData(serverName, portNum);
            String flexServer = PolicyManager.getFlexSvrStr((LicensePolicyData.ServerData)serverdata);
            LicenseSource ls = LicenseSource.createLicenseSource((String)flexServer, (VendorInfo)vInfo, null);
            FeatureUsage fu = ls.getFeatureUsage(new FeatureSpecifier(pi.getFlexFeatureId(), pi.getFlexVersionId()));
            status = fu != null ? new Status(1, pluginID, 0, NLS.bind((String)Messages.LicenseServerAvailable, (Object)pi.getProductName()), null) : new Status(2, pluginID, 2, NLS.bind((String)com.ibm.cic.licensing.common.core.Messages.LicenseServerNoKey, (Object)pi.getProductName()), null);
        }
        catch (Exception e) {
            status = new Status(2, pluginID, 2, NLS.bind((String)com.ibm.cic.licensing.common.core.Messages.LicenseServerNotAvailable, (Object)pi.getProductName()), null);
            Logger.log((int)Logger.WARNING, (String)NLS.bind((String)com.ibm.cic.licensing.common.core.Messages.LicenseServerNotAvailable, (Object)pi.getProductName()), (Exception)e);
        }
        return status;
    }

    public LicenseStatus checkStatus(ProductInformation pi, String licenseLocation) {
        return this.checkStatus(pi);
    }

    public boolean configureRCLLogging(String configFileLocation, String logFileLocation, String product, String version, int size, int logLevel, int traceLevel, int maxFiles, boolean enableLogging, boolean enableTracing) {
        return false;
    }
}

