/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.ui.extensions;

import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.SpaceInfoUtils;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.licenses.Messages;
import com.ibm.cic.agent.internal.ui.utils.FeatureViewerSorter;
import com.ibm.cic.agent.internal.ui.utils.InstallAgentUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import com.ibm.ws.sync.core.SyncLocation;
import com.ibm.ws.sync.core.internal.SyncUtil;
import com.ibm.ws.sync.internal.ui.ImportOffering;
import com.ibm.ws.sync.internal.ui.SummaryPackageContentProvider;
import com.ibm.ws.sync.internal.ui.SummaryPackageLabelProvider;
import com.ibm.ws.sync.internal.ui.SyncUIUtil;
import com.ibm.ws.sync.ui.extensions.ImportWASWizard;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ImportWASSummaryPage
extends AbstractAgentUIWizardPage {
    private Text profileName;
    private Text profileLocation;
    private Text commonComponentLocation;
    private Table spaceTable;
    private TreeViewer filesView;
    private Section packagesSection;
    private Section filesSection;
    private Section spaceSection;
    private TreeViewer packageViewer;
    private final Set driveSet = new HashSet();
    private boolean isPageComplete = false;
    private static final CustomMessageWizardPage.ErrorId collectionFailed = new CustomMessageWizardPage.ErrorId();

    public ImportWASSummaryPage(FormToolkit toolkit, AgentUIWizard wizard) {
        this(toolkit, wizard, com.ibm.ws.sync.internal.ui.Messages.ImportWAS_review_summary);
        this.setHelpRef("com.ibm.cic.agent.ui.ImportSummaryPage");
        this.setPageComplete(false);
    }

    public ImportWASSummaryPage(FormToolkit toolkit, AgentUIWizard wizard, String description) {
        super(toolkit, Messages.ConfirmationPage_title, description, wizard);
        this.setHelpRef("com.ibm.cic.agent.ui.ImportSummaryPage");
        AgentUI.getDefault().getLabelProvider().connect((Object)this);
    }

    public void dispose() {
        AgentUI.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = this.getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        container.setLayout((Layout)layout);
        this.createTargetLocationControl(container);
        this.createPackageSummaryControl(container);
        this.createEnvSpaceSummaryControl(container);
        this.createCollectedFilesControl(container);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    protected void createTargetLocationControl(Composite container) {
        Section targetLocationSection = this.getToolkit().createSection(container, 512);
        targetLocationSection.setText(com.ibm.cic.agent.internal.ui.Messages.ConfirmationPage_targetLocation);
        Composite targetLocationComposite = this.getToolkit().createComposite((Composite)targetLocationSection);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        targetLocationComposite.setLayout((Layout)gridLayout);
        targetLocationSection.setClient((Control)targetLocationComposite);
        targetLocationSection.setLayoutData((Object)new GridData(4, 1, true, false));
        this.getToolkit().createLabel(targetLocationComposite, com.ibm.cic.agent.internal.ui.Messages.InstallLocationDetailsPage_installLocationNameLabel);
        this.profileName = new Text(targetLocationComposite, 8);
        this.profileName.setLayoutData((Object)new GridData(4, 1, true, false));
        this.getToolkit().createLabel(targetLocationComposite, com.ibm.cic.agent.internal.ui.Messages.SummaryPage_installLocationDirectory);
        this.profileLocation = new Text(targetLocationComposite, 8);
        this.profileLocation.setLayoutData((Object)new GridData(4, 1, true, false));
        if (!InstallAgentUtils.onlyAgentJob((List)this.getSelectedJobs())) {
            this.getToolkit().createLabel(targetLocationComposite, com.ibm.cic.agent.internal.ui.Messages.SummaryPage_commonComponentLocation);
            this.commonComponentLocation = new Text(targetLocationComposite, 8);
            this.commonComponentLocation.setLayoutData((Object)new GridData(4, 1, true, false));
        }
    }

    protected void createPackageSummaryControl(Composite container) {
        this.packagesSection = this.getToolkit().createSection(container, 512);
        this.packagesSection.setText(com.ibm.cic.agent.internal.ui.Messages.InstallSummaryPage_featureTableTitle);
        Composite packagesComposite = this.getToolkit().createComposite((Composite)this.packagesSection);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        packagesComposite.setLayout((Layout)treeColumnLayout);
        this.packagesSection.setClient((Control)packagesComposite);
        GridData data = new GridData(4, 4, true, true);
        this.packagesSection.setLayoutData((Object)data);
        int style = 2820;
        this.packageViewer = new TreeViewer(packagesComposite, style);
        this.getToolkit().adapt(this.packageViewer.getControl(), true, true);
        GridData gd = new GridData(1808);
        gd.heightHint = this.packageViewer.getTree().getItemHeight() * 5;
        this.packageViewer.getTree().setLayoutData((Object)gd);
        this.packageViewer.getTree().setHeaderVisible(true);
        TreeColumn packageCol = new TreeColumn(this.packageViewer.getTree(), 16384);
        packageCol.setText(com.ibm.cic.agent.internal.ui.Messages.InstallSummaryPage_featureTable_col1);
        ColumnWeightData packageColData = new ColumnWeightData(80);
        treeColumnLayout.setColumnData((Widget)packageCol, (ColumnLayoutData)packageColData);
        TreeColumn statusCol = new TreeColumn(this.packageViewer.getTree(), 16384);
        statusCol.setText(com.ibm.cic.agent.internal.ui.Messages.AvailableOfferingSection_columnInstalled);
        ColumnWeightData statusColData = new ColumnWeightData(15);
        treeColumnLayout.setColumnData((Widget)statusCol, (ColumnLayoutData)statusColData);
        TreeColumn vendorCol = new TreeColumn(this.packageViewer.getTree(), 16384);
        vendorCol.setText(com.ibm.cic.agent.internal.ui.Messages.AvailableOfferingSection_columnVendor);
        ColumnWeightData vendorColData = new ColumnWeightData(10);
        treeColumnLayout.setColumnData((Widget)vendorCol, (ColumnLayoutData)vendorColData);
        SummaryPackageContentProvider contentProvider = new SummaryPackageContentProvider();
        this.packageViewer.setContentProvider((IContentProvider)contentProvider);
        this.packageViewer.setLabelProvider((IBaseLabelProvider)new SummaryPackageLabelProvider(this.packageViewer.getTree().getDisplay()));
        this.packageViewer.setSorter((ViewerSorter)new FeatureViewerSorter());
        this.packageViewer.setInput(null);
    }

    protected void createCollectedFilesControl(Composite container) {
        this.filesSection = this.getToolkit().createSection(container, 514);
        this.filesSection.setText(com.ibm.cic.agent.internal.ui.Messages.SummaryPage_CollectionResult_Title);
        Composite collectedFilesComposite = this.getToolkit().createComposite((Composite)this.filesSection);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        collectedFilesComposite.setLayout((Layout)layout);
        this.filesSection.setClient((Control)collectedFilesComposite);
        this.filesSection.setLayoutData((Object)new GridData(4, 4, true, false));
        this.getToolkit().createLabel(collectedFilesComposite, com.ibm.cic.agent.internal.ui.Messages.SummaryPage_CollectionResult_TabelTitle);
        int filesViewStyle = 101124;
        this.filesView = new TreeViewer(collectedFilesComposite, filesViewStyle);
        GridData data = new GridData(1808);
        data.heightHint = this.filesView.getTree().getItemHeight() * 3;
        this.filesView.getTree().setLayoutData((Object)data);
        this.filesView.getTree().setLinesVisible(true);
        this.filesView.getTree().setHeaderVisible(true);
        this.filesView.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.filesView.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.filesView.setAutoExpandLevel(-1);
        this.getToolkit().adapt(this.filesView.getControl(), true, true);
        TreeColumn col1 = new TreeColumn(this.filesView.getTree(), 16384, 0);
        col1.setText(com.ibm.cic.agent.internal.ui.Messages.SummaryPage_CollectionResult_Col1);
        col1.setWidth(420);
        this.filesView.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int treeWidth = ((ImportWASSummaryPage)ImportWASSummaryPage.this).filesView.getTree().getClientArea().width;
                TreeColumn repCol = ImportWASSummaryPage.this.filesView.getTree().getColumn(0);
                repCol.setWidth(treeWidth);
            }
        });
        this.filesView.setInput(null);
    }

    protected void createEnvSpaceSummaryControl(Composite container) {
        if (((ImportWASWizard)this.getWizard()).shouldSkipCommonLocationPage()) {
            return;
        }
        Composite comp = this.getToolkit().createComposite(container);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createSpaceSummaryControl(comp);
    }

    protected void createSpaceSummaryControl(Composite container) {
        this.spaceSection = this.getToolkit().createSection(container, 512);
        this.spaceSection.setText(com.ibm.cic.agent.internal.ui.Messages.ConfirmationPage_requiredSpace);
        Composite spaceComposite = this.getToolkit().createComposite((Composite)this.spaceSection);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        spaceComposite.setLayout((Layout)layout);
        this.spaceSection.setClient((Control)spaceComposite);
        this.spaceSection.setLayoutData((Object)new GridData(4, 1, true, false));
        int originalBorderStype = this.getToolkit().getBorderStyle();
        this.getToolkit().setBorderStyle(0);
        int spaceTableStyle = 32772;
        this.spaceTable = this.getToolkit().createTable(spaceComposite, spaceTableStyle);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.spaceTable.getItemHeight() * 2;
        this.spaceTable.setLayoutData((Object)data);
        this.spaceTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ImportWASSummaryPage.this.adjustSpaceTableColumnWidth();
                ImportWASSummaryPage.this.spaceTable.layout();
                ImportWASSummaryPage.this.spaceTable.getParent().layout();
            }
        });
        TableColumn col1 = new TableColumn(this.spaceTable, 16384, 0);
        col1.setWidth(30);
        col1.setResizable(false);
        TableColumn col2 = new TableColumn(this.spaceTable, 131072, 1);
        col2.setWidth(100);
        col2.setResizable(false);
        this.spaceTable.pack();
        this.getToolkit().setBorderStyle(originalBorderStype);
        this.spaceSection.setVisible(AgentUI.getDefault().isEclipseCacheChangeable());
    }

    private void adjustSpaceTableColumnWidth() {
        GC gc = new GC((Drawable)this.spaceTable);
        gc.setFont(this.spaceTable.getFont());
        int width1 = this.spaceTable.getColumn(0).getWidth();
        int i = 0;
        while (i < this.spaceTable.getItemCount()) {
            String colText = this.spaceTable.getItem(i).getText(0);
            int width = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)colText)).append((String)"      ").toString()).x;
            if (width > width1) {
                width1 = width;
            }
            ++i;
        }
        this.spaceTable.getColumn(0).setWidth(width1);
        int width2 = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)com.ibm.cic.agent.internal.ui.Messages.SummaryPage_spaceTable_availableSpace)).append((String)"       ").toString()).x;
        int i2 = 0;
        while (i2 < this.spaceTable.getItemCount()) {
            String colText = this.spaceTable.getItem(i2).getText(1);
            int width = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)colText)).append((String)"       ").toString()).x;
            if (width > width2) {
                width2 = width;
            }
            ++i2;
        }
        this.spaceTable.getColumn(1).setWidth(width2);
        gc.dispose();
        int newWidthHint = width1 + width2 + 10;
        GridData data = (GridData)this.spaceTable.getLayoutData();
        data.widthHint = newWidthHint;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.showProfiles();
            this.showDiskSpaceInformation();
            this.showPackages();
            this.showCollectedFiles();
            this.checkAgentRequirements();
            this.isPageComplete = this.getErrorMessage() == null;
        }
        this.setPageComplete(this.isPageComplete);
        super.setVisible(visible);
    }

    private IStatus checkAgentRequirements() {
        boolean displayInternalVersion;
        SyncLocation syncLocation = ((ImportWASWizard)this.getWizard()).getSyncLocation();
        IStatus status = SyncUtil.checkAgentRequirement((SyncLocation)syncLocation, (boolean)(displayInternalVersion = AgentUI.getDefault().getAgentPreferenceStore().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key())));
        if (status.getSeverity() != 0) {
            this.setErrorMessage(status.getMessage());
        }
        return status;
    }

    private void showProfiles() {
        SyncLocation syncLocation;
        if (!InstallAgentUtils.onlyAgentJob((List)this.getSelectedJobs())) {
            String location = CacheLocationManager.getInstance().getCacheLocation();
            String processedLocation = TextProcessor.process((String)location);
            this.commonComponentLocation.setText(processedLocation);
        }
        if ((syncLocation = ((ImportWASWizard)this.getWizard()).getSyncLocation()) == null) {
            this.setErrorMessage(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_unknown_noInstallationDirectory);
            this.setPageComplete(false);
        } else {
            this.setPageComplete(syncLocation.requiresSynchronization());
            IProfile profile = syncLocation.getProfile();
            if (profile == null) {
                IOffering baseOffering = syncLocation.getBaseOffering();
                try {
                    String name = baseOffering.getProperties().getProperty("default.profile");
                    this.profileName.setText(name);
                }
                catch (Exception e) {
                    this.setErrorMessage(com.ibm.ws.sync.internal.ui.Messages.ImportWAS_no_offering_found);
                    this.setPageComplete(false);
                }
                this.profileLocation.setText(syncLocation.getLocation());
            } else {
                this.profileName.setText(profile.getProfileId());
                String installLocation = profile.getInstallLocation();
                String processedLocation = TextProcessor.process((String)installLocation);
                this.profileLocation.setText(processedLocation);
            }
        }
    }

    protected void showDiskSpaceInformation() {
        if (((ImportWASWizard)this.getWizard()).shouldSkipCommonLocationPage()) {
            return;
        }
        this.spaceTable.removeAll();
        this.driveSet.clear();
        TableItem tableItem = new TableItem(this.spaceTable, 0);
        tableItem.setText(new String[]{"", com.ibm.cic.agent.internal.ui.Messages.SummaryPage_spaceTable_availableSpace});
        String cacheLocationDrive = PlatformUtils.getLocationDevice((String)CacheLocationManager.getInstance().getCacheLocation());
        if ("win32".equals(Platform.getOS())) {
            cacheLocationDrive = cacheLocationDrive.toUpperCase();
        }
        this.driveSet.add(cacheLocationDrive);
        for (String driveName : this.driveSet) {
            String availableSpace = SpaceInfoUtils.getAvailableSpace((String)driveName);
            TableItem item = new TableItem(this.spaceTable, 0);
            item.setText(new String[]{driveName, availableSpace});
        }
        int rowCount = this.driveSet.size() + 1;
        GridData data = (GridData)this.spaceTable.getLayoutData();
        data.heightHint = this.spaceTable.getItemHeight() * rowCount;
        this.spaceTable.redraw();
        this.adjustSpaceTableColumnWidth();
        this.spaceTable.layout();
        this.reflowFor((Control)this.spaceTable);
    }

    public boolean canFlipToPreviousPage() {
        return super.getPreviousPage() != null;
    }

    public void previousPage() {
        this.packagesSection.setText(com.ibm.cic.agent.internal.ui.Messages.InstallSummaryPage_featureTableTitle);
        this.setMessage("");
        this.isPageComplete = false;
        this.setPageComplete(this.isPageComplete);
        super.previousPage();
    }

    private void showPackages() {
        SyncLocation syncLocation = ((ImportWASWizard)this.getWizard()).getSyncLocation();
        ImportOffering[] targetPackages = SyncUIUtil.getTargetPackages(syncLocation);
        this.packageViewer.setInput((Object)targetPackages);
        this.packageViewer.expandAll();
    }

    private void showCollectedFiles() {
        try {
            String repository;
            SyncLocation.InstalledOffering element;
            ArrayList<String> newInput = new ArrayList<String>();
            this.filesView.getTree().setEnabled(false);
            this.filesView.getTree().setEnabled(true);
            SyncLocation.InstalledOffering[] children = new SyncLocation.InstalledOffering[]{};
            SyncLocation.InstalledFix[] childrenFix = new SyncLocation.InstalledFix[]{};
            SyncLocation syncLocation = ((ImportWASWizard)this.getWizard()).getSyncLocation();
            if (syncLocation != null) {
                children = syncLocation.getOfferingsToInstall();
                childrenFix = syncLocation.getIFixesToInstall();
            }
            SyncLocation.InstalledOffering[] installedOfferingArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                element = installedOfferingArray[n2];
                repository = element.getRepositoryOffering().getRepository().getLocationStr();
                if (!newInput.contains(repository)) {
                    newInput.add(repository);
                }
                ++n2;
            }
            installedOfferingArray = childrenFix;
            n = childrenFix.length;
            n2 = 0;
            while (n2 < n) {
                element = installedOfferingArray[n2];
                repository = element.getRepositoryFix().getRepository().getLocationStr();
                if (!newInput.contains(repository)) {
                    newInput.add(repository);
                }
                ++n2;
            }
            this.filesView.setInput(newInput);
            this.setErrorState(collectionFailed, null);
            this.updateButtons();
        }
        catch (Exception e) {
            AgentUI.reportException((Throwable)e, (boolean)false);
        }
    }

    protected void reflowFor(Control c) {
        for (Composite parent = c.getParent(); parent != null; parent = parent.getParent()) {
            parent.layout();
            if (!(parent instanceof ScrolledForm)) continue;
            ((ScrolledForm)parent).reflow(true);
            break;
        }
    }

    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    public boolean isReadOnlyPage() {
        return true;
    }

    private static class RepositoryContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private RepositoryContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private static class RepositoryLabelProvider
    implements ITableLabelProvider {
        private RepositoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

