/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.ui.extensions;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.utils.FeatureViewerSorter;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.ws.sync.internal.ui.ImportFix;
import com.ibm.ws.sync.internal.ui.ImportOffering;
import com.ibm.ws.sync.internal.ui.Messages;
import com.ibm.ws.sync.internal.ui.SummaryPackageContentProvider;
import com.ibm.ws.sync.internal.ui.SummaryPackageLabelProvider;
import com.ibm.ws.sync.internal.ui.SyncUIUtil;
import com.ibm.ws.sync.ui.extensions.ImportWASWizard;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ImportWASCompletionPage
extends CompletionPage {
    private Text detailText;
    private TreeViewer packageViewer;
    private Label packageLabel;
    private Section packagesSection;
    private final Profile synchronizedProfile;
    private IOffering baseOffering;

    public ImportWASCompletionPage(FormToolkit toolkit, String pageTitle, String pageDes, ImportWASWizard wizard, IStatus status) {
        super(toolkit, pageTitle, pageDes, (AgentUIWizard)wizard, status);
        this.setHelpRef("com.ibm.cic.agent.ui.ImportCompletionPage");
        this.synchronizedProfile = wizard.getSynchronizedProfile();
        if (this.synchronizedProfile == null) {
            if (this.result == 0) {
                this.status = new Status(4, "com.ibm.ws.sync.ui", Messages.ImportWAS_unknown_noWASProfile);
                this.result = 1;
            }
        } else {
            this.baseOffering = SyncUIUtil.getBaseOffering(this.synchronizedProfile);
            if (this.baseOffering == null && this.result == 0) {
                this.status = new Status(4, "com.ibm.ws.sync.ui", NLS.bind((String)Messages.ImportWAS_unknown_noWAS, (Object)this.synchronizedProfile.getProfileId()));
                this.result = 1;
            }
        }
    }

    protected Composite createDetailControl(Composite container) {
        Composite detailComp = this.getToolkit().createComposite(container, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 30;
        gridLayout.marginLeft = 30;
        detailComp.setLayout((Layout)gridLayout);
        detailComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite detailInfoComp = this.getToolkit().createComposite(detailComp, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        detailInfoComp.setLayout((Layout)layout);
        detailInfoComp.setLayoutData((Object)new GridData(768));
        this.detailText = this.getToolkit().createText(detailInfoComp, "", 72);
        GridData detailGridData = new GridData(770);
        detailGridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.detailText.setLayoutData((Object)detailGridData);
        this.createPackageSummaryControl(detailComp);
        return detailComp;
    }

    protected void createPackageSummaryControl(Composite container) {
        Label fillerLabel = this.getToolkit().createLabel(container, "", 0);
        GridData fillerLabelData = new GridData(768);
        fillerLabel.setLayoutData((Object)fillerLabelData);
        this.packageLabel = this.getToolkit().createLabel(container, "");
        this.packagesSection = this.getToolkit().createSection(container, 4096);
        Composite packagesComposite = this.getToolkit().createComposite((Composite)this.packagesSection);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        packagesComposite.setLayout((Layout)treeColumnLayout);
        this.packagesSection.setClient((Control)packagesComposite);
        GridData data = new GridData(4, 4, true, true);
        this.packagesSection.setLayoutData((Object)data);
        int style = 2820;
        this.packageViewer = new TreeViewer(packagesComposite, style);
        this.getToolkit().adapt(this.packageViewer.getControl(), true, true);
        GridData gd = new GridData(1808);
        gd.heightHint = this.packageViewer.getTree().getItemHeight() * 5;
        this.packageViewer.getTree().setLayoutData((Object)gd);
        this.packageViewer.getTree().setHeaderVisible(true);
        TreeColumn featureCol = new TreeColumn(this.packageViewer.getTree(), 16384);
        featureCol.setText(com.ibm.cic.agent.internal.ui.Messages.InstallSummaryPage_featureTable_col1);
        ColumnWeightData colData = new ColumnWeightData(1);
        treeColumnLayout.setColumnData((Widget)featureCol, (ColumnLayoutData)colData);
        SummaryPackageContentProvider contentProvider = new SummaryPackageContentProvider();
        this.packageViewer.setContentProvider((IContentProvider)contentProvider);
        this.packageViewer.setLabelProvider((IBaseLabelProvider)new SummaryPackageLabelProvider(this.packageViewer.getTree().getDisplay()));
        this.packageViewer.setSorter((ViewerSorter)new FeatureViewerSorter());
        this.packageViewer.setInput(null);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.showResult();
            this.reflowFor(this.getControl());
        }
        super.setVisible(visible);
    }

    private void showResult() {
        if (this.synchronizedProfile == null) {
            this.packageLabel.setVisible(false);
            this.packagesSection.setVisible(false);
        } else {
            String packageGroupName = "";
            packageGroupName = this.synchronizedProfile.getInstalledOfferings().length > 1 ? NLS.bind((String)Messages.ImportWAS_packagesWereImported, (Object)(" " + this.synchronizedProfile.getProfileId())) : NLS.bind((String)Messages.ImportWAS_packageWasImported, (Object)(" " + this.synchronizedProfile.getProfileId()));
            this.packageLabel.setText(packageGroupName);
            this.packageViewer.setInput((Object)this.getImportedOfferings());
            this.packageViewer.expandAll();
        }
        if (this.result == 1) {
            this.resultText.setText(Messages.ImportWAS_result_fail);
            this.detailText.setText(this.getDisplayMessage(this.status, ""));
            return;
        }
        this.resultText.setText(Messages.ImportWAS_result_success);
        String detailInfo = NLS.bind((String)Messages.ImportWAS_success_message, (Object)OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)this.baseOffering));
        this.detailText.setText(detailInfo);
    }

    private ImportOffering[] getImportedOfferings() {
        IOffering[] offerings;
        TreeSet<ImportOffering> importedOfferings = new TreeSet<ImportOffering>();
        IOffering[] iOfferingArray = offerings = this.synchronizedProfile.getInstalledOfferings();
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            IFix[] fixes = this.synchronizedProfile.getInstalledFixes(offering);
            ImportOffering importedOffering = new ImportOffering(offering, false);
            IFix[] iFixArray = fixes;
            int n3 = fixes.length;
            int n4 = 0;
            while (n4 < n3) {
                IFix fix = iFixArray[n4];
                importedOffering.addFix(new ImportFix(fix, false));
                ++n4;
            }
            importedOfferings.add(importedOffering);
            ++n2;
        }
        return importedOfferings.toArray(new ImportOffering[importedOfferings.size()]);
    }

    private String getDisplayMessage(IStatus s, String indent) {
        String displayMsg = "";
        if (s.isMultiStatus()) {
            IStatus[] children;
            displayMsg = s.getMessage();
            boolean newLine = displayMsg != null && displayMsg.length() > 0;
            IStatus[] iStatusArray = children = s.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                displayMsg = String.valueOf(displayMsg) + (newLine ? "\n" : "") + this.getDisplayMessage(element, String.valueOf(indent) + "  ");
                ++n2;
            }
        } else {
            displayMsg = String.valueOf(indent) + s.getMessage();
        }
        return displayMsg;
    }
}

