/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallOperation;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.LumEnroller;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.LumRegData;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.Messages;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.nativeAdapterData.LumkitNativeData;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.lum.enroll.LicEnroller;
import com.ibm.cic.licensing.lum.enroll.NodelockData;
import com.ibm.cic.licensing.lum.enroll.NodelockReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class LumkitInstallOperation
extends ICommonNativeInstallOperation
implements IAgentEventManager.AgentSessionListener,
IAgentEventManager.AgentJobListener {
    private final Agent agent;
    private final File isdplic;
    private final LumkitNativeData data;
    private final IPath nodelockPath;
    private final String agentSessionID;

    public LumkitInstallOperation(int phase, IInstallableUnit unit, InstallContext context, LumkitNativeData data) {
        super(phase, unit, context);
        this.data = data;
        this.agent = Agent.getInstance();
        this.isdplic = new File(LicUserUtils.getCommunicationChannelLocation().toFile(), ".sdplic");
        Path agentDataLicensePath = new Path(this.agent.getAgentDataLicenseLocation().getAbsolutePath());
        this.nodelockPath = LicUserUtils.getInstallTimeLumNodeLockFile((IPath)agentDataLicensePath);
        this.agentSessionID = String.valueOf(Math.abs(this.agent.getUniqueInstanceId().hashCode()));
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    protected IStatus doPerform(IProgressMonitor monitor) {
        boolean succeeded = this.getPhase() == 21 ? this.doInstallLumkit() : this.doUninstallLumkit();
        return succeeded ? Status.OK_STATUS : new Status(2, "com.ibm.cic.agent.core.nativeInstallAdapter", Messages.LumEnrollOperationFailed);
    }

    private boolean doInstallLumkit() {
        if (!this.doStagedLumkitInstall()) {
            return false;
        }
        this.agent.getEventManager().addInstallOfferingOrFixListener((IAgentEventManager.AgentJobListener)this);
        return true;
    }

    private boolean doStagedLumkitInstall() {
        try {
            File[] ecfFiles;
            int retcode = 0;
            String ecfPathStr = this.performVariableSubstitutions(this.data.getEcfPath(), AbstractVariableSubstitution.AllowAbsolutePath.TRUE);
            this.createLumDirs();
            String nodelockFile = this.nodelockPath.toFile().getCanonicalPath();
            File nodelockpre = new File(this.getPreIuNodelockName2());
            if (new File(nodelockFile).exists()) {
                FileUtil.copyFile((File)new File(nodelockFile), (File)nodelockpre);
            } else {
                nodelockpre.createNewFile();
            }
            File ecfdir = new File(ecfPathStr);
            if (ecfdir.exists() && (ecfFiles = ecfdir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".lic") || name.endsWith(".lic".toUpperCase(Locale.ENGLISH));
                }
            })) != null) {
                File[] fileArray = ecfFiles;
                int n = ecfFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File ecfFile2 = fileArray[n2];
                    String ecfFile = ecfFile2.getCanonicalPath();
                    retcode = LumEnroller.enroll(ecfFile, nodelockFile);
                    LicEnroller.renameLicToDatFile((String)ecfFile);
                    ++n2;
                }
            }
            return retcode == 0;
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException vse) {
            vse.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    public void afterInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
        if (!StatusUtil.isErrorOrCancel((IStatus)event.getStatus())) {
            File agentDataLicenseLocation = this.agent.getAgentDataLicenseLocation();
            LicEnroller.recordLicenseDataLocation((File)this.isdplic, (File)agentDataLicenseLocation);
            List regdata = LumEnroller.getRegData();
            for (LumRegData lrdata : regdata) {
                if (LumEnroller.doWriteToRegistry(lrdata.getRegistry(), lrdata.getKey(), lrdata.getValue()) || !Logger.isTracing((boolean)Logger.DEBUG_METHODS)) continue;
                Logger.logNtrace((String)"Failed to write to registry during LUM trial enroll");
            }
            FileUtil.delete((File)new File(this.getPreIuNodelockName2()));
            regdata.clear();
        } else {
            LumEnroller.getRegData().clear();
            Logger.logNtrace((String)("LUM licenses not installed: " + event.getStatus().getMessage()));
        }
        this.agent.getEventManager().removeInstallOfferingOrFixListener((IAgentEventManager.AgentJobListener)this);
    }

    private boolean doUninstallLumkit() {
        File[] ecfdatfiles;
        String ecfpath;
        try {
            ecfpath = this.performVariableSubstitutions(this.data.getEcfPath(), AbstractVariableSubstitution.AllowAbsolutePath.TRUE);
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
            e.printStackTrace();
            return false;
        }
        this.agent.getEventManager().addUninstallSessionListener((IAgentEventManager.AgentSessionListener)this);
        File ecfdir = new File(ecfpath);
        if (ecfdir.exists() && (ecfdatfiles = ecfdir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".dat");
            }
        })) != null) {
            File[] fileArray = ecfdatfiles;
            int n = ecfdatfiles.length;
            int n2 = 0;
            while (n2 < n) {
                File datfile = fileArray[n2];
                if (datfile.exists()) {
                    datfile.delete();
                }
                ++n2;
            }
        }
        this.purgeOldNodelockPreFiles();
        File nodelockfile = new File(this.nodelockPath.toOSString());
        File nodelockpre = new File(this.getPreIuNodelockName2());
        if (nodelockpre.exists()) {
            nodelockfile.delete();
            nodelockpre.renameTo(nodelockfile);
        }
        return true;
    }

    private void purgeOldNodelockPreFiles() {
        String fkeepfullpath;
        String fkeep;
        File[] nl_files;
        File lumdir;
        File nodelockpre = new File(this.getPreIuNodelockName());
        if (nodelockpre.exists()) {
            nodelockpre.delete();
        }
        if ((lumdir = this.nodelockPath.toFile().getParentFile()) != null && lumdir.exists() && (nl_files = lumdir.listFiles(new FilenameFilter(fkeep = new File(fkeepfullpath = this.getPreIuNodelockName2()).getName()){
            private final /* synthetic */ String val$fkeep;
            {
                this.val$fkeep = string;
            }

            @Override
            public boolean accept(File dir, String fname) {
                return fname.startsWith("nodelock_") && !fname.equals(this.val$fkeep);
            }
        })) != null) {
            File[] fileArray = nl_files;
            int n = nl_files.length;
            int n2 = 0;
            while (n2 < n) {
                File nl_file = fileArray[n2];
                if (nl_file.exists()) {
                    nl_file.delete();
                }
                ++n2;
            }
        }
    }

    public void afterUninstallSession(IAgentEventManager.AgentSessionEvent event) {
        Profile[] profiles;
        if (event.getAgentJobs().length < 1) {
            return;
        }
        this.agent.getEventManager().removeUninstallSessionListener((IAgentEventManager.AgentSessionListener)this);
        AgentJob[] currentJobs = event.getAgentJobs();
        LinkedList<IOffering> offeringsBeenUninstalled = new LinkedList<IOffering>();
        AgentJob[] agentJobArray = currentJobs;
        int n = currentJobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            if (job.getOffering() != null) {
                offeringsBeenUninstalled.add(job.getOffering());
            }
            ++n2;
        }
        LinkedList<IOffering> remainingOfferings = new LinkedList<IOffering>();
        Profile[] profileArray = profiles = this.agent.getNormalProfiles();
        int n3 = profiles.length;
        int n4 = 0;
        while (n4 < n3) {
            IOffering[] offerings;
            Profile aprofile = profileArray[n4];
            IOffering[] iOfferingArray = offerings = this.agent.getInstalledOfferings(aprofile);
            int n5 = offerings.length;
            int n6 = 0;
            while (n6 < n5) {
                IOffering offering = iOfferingArray[n6];
                remainingOfferings.add(offering);
                ++n6;
            }
            ++n4;
        }
        this.cleanupNodelockFile(offeringsBeenUninstalled, remainingOfferings);
        this.uninstallAppliedPEK(remainingOfferings);
    }

    private void uninstallAppliedPEK(List<IOffering> remainingOfferings) {
        block8: {
            try {
                Profile licprofile = this.agent.getProfile("SDP Licenses");
                if (licprofile != null) {
                    IOffering[] offerings = this.agent.getInstalledOfferings(licprofile);
                    Vector<UninstallJob> jobs = new Vector<UninstallJob>(offerings.length);
                    IOffering[] iOfferingArray = offerings;
                    int n = offerings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IOffering licoffering = iOfferingArray[n2];
                        if (!this.isPekForAnyRemainingOffering(licoffering, remainingOfferings)) {
                            com.ibm.cic.common.logging.Logger.getGlobalLogger().statusNotOK(RepositoryUtils.resolve((IOfferingOrFix)licoffering, (IProgressMonitor)new NullProgressMonitor()));
                            jobs.add(new UninstallJob(licprofile, (IOfferingOrFix)licoffering));
                        }
                        ++n2;
                    }
                    if (!jobs.isEmpty()) {
                        AgentJob[] agentjobs = jobs.toArray(new AgentJob[jobs.size()]);
                        IStatus status = this.agent.uninstall(agentjobs, false, null);
                        if (Logger.isTracing((boolean)Logger.DEBUG_EXCEPTIONS)) {
                            Logger.trace((String)("Agent uninstall of PAK returned " + status.getMessage()));
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!Logger.isTracing((boolean)Logger.DEBUG_EXCEPTIONS)) break block8;
                e.printStackTrace();
            }
        }
        if (remainingOfferings.isEmpty() && this.isdplic.exists()) {
            this.isdplic.delete();
        }
    }

    private boolean isPekForAnyRemainingOffering(IOffering licenseOffering, List<IOffering> remainingOfferings) {
        for (IOffering remainingOffering : remainingOfferings) {
            if (!LicenseUtils.isPekApplicableToOffering((IOffering)licenseOffering, (IOffering)remainingOffering)) continue;
            return true;
        }
        return false;
    }

    private void cleanupNodelockFile(List<IOffering> uninstalledOfferings, List<IOffering> remainingOfferings) {
        String nodelock = this.nodelockPath.toOSString();
        File nodelockfile = new File(nodelock);
        if (!nodelockfile.exists()) {
            return;
        }
        NodelockData olddata = NodelockReader.getNodelockData((String)nodelock);
        NodelockData newdata = new NodelockData();
        List entries = olddata.getContent();
        for (NodelockData.NodelockEntry entry : entries) {
            if (!this.isEntryStillUsedByRemainingOffering(entry, remainingOfferings) || this.isMatchingLicenseOfferingBeungUninstalled(entry, uninstalledOfferings)) continue;
            newdata.getContent().add(entry);
        }
        if (entries.size() != newdata.getContent().size()) {
            File nodelockbak = new File(String.valueOf(nodelock) + ".bak");
            if (nodelockbak.exists()) {
                nodelockbak.delete();
            }
            nodelockfile.renameTo(nodelockbak);
            if (!newdata.getContent().isEmpty()) {
                LicEnroller.write((File)nodelockfile, (boolean)false, (String)newdata.toString());
            }
        }
    }

    private boolean isEntryStillUsedByRemainingOffering(NodelockData.NodelockEntry entry, List<IOffering> remainingOfferings) {
        for (IOffering remainingOffering : remainingOfferings) {
            if (!this.haveMatchingLumIdAndVer(entry, remainingOffering)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchingLicenseOfferingBeungUninstalled(NodelockData.NodelockEntry entry, List<IOffering> uninstalledOfferings) {
        for (IOffering uninstalledOffering : uninstalledOfferings) {
            if (!LicenseUtils.isPEKOffering((IOffering)uninstalledOffering) || !this.haveMatchingLumIdAndVer(entry, uninstalledOffering)) continue;
            return true;
        }
        return false;
    }

    private boolean haveMatchingLumIdAndVer(NodelockData.NodelockEntry entry, IOffering offering) {
        List iplasIUs = offering.getInstallableUnits();
        for (IInstallableUnit iplaIU : iplasIUs) {
            String lumid = iplaIU.getProperties().getProperty("enablement.lum.id");
            String lumver = iplaIU.getProperties().getProperty("enablement.lum.version");
            if (lumid == null || lumver == null || !lumid.equals(entry.getLumid()) || !this.isSameVersion(lumver, entry.getLumversion())) continue;
            return true;
        }
        return false;
    }

    private boolean isSameVersion(String ver1, String ver2) {
        if (ver1 == null | ver2 == null) {
            return false;
        }
        try {
            Version v1 = new Version(ver1);
            Version v2 = new Version(ver2);
            return v1.equals((Object)v2);
        }
        catch (Exception e) {
            return ver1.equalsIgnoreCase(ver2);
        }
    }

    private void createLumDirs() {
        File lumdir = this.nodelockPath.toFile().getParentFile();
        if (!lumdir.exists()) {
            lumdir.mkdirs();
        }
    }

    private String getPreIuNodelockName() {
        return String.valueOf(this.nodelockPath.toOSString()) + "_" + this.getUnit().getIdentity().getId() + "_" + this.getUnit().getVersion();
    }

    private String getPreIuNodelockName2() {
        return String.valueOf(this.nodelockPath.toOSString()) + "_" + this.agentSessionID + "_" + IdentityUtil.getVersionedId((IContent)this.getUnit());
    }

    public IStatus beforeInstallSession(IAgentEventManager.AgentSessionEvent event) {
        return Status.OK_STATUS;
    }

    public IStatus beforeUninstallSession(IAgentEventManager.AgentSessionEvent event) {
        return Status.OK_STATUS;
    }

    public void afterUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
    }

    public IStatus beforeInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
        return null;
    }

    public IStatus beforeUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
        return Status.OK_STATUS;
    }

    public void afterInstallSession(IAgentEventManager.AgentSessionEvent event) {
    }
}

