/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter;

import com.ibm.LUMClient.LicenseTransaction;
import com.ibm.LUMClient.LumClient;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.LumRegData;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.Messages;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.PPLumEnroller;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.lum.enroll.LicData;
import com.ibm.cic.licensing.lum.enroll.LicEnroller;
import com.ibm.cic.licensing.lum.enroll.LicReader;
import com.ibm.cic.licensing.lum.enroll.LicWriter;
import com.ibm.cic.licensing.lum.enroll.NodelockData;
import com.ibm.cic.licensing.lum.enroll.NodelockReader;
import java.io.File;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class LumEnroller {
    public static final int ENROLL_SUCCESS = 0;
    public static final int ENROLL_FAILED = -1;
    private static List regData = new LinkedList();

    public static int enroll(String ecfFilePath, String nodelockFilePath) {
        LicData licdata = LicReader.getLicData((String)ecfFilePath);
        String productID = licdata.getProductId();
        String productVersion = licdata.getProductVersion();
        boolean isTryBuy = licdata.isTryAndBuy();
        if (!isTryBuy) {
            LicWriter.topInsert((String)nodelockFilePath, (LicData)licdata);
            return 0;
        }
        String regKey = PPLumEnroller.getPolicy().getRegKey(productID, productVersion);
        String trialline = null;
        trialline = PPLumEnroller.getPolicy().checkRegistry(productVersion, regKey);
        if (trialline != null && LumEnroller.isValidNodeLockLine(trialline, licdata)) {
            LumEnroller.doCopyTrialLineToNodelockFile(trialline, licdata, nodelockFilePath);
            return 0;
        }
        File nodelocktrialstagingarea = new File(new File(nodelockFilePath).getParentFile(), "staging");
        FileUtil.rm_r((File)nodelocktrialstagingarea, (boolean)true);
        nodelocktrialstagingarea.mkdirs();
        File trialnodelockFile = new File(nodelocktrialstagingarea, "nodelock");
        String trialnodelock = trialnodelockFile.getAbsolutePath();
        String vendorID = licdata.getVendorID();
        int option = 1;
        int lumProductID = Integer.parseInt(productID);
        long status = 0L;
        LumClient client = LumClient.getLumClient();
        status = client.setOption(vendorID, option, trialnodelock);
        if (status != 0L) {
            Logger.trace((String)"LUM Error while setting client option");
            Logger.logNtrace((int)Logger.ERROR, (String)NLS.bind((String)Messages.LumEnrollFailed, (Object)Long.toString(status), (Object)client.getErrMsg(status)));
            return -1;
        }
        LicenseTransaction Lic = client.initSession(vendorID);
        status = Lic.getServerStatus();
        if (status != 0L) {
            Logger.trace((String)"LUM Error while initializing License Use Management");
            Logger.logNtrace((int)Logger.ERROR, (String)NLS.bind((String)Messages.LumEnrollFailed, (Object)Long.toString(status), (Object)client.getErrMsg(status)));
            return -1;
        }
        File ecffile = new File(ecfFilePath);
        File ecfcopyfile = new File(nodelocktrialstagingarea, "ecfcopy.lic");
        String ecfcopypath = ecfcopyfile.getAbsolutePath();
        LicEnroller.copy((File)ecffile, (File)ecfcopyfile);
        try {
            Calendar rightNow = Calendar.getInstance();
            long startDate = rightNow.getTime().getTime() / 1000L;
            LicWriter.append((String)trialnodelock, (String)licdata.toCommentLine());
            client.setUseOpenTargetTryAndBuy(true);
            status = client.addTryBuy(lumProductID, productVersion, ecfcopypath, startDate);
        }
        catch (SecurityException se) {
            Logger.logNtrace((String)se.getMessage(), (Exception)se);
            return -1;
        }
        catch (IllegalArgumentException ill) {
            Logger.logNtrace((String)ill.getMessage(), (Exception)ill);
            return -1;
        }
        if (status != 0L) {
            Logger.trace((String)"Error while trying installing the tryAndBuy license.");
            Logger.logNtrace((int)Logger.ERROR, (String)NLS.bind((String)Messages.LumEnrollFailed, (Object)Long.toString(status), (Object)client.getErrMsg(status)));
            return -1;
        }
        NodelockData nldata = NodelockReader.getNodelockData((String)trialnodelock);
        NodelockData.NodelockEntry nlentry = (NodelockData.NodelockEntry)nldata.getContent().get(0);
        String lineToRecord = nlentry.getNodelockline();
        LumEnroller.doCopyTrialLineToNodelockFile(lineToRecord, licdata, nodelockFilePath);
        LumRegData lrdata = new LumRegData(regKey, productVersion, lineToRecord);
        regData.add(lrdata);
        FileUtil.rm_r((File)nodelocktrialstagingarea, (boolean)true);
        return 0;
    }

    private static boolean isValidNodeLockLine(String trialline, LicData licdata) {
        if (trialline != null && trialline.length() > 0) {
            return trialline.startsWith(licdata.getVendorID());
        }
        return false;
    }

    private static void doCopyTrialLineToNodelockFile(String trialLine, LicData licdata, String nodelockFilePath) {
        LicWriter.append((String)nodelockFilePath, (String)licdata.toCommentLine());
        LicWriter.append((String)nodelockFilePath, (String)trialLine);
    }

    public static boolean doWriteToRegistry(String regKeyOrFileName, String propkey, String propvalue) {
        return PPLumEnroller.getPolicy().platformDependentWriteToRegistry(regKeyOrFileName, propkey, propvalue);
    }

    public static List getRegData() {
        return regData;
    }

    public static void setRegData(List regdata) {
        regData = regdata;
    }
}

