/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.lum.enroll;

import com.ibm.cic.licensing.lum.enroll.NodelockData;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class NodelockReader {
    public static NodelockData getNodelockData(String nodelockPath) {
        NodelockData nodelockdata = NodelockReader.parse(nodelockPath);
        return nodelockdata;
    }

    private static NodelockData parse(String loc) {
        NodelockData nodelockdata = new NodelockData();
        try {
            FileReader freader = new FileReader(loc);
            BufferedReader breader = new BufferedReader(freader, 4096);
            String line = null;
            NodelockData.NodelockEntry entry = nodelockdata.new NodelockData.NodelockEntry();
            while ((line = breader.readLine()) != null) {
                if (line.startsWith("#[IBMSDPIM]")) {
                    entry = nodelockdata.new NodelockData.NodelockEntry();
                    entry.setCommentline(line);
                    entry.setLumid(NodelockReader.getLumId(line));
                    entry.setLumversion(NodelockReader.getLumVersion(line));
                    entry.setTryAndBuy(NodelockReader.getLumTryAndBuy(line));
                    continue;
                }
                if (!line.startsWith("7ff2aa10b91c.02.45.64.43.f1.00.00.00")) continue;
                entry.setNodelockline(line);
                nodelockdata.getContent().add(entry);
            }
            breader.close();
            freader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nodelockdata;
    }

    private static String getLumId(String line) {
        String[] fields = line.split(" ");
        if (fields.length > 3) {
            return fields[1];
        }
        return null;
    }

    private static String getLumVersion(String line) {
        String[] fields = line.split(" ");
        if (fields.length > 3) {
            return fields[2];
        }
        return null;
    }

    private static boolean getLumTryAndBuy(String line) {
        String[] fields = line.split(" ");
        String tb = fields[fields.length - 1];
        return tb.equals("TryAndBuy");
    }
}

