/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.lum.enroll;

public class LicData {
    public static final String VERDOR_ID = "VendorID";
    public static final String VENDOR_NAME = "VendorName";
    public static final String PRODUCT_NAME = "ProductName";
    public static final String PRODUCT_PASSWORD = "ProductPassword";
    public static final String PRODUCT_ID = "ProductID";
    public static final String PRODUCT_VERSION = "ProductVersion";
    public static final String PRODUCT_ANNOTATION = "ProductAnnotation";
    public static final String SERIAL_NUM = "SerialNumber";
    public static final String LICENSE_START_DATE = "LicenseStartDate";
    public static final String LICENSE_DURATION = "LicenseDuration";
    public static final String LICENSE_END_DATE = "LicenseEndDate";
    public static final String TRY_AND_BUY = "TryAndBuy";
    public static final String YES = "yes";
    public static final String COMMENT_HEADER = "#[IBMSDPIM]";
    public static final String SPACE = " ";
    public static final String LUM_ECF_EXTENTION = ".lic";
    private String vendorID;
    private String productPassword;
    private String productAnnotation;
    private String productVersion;
    private String serialNumber;
    private String vendorName;
    private String productName;
    private String productId;
    private String expirationTS;
    private boolean isTryAndBuy;

    public String toNodeLockLine() {
        StringBuffer ndline = new StringBuffer(this.getVendorID());
        ndline.append(SPACE);
        ndline.append(this.getProductPassword());
        ndline.append(SPACE);
        ndline.append(LicData.addQuotes(this.getProductAnnotation()));
        ndline.append(SPACE);
        ndline.append(LicData.addQuotes(this.getProductVersion()));
        if (this.getSerialNumber() != null && this.getSerialNumber().length() > 0) {
            ndline.append(SPACE);
            ndline.append(LicData.addQuotes(this.getSerialNumber()));
        }
        return ndline.toString();
    }

    public String toCommentLine() {
        StringBuffer cline = new StringBuffer(COMMENT_HEADER);
        cline.append(SPACE);
        cline.append(this.getProductId());
        cline.append(SPACE);
        cline.append(this.getProductVersion());
        cline.append(SPACE);
        cline.append(this.getExpirationTS());
        cline.append(SPACE);
        cline.append(this.getProductName());
        cline.append(SPACE);
        if (this.isTryAndBuy()) {
            cline.append(TRY_AND_BUY);
        } else {
            cline.append("NODELOCK");
        }
        return cline.toString();
    }

    private static String addQuotes(String value) {
        return "\"" + value + "\"";
    }

    public String getProductAnnotation() {
        return this.productAnnotation;
    }

    public void setProductAnnotation(String annotation) {
        this.productAnnotation = annotation;
    }

    public String getExpirationTS() {
        return this.expirationTS;
    }

    public void setExpirationTS(String expirationTS) {
        this.expirationTS = expirationTS;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductPassword() {
        return this.productPassword;
    }

    public void setProductPassword(String productPassword) {
        this.productPassword = productPassword;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getVendorID() {
        return this.vendorID;
    }

    public void setVendorID(String vendorID) {
        this.vendorID = vendorID;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String version) {
        this.productVersion = version;
    }

    public boolean isTryAndBuy() {
        return this.isTryAndBuy;
    }

    public void setTryAndBuy(boolean isTryAndBuy) {
        this.isTryAndBuy = isTryAndBuy;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }
}

