<?xml version='1.0' encoding='UTF-8'?>
<!-- +========================================================================+ -->
<!-- | Licensed Materials - Property of IBM                                   | -->
<!-- | (C) Copyright IBM Corp. 2008, 2012.  All Rights Reserved.              | -->
<!-- |                                                                        | -->
<!-- | US Government Users Restricted Rights - Use, duplication or disclosure | -->
<!-- | restricted by GSA ADP Schedule Contract with IBM Corp.                 | -->
<!-- +========================================================================+ -->
<xsl:stylesheet version='1.0'
  xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
  xmlns:fo='http://www.w3.org/1999/XSL/Format'>
  <!-- NOTE: need strict mode in IE for "white-space: pre" to work -->
  <xsl:output method="html" 
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" 
    doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
    indent="yes"/>
  <xsl:variable name='anchorStart' select="'&lt;a'"/>
  <xsl:template match='/'>
    <html>
      <head>
        <xsl:if test="system-property('xsl:vendor')='Transformiix'">
          <!-- +======================================================================+ -->
          <!-- | This is only needed if running in a Gecko browser, such as Firefox.  | -->
          <!-- +======================================================================+ -->
          <script type="text/javascript">
            <![CDATA[
               function decodeHTML() {    
                  var messages = document.getElementsByName("message");
                  for (var i=0; i<messages.length; i++) {
                      var messageContent = messages[i].textContent;
                      if (messageContent && (messageContent.indexOf('&lt;a') >= 0 || messageContent.indexOf('<a') >= 0)) {
                        messages[i].innerHTML = messageContent;
                      }
                  }
              }
            ]]>
          </script>
        </xsl:if>
        <style type='text/css'>
          body {
            font-family: sans-serif;
          }
          h1 {
            font-size: 150%;
          }
          h2 {
            font-size: 120%;
          }
          table {
            border-collapse: collapse;
            border: 1 solid black;
          }
          th, td {
            padding: 0.0em 0.5em;
            vertical-align: top;
            text-align: left;
          }
          .ERROR {
            font-weight: bold;
            background-color: #f44;
            text-align: right;
          }
          .WARNING {
            font-weight: bold;
            background-color: #ff8;
            text-align: right;
          }
          .NOTE {
            font-weight: bold;
            background-color: #8f8;
            text-align: right;
          }
          .INFO {
            font-weight: bold;
            background-color: #8f8;
            text-align: right;
          }
          .DEBUG {
            font-weight: bold;
            background-color: #ddd;
            text-align: right;
          }
          .message {
            white-space: pre;
          }
        </style>
        <title>
          %Log_Title
        </title>
      </head>
      <body>
        <xsl:if test="system-property('xsl:vendor')='Transformiix'">
          <xsl:attribute name="onload">decodeHTML()</xsl:attribute>
        </xsl:if>      
        <h1>
          %Log_Title
        </h1>
        <h2>
          <xsl:for-each select='log'>
            <xsl:call-template name='replaceFirst'>
              <xsl:with-param name='string' select='"%Started_At"'/>
              <xsl:with-param name='old' select='"{0}"'/>
              <xsl:with-param name='new' select='@start'/>
            </xsl:call-template>
          </xsl:for-each>
        </h2>

        <table border='1'>
          <xsl:text>
          </xsl:text>
          <tr>
            <th></th>
            <th>%Level</th>
            <th>%Message_Id</th>
            <th>%Time</th>
            <th>%Message</th>
          </tr>
          <xsl:text>
          </xsl:text>
          <xsl:for-each select='log/entry'>
            <tr>
              <td>
                <xsl:attribute name='class'>
                  <xsl:value-of select='@level'/>
                </xsl:attribute>
                <xsl:value-of select='@num'/>
              </td>
              <td>
                <xsl:value-of select='@level'/>
              </td>
              <td>
                <xsl:value-of select='@uid'/>
              </td>
              <td>
                <xsl:value-of select='@elapsed'/>
              </td>
              <td>
                <span class='message' name='message'>
                  <xsl:choose>
                    <xsl:when test='not(message/@href)'>
                      <!-- +==================================================================+ -->
                      <!-- | Message does not have an href attribute                          | -->
                      <!-- +==================================================================+ -->
                      <xsl:call-template name="handleMessage"/>
                    </xsl:when>
                    <xsl:when test='contains(message/node(), $anchorStart)'>
                      <!-- +==================================================================+ -->
                      <!-- | Message has an href attribute and also an embedded anchor,       | -->
                      <!-- | so href attribute should be ignored                              | -->
                      <!-- +==================================================================+ -->
                        <xsl:call-template name="handleMessage"/>
                    </xsl:when>
                    <xsl:when test='contains(message/*/node(), $anchorStart)'>
                      <!-- +==================================================================+ -->
                      <!-- | Message has an href attribute and also an embedded anchor within | -->
                      <!-- | a child key or arg element, so href attribute should be ignored  | -->
                      <!-- +==================================================================+ -->
                        <xsl:call-template name="handleMessage"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <!-- +==================================================================+ -->
                      <!-- | Message has an href attribute without an embedded anchor         | -->
                      <!-- +==================================================================+ -->
                      <a>
                        <xsl:attribute name="href">
                          <xsl:value-of select='message/@href'/>
                        </xsl:attribute>
                        <xsl:call-template name="handleMessage"/>
                      </a>
                    </xsl:otherwise>
                  </xsl:choose>
                </span>
              </td>
            </tr>
            <xsl:text>
            </xsl:text>
          </xsl:for-each>
        </table>

      </body>
    </html>
  </xsl:template>

  <!-- +==============================+ -->
  <!-- | Transform the message value  | -->
  <!-- +==============================+ -->
  <xsl:template name='handleMessage'>
    <xsl:choose>
      <xsl:when test='not(message/key)'>
        <!-- +==========================================+ -->
        <!-- | Handle messages without key sub-elements | -->
        <!-- +==========================================+ -->
        <xsl:value-of select='message/node()' disable-output-escaping="yes"/>
      </xsl:when>
      <xsl:otherwise>
        <!-- +=======================================+ -->
        <!-- | Handle messages with key sub-elements | --> 
        <!-- +=======================================+ -->
        <xsl:call-template name='format'>
          <xsl:with-param name='key' select='message/key'/>
          <xsl:with-param name='pos' select='0'/>
          <xsl:with-param name='args' select='message/arg'/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- +==============================================================+ -->
  <!-- | Format a message with args, replacing {0} with args[1], etc. | -->
  <!-- +==============================================================+ -->
  <xsl:template name='format'>
    <xsl:param name='key'/>
    <xsl:param name='pos'/>
    <xsl:param name='args' select='/..'/>
    <xsl:variable name='arg' select='$args[$pos+1]'/>
    <xsl:choose>
      <xsl:when test='not($arg)'>
        <xsl:value-of select='$key' disable-output-escaping="yes"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name='sub' select='concat("{", $pos, "}")'/>
        <xsl:variable name='new_key'>
          <xsl:call-template name='replaceFirst'>
            <xsl:with-param name='string' select='$key'/>
            <xsl:with-param name='old' select='$sub'/>
            <xsl:with-param name='new' select='$arg'/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:call-template name='format'>
          <xsl:with-param name='key' select='$new_key'/>
          <xsl:with-param name='pos' select='$pos + 1'/>
          <xsl:with-param name='args' select='$args'/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- +======================================================+ -->
  <!-- | Replace first occurence of $old with $new in $string | -->
  <!-- +======================================================+ -->
  <xsl:template name='replaceFirst'>
    <xsl:param name='string'/>
    <xsl:param name='old'/>
    <xsl:param name='new'/>
    <xsl:choose>
      <xsl:when test='not(contains($string, $old))'>
        <xsl:value-of select='$string'/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name='before' select='substring-before($string, $old)'/>
        <xsl:variable name='after' select='substring-after($string, $old)'/>
        <xsl:variable name='result' select='concat($before, $new, $after)'/>
        <xsl:value-of select='concat($before, $new, $after)'/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
