#/bin/bash

IM_IMAGE_LINUX_X86=InstallerImage_linux_gtk_x86/install
IM_IMAGE_LINUX_X86_64=InstallerImage_linux_gtk_x86_64/install

##############################
# Detect machine architecture
arch=`uname -m`
if [[ $arch = "x86_64" ]]; then
   machineIs64Bit=true
else
   machineIs64Bit=false
fi

#echo machineIs64Bit=$machineIs64Bit

##############################
# Detect installed IM
imRegistry=/etc/.ibm/registry/InstallationManager.dat
imInstalled=false
if [[ -f $imRegistry ]]; then
   imLauncher=`grep launcher= $imRegistry|cut -f2 -d=`  
   if [[ -f $imLauncher ]]; then
      imVersion=`grep version= $imRegistry|cut -f2 -d=`  
      imInstalled=true
      grep is64bit=true $imRegistry > /dev/null 2>&1
      if [[ $? = 0 ]]; then
         imIs64Bit=true
      else 
         imIs64Bit=false
      fi

   fi
fi

#echo imInstalled=$imInstalled
#echo imLauncher=$imLauncher
#echo imVersion=$imVersion
#echo imIs64Bit=$imIs64Bit

##############################
# Detect which IM installer to launch
if [[ $machineIs64Bit == false ]]; then 
   launchInstaller=$IM_IMAGE_LINUX_X86
elif [[ $imInstalled == false ]]; then
   launchInstaller=$IM_IMAGE_LINUX_X86_64
elif [[ $imIs64Bit == false ]]; then
   launchInstaller=$IM_IMAGE_LINUX_X86
else
   launchInstaller=$IM_IMAGE_LINUX_X86_64
fi


#echo launchInstaller=$launchInstaller


##############################
# Detect parent dir of the script
scriptDir=`dirname $0`
#echo scriptDir=$scriptDir

##############################
# Run Command
command="$scriptDir/$launchInstaller"
$command "$@" &
