<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml"/>
<xsl:strip-space elements="link"/>
<xsl:strip-space elements="title"/>
<xsl:strip-space elements="description"/>
<xsl:strip-space elements="pubDate"/>

<!-- 
  Return the following markup for every entry found in web feed:
  
  <result>
  <item>
  <title>Element</title>
  <link>Element</link>
  </item>
  ...
  </result>

-->
<xsl:template match="/">
   <result>
   <xsl:for-each select="rss/channel/item">
   	<item>
   		<title>
      	<xsl:value-of select="title"/>
   		</title>
   		<link><xsl:value-of select="link"/></link>
   		<description><xsl:value-of select="description"/></description>
   		<pubDate><xsl:value-of select="pubDate"/></pubDate>
   </item>
   </xsl:for-each>
   </result>
</xsl:template>
<!-- Text -->
  <xsl:template match="text()">
    <xsl:value-of select="normalize-space()"/>
  </xsl:template>
</xsl:stylesheet>