/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.preferences;

import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsBase;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsStorage;
import com.ibm.cic.agent.internal.console.preferences.ConPagePrefsBase;
import com.ibm.cic.common.core.auth.AuthorizationInfoFromSecureStorage;
import com.ibm.cic.common.core.auth.PasswordManager;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.dialogs.ConMessageDialog;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import org.eclipse.equinox.internal.security.storage.friends.ReEncrypter;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class ConPagePrefsStorage
extends ConPagePrefsBase {
    private final ConViewListNumbered mainList = new ConViewListNumbered(null, true, 1);
    private final ConViewList secureStorageOptions = new ConViewList(Messages.General_Options, true);
    private ConDataCtxtPrefsStorage m_dataCtxtStorage;

    public ConPagePrefsStorage(IConManager a_conManager) {
        super(a_conManager);
    }

    @Override
    protected void displayNonEditablePreferencesInfo() {
    }

    @Override
    public void init() {
        this.setHeaderView(Messages.ConPagePrefsStorage_SecureStorage);
        if (!PasswordManager.INSTANCE.isPasswordFromFile()) {
            this.addView((IConView)new ConViewText(com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_NormalDescription));
            this.addView((IConView)new ConViewText(""));
            this.mainList.clearList();
            this.addView((IConView)this.mainList);
            this.addView((IConView)new ConViewText(com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_UseMasterExplanationLabel));
            this.addView((IConView)new ConViewText(""));
            ConViewText storageLocation = new ConViewText(NLS.bind((String)Messages.ConPagePrefsStorage_StorageLocationLabel, (Object)AuthorizationInfoFromSecureStorage.getStorageFile().getAbsolutePath()));
            this.addView((IConView)storageLocation);
            this.addView((IConView)new ConViewText(""));
            this.secureStorageOptions.clearList();
            this.addView((IConView)this.secureStorageOptions);
            this.addView((IConView)new ConViewText(com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_ResetExplanationLabel));
            this.addView((IConView)new ConViewText(""));
        } else {
            this.addView((IConView)new ConViewText(com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_passwordFileIsUsedDescription));
            this.addView((IConView)new ConViewText(""));
        }
        super.init();
    }

    @Override
    protected ConDataCtxtPrefsBase initializeDataContext() {
        this.m_dataCtxtStorage = (ConDataCtxtPrefsStorage)this.conManager().getDataContext(ConDataCtxtPrefsStorage.class);
        return this.m_dataCtxtStorage;
    }

    @Override
    public void present(OutputFormatter a_output) {
        if (!PasswordManager.INSTANCE.isPasswordFromFile()) {
            this.mainList.clearList();
            this.mainList.addEntry(Messages.ConPagePrefsStorage_UseMasterPasswordLabel, (AConActionEntry)new ConActUseMasterPassword(), this.m_dataCtxtStorage.isUseMasterPassword());
        }
        this.m_dataCtxtStorage.updatePasswordChangeDirection();
        this.secureStorageOptions.clearList();
        if (this.m_dataCtxtStorage.isUseMasterPassword()) {
            this.secureStorageOptions.addEntry(Messages.ConPagePrefsStorage_buttonChangePasswordLabel, "C", (AConActionEntry)new ConActChangeMasterPassword());
        }
        this.secureStorageOptions.addEntry(com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_buttonResetLabel, "D", (AConActionEntry)new ConActDeleteCredentials());
        super.present(a_output);
    }

    private boolean changePassword(IConManager manager) {
        ISecurePreferences startNode = SecurePreferencesFactory.getDefault();
        if (!PasswordManager.INSTANCE.triggerPasswordPrompt(startNode)) {
            return false;
        }
        ReEncrypter reEncrypter = new ReEncrypter(startNode, "com.ibm.cic.security.storage.capilanopasswordprovider");
        if (!reEncrypter.decrypt() && ConMessageDialog.openQuestion((IConManager)manager, (String)com.ibm.cic.common.core.sharedUI.Messages.changePasswordWizardTitle, (String)com.ibm.cic.common.core.sharedUI.Messages.wizardDecodeWarning)) {
            return false;
        }
        if (!reEncrypter.switchToNewPassword()) {
            if (!PasswordManager.INSTANCE.isPasswordDialogCanceled()) {
                ConMessageDialog.openError((IConManager)manager, (String)com.ibm.cic.common.core.sharedUI.Messages.changePasswordWizardTitle, (String)com.ibm.cic.common.core.sharedUI.Messages.wizardSwitchError);
            }
            return false;
        }
        reEncrypter.encrypt();
        try {
            PasswordManager.INSTANCE.savePasswordUsage();
        }
        catch (StorageException e) {
            ConMessageDialog.openError((IConManager)manager, (String)com.ibm.cic.common.core.sharedUI.Messages.changePasswordWizardTitle, (String)NLS.bind((String)com.ibm.cic.common.core.sharedUI.Messages.ChangePasswordWizardDialog_errorSavingExtraData, (Object)e.getMessage()));
        }
        return true;
    }

    class ConActChangeMasterPassword
    extends AConActionEntry<ConViewListEntry> {
        ConActChangeMasterPassword() {
        }

        public void run(IConManager a_conManager) {
            ConDataCtxtPrefsStorage context = (ConDataCtxtPrefsStorage)a_conManager.getDataContext(ConDataCtxtPrefsStorage.class);
            context.updatePasswordChangeDirection(true);
            ConPagePrefsStorage.this.changePassword(a_conManager);
            super.run(a_conManager);
        }
    }

    static class ConActDeleteCredentials
    extends AConActionEntry<ConViewListEntry> {
        ConActDeleteCredentials() {
        }

        public void run(IConManager a_conManager) {
            if (ConMessageDialog.openQuestion((IConManager)a_conManager, (String)com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_resetConfirmationTitle, (String)com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_resetConfirmationQuestion)) {
                AuthorizationInfoFromSecureStorage.deleteStorage();
                ConMessageDialog.openInformation((IConManager)a_conManager, (String)com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_storageDeletedTitle, (String)com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_StorageDeletedMessage);
            }
            super.run(a_conManager);
        }
    }

    class ConActUseMasterPassword
    extends AConActionEntry<ConViewListEntry> {
        ConActUseMasterPassword() {
        }

        public void run(IConManager a_conManager) {
            ConDataCtxtPrefsStorage context = (ConDataCtxtPrefsStorage)a_conManager.getDataContext(ConDataCtxtPrefsStorage.class);
            boolean proposedUseMasterPassword = !context.isUseMasterPassword();
            context.updatePasswordChangeDirection(proposedUseMasterPassword);
            ConPagePrefsStorage.this.changePassword(a_conManager);
            super.run(a_conManager);
        }
    }
}

