/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataLogFilters;
import com.ibm.cic.agent.internal.console.pages.ConPageElementDetails;
import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionReturnToPreviousPage;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.ConViewTreeList;
import com.ibm.cic.common.core.console.views.ConViewTreeListEntry;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.parser.CicLogParser;
import com.ibm.cic.common.logging.parser.EntryRecord;
import com.ibm.cic.common.logging.parser.LogRecord;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ConPageViewLogEntries
extends AConPage {
    private static final String FORMAT_STRING = "%-26s: %-15s: %-14s: %-15s";
    private static final String HEADER_STRING = "%-6s%-26s  %-15s  %-14s  %-15s";
    private final File logFile;
    private boolean filterChanged;
    private ConViewTreeList logEntriesTree;
    private ConViewList filterList;

    public ConPageViewLogEntries(IConManager conManager, File logFile) {
        super(conManager);
        this.logFile = logFile;
    }

    public void init() {
        this.setHeaderView(Messages.ConPageLogEntry_Header);
        boolean isCurrentSessionLog = false;
        File currentSessionLog = LogManager.getDefaultLogFile();
        if (this.logFile.equals(currentSessionLog)) {
            isCurrentSessionLog = true;
        }
        ConViewText desView = new ConViewText(isCurrentSessionLog ? Messages.ConPageLogEntry_Des_CurrentSession : NLS.bind((String)Messages.ConPageLogEntry_Des_LogFile, (Object)this.logFile.getAbsolutePath()));
        this.addView((IConView)desView);
        this.addView((IConView)new ConViewText(""));
        this.logEntriesTree = new ConViewTreeList(String.format(HEADER_STRING, " ", com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryView_dateCol, com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_severityCol, com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_messageIDCol, com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_desCol), 1, false, true, 0, false);
        LogEntryContentProvider contProvider = new LogEntryContentProvider();
        this.logEntriesTree.setContentProvider((IConViewContentProvider)contProvider);
        this.addView((IConView)this.logEntriesTree);
        this.filterList = new ConViewList(com.ibm.cic.agent.core.sharedUI.Messages.LogFilterDialog_severityLabel, true, true, 0);
        this.filterList.addEntry(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_Severity_Information, "I", (AConActionEntry)new ConActionSetFilters()).setSelected(ConDataLogFilters.getShowLog(0));
        this.filterList.addEntry(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_Severity_Note, "N", (AConActionEntry)new ConActionSetFilters()).setSelected(ConDataLogFilters.getShowLog(1));
        this.filterList.addEntry(com.ibm.cic.agent.core.sharedUI.Messages.Severity_Warning, "W", (AConActionEntry)new ConActionSetFilters()).setSelected(ConDataLogFilters.getShowLog(2));
        this.filterList.addEntry(com.ibm.cic.agent.core.sharedUI.Messages.Severity_Error, "E", (AConActionEntry)new ConActionSetFilters()).setSelected(ConDataLogFilters.getShowLog(3));
        this.addView((IConView)this.filterList);
        ConViewList otherOptions = new ConViewList(Messages.General_OtherOptions, true);
        otherOptions.addEntry(Messages.ConPageLogEntry_ReturnToFileMenu, "F", (AConActionEntry)ConActionReturnToPreviousPage.INSTANCE_PREVIOUS);
        otherOptions.addEntry(Messages.PagePreference_ReturnToMainMenu, "R", (AConActionEntry)ConActionReturnToPreviousPage.INSTANCE_FIRST);
        this.addView((IConView)otherOptions);
    }

    public void present(OutputFormatter a_output) {
        if (this.filterChanged) {
            this.logEntriesTree.refresh();
            this.filterChanged = false;
        }
        if (this.filterList != null) {
            this.filterList.clearList();
            this.filterList.addEntry(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_Severity_Information, "I", (AConActionEntry)new ConActionSetFilters()).setSelected(ConDataLogFilters.getShowLog(0));
            this.filterList.addEntry(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_Severity_Note, "N", (AConActionEntry)new ConActionSetFilters()).setSelected(ConDataLogFilters.getShowLog(1));
            this.filterList.addEntry(com.ibm.cic.agent.core.sharedUI.Messages.Severity_Warning, "W", (AConActionEntry)new ConActionSetFilters()).setSelected(ConDataLogFilters.getShowLog(2));
            this.filterList.addEntry(com.ibm.cic.agent.core.sharedUI.Messages.Severity_Error, "E", (AConActionEntry)new ConActionSetFilters()).setSelected(ConDataLogFilters.getShowLog(3));
        }
        super.present(a_output);
    }

    static class ConActionDisplayDetails
    extends AConActionEntry<ConViewTreeListEntry> {
        ConActionDisplayDetails() {
        }

        public void run(IConManager a_conManager) {
            ConViewTreeListEntry entry = (ConViewTreeListEntry)this.getEntry();
            Object element = entry.getElement();
            ConPageElementDetails detailPage = ConPageElementDetails.getDetailsPage(a_conManager, element);
            if (detailPage != null) {
                detailPage.setSuggestedInput(ConCommonCommandKeys.keys_OK[0]);
                a_conManager.addPage((AConPage)detailPage);
            }
            super.run(a_conManager);
        }
    }

    class ConActionSetFilters
    extends AConActionEntry<ConViewListEntry> {
        ConActionSetFilters() {
        }

        public void run(IConManager a_conManager) {
            int entryIndex;
            ConDataLogFilters.setShowLog(entryIndex, !ConDataLogFilters.getShowLog(entryIndex = this.getEntryIndex()));
            ConPageViewLogEntries.this.filterChanged = true;
        }
    }

    class LogEntryContentProvider
    extends AConViewContentProvider {
        LogEntryContentProvider() {
        }

        public String getLabel(Object element) {
            if (element instanceof EntryRecord) {
                EntryRecord entry = (EntryRecord)element;
                String uid = entry.getUid();
                if (uid == null) {
                    uid = "";
                }
                return String.format(ConPageViewLogEntries.FORMAT_STRING, LogUtil.toISO8601((long)entry.getTime()), SharedUIUtils.getLogSeverity((int)entry.getLevel()), uid, StatusUtil.combineAnchors((String)SharedUIUtils.constructLogDescription((EntryRecord)entry)));
            }
            return super.getLabel(element);
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object[] getElements() {
            if (ConPageViewLogEntries.this.logFile != null && ConPageViewLogEntries.this.logFile.exists()) {
                try {
                    LogRecord record = new CicLogParser().parse(ConPageViewLogEntries.this.logFile);
                    List records = record.getRecords();
                    ArrayList newList = new ArrayList();
                    int i = 0;
                    while (i < records.size()) {
                        EntryRecord entry;
                        int level;
                        Object element = records.get(i);
                        if (element != null && element instanceof EntryRecord && (level = (entry = (EntryRecord)element).getLevel()) >= Level.INFO && level < Level.MAX && ConDataLogFilters.getShowLog(level - Level.INFO)) {
                            newList.add(element);
                        }
                        ++i;
                    }
                    return newList.toArray();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return new Object[0];
        }

        public AConActionEntry getAction(Object element) {
            if (element instanceof EntryRecord) {
                return new ConActionDisplayDetails();
            }
            return super.getAction(element);
        }
    }
}

