/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.CommandRecorder;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.console.manager.InstalledOfferingsState;
import com.ibm.cic.agent.core.console.manager.SelectedLicensesState;
import com.ibm.cic.agent.core.console.manager.licensePanel.AgentLicensePageData;
import com.ibm.cic.agent.internal.console.manager.AConDataAgentWizard;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtCustomPanelList;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtCustomPanels;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtFeatures;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPreChecks;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUpdateVersionSelector;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUtils;
import com.ibm.cic.agent.internal.console.manager.ConManager;
import com.ibm.cic.agent.internal.console.manager.JobListManager;
import com.ibm.cic.agent.internal.console.manager.ProfileListManager;
import com.ibm.cic.common.core.console.manager.IConDataCtxt;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.shared.manager.licensePanel.LicensePageDataContext;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class ConDataCtxtUpdate
extends AConDataAgentWizard {
    IConManager m_manager;
    private final Profile[] m_allProfiles;
    private boolean m_updateAll = false;
    private final JobListManager m_selectedUpdateOfferingJobs = new JobListManager();
    private final JobListManager m_selectedInstallFixJobs = new JobListManager();
    private final ProfileListManager m_selectedProfiles = new ProfileListManager();
    ConDataCtxtUpdateVersionSelector m_contextUpdateVersion = null;
    LicensePageDataContext m_licesePageContext = null;
    private ConDataCtxtFeatures m_featuresContext = null;
    private ConDataCtxtCustomPanels m_customPanelsContext = null;
    private ConDataCtxtCustomPanelList m_updateCustomPanelListCtxt = null;
    private ConDataCtxtPreChecks m_prerequisiteChecksCtxt = null;

    public ConDataCtxtUpdate(IConManager a_manager) {
        this.m_manager = a_manager;
        Agent agent = Agent.getInstance();
        agent.getRepositoryGroupStatus(true, ConsoleProgressMonitor.createMonitorWithUnknownWork());
        this.m_allProfiles = agent.getSortedProductProfiles(false);
        if (this.m_allProfiles.length == 1) {
            this.m_selectedProfiles.selectProfile(this.m_allProfiles[0]);
        }
    }

    public <T extends IConDataCtxt> T getAdapter(Class<T> cls) {
        if (cls == ConDataCtxtUpdateVersionSelector.class) {
            if (this.m_contextUpdateVersion == null) {
                this.m_contextUpdateVersion = new ConDataCtxtUpdateVersionSelector(this);
            }
            return (T)((Object)this.m_contextUpdateVersion);
        }
        if (cls == ConDataCtxtPreChecks.class) {
            if (this.m_prerequisiteChecksCtxt == null) {
                this.m_prerequisiteChecksCtxt = new ConDataCtxtPreChecks(this.getSelectedJobs().toList());
            }
            return (T)((Object)this.m_prerequisiteChecksCtxt);
        }
        if (cls == LicensePageDataContext.class) {
            if (this.m_licesePageContext == null || this.m_contextUpdateVersion != null && (this.m_selectedUpdateOfferingJobs.isChanged() || this.m_selectedInstallFixJobs.isChanged())) {
                this.clear();
                SelectedLicensesState licenseState = new SelectedLicensesState(new InstalledOfferingsState(), this.getSelectedJobs().toList());
                AgentLicensePageData agentLicensePageData = AgentLicensePageData.create(licenseState);
                this.m_licesePageContext = new LicensePageDataContext(agentLicensePageData.getLicenses());
            }
            return (T)this.m_licesePageContext;
        }
        if (cls == ConDataCtxtFeatures.class) {
            if (this.m_featuresContext == null) {
                this.m_featuresContext = new ConDataCtxtFeatures(this.getSelectedJobs());
            }
            return (T)((Object)this.m_featuresContext);
        }
        if (cls == ConDataCtxtCustomPanelList.class) {
            if (this.m_updateCustomPanelListCtxt == null) {
                this.m_updateCustomPanelListCtxt = new ConDataCtxtCustomPanelList(this.getSelectedJobs().toArray());
            }
            return (T)((Object)this.m_updateCustomPanelListCtxt);
        }
        if (cls == ConDataCtxtCustomPanels.class) {
            if (this.m_customPanelsContext == null) {
                this.m_customPanelsContext = new ConDataCtxtCustomPanels(this.getSelectedJobs().toArray());
            }
            return (T)((Object)this.m_customPanelsContext);
        }
        return (T)super.getAdapter(cls);
    }

    public Profile[] getAllProductProfiles() {
        return this.m_allProfiles;
    }

    public ProfileListManager getSelectedProfiles() {
        return this.m_selectedProfiles;
    }

    public Profile getSingleSelectedProfile() {
        if (!this.isUpdateAllRequested() && this.m_selectedProfiles.size() == 1 && this.m_allProfiles.length > 0) {
            return this.m_selectedProfiles.get(0);
        }
        return null;
    }

    private void clear() {
        this.m_licesePageContext = null;
        this.m_featuresContext = null;
        this.m_updateCustomPanelListCtxt = null;
        this.m_customPanelsContext = null;
        this.m_prerequisiteChecksCtxt = null;
        this.m_selectedUpdateOfferingJobs.resetChanged();
        this.m_selectedInstallFixJobs.resetChanged();
    }

    public boolean areAllProfilesSelected() {
        return this.m_selectedProfiles.size() == this.getAllProductProfiles().length;
    }

    public void flipProfileSelection(Profile a_profile) {
        if (this.m_selectedProfiles.contains(a_profile)) {
            this.m_selectedProfiles.clear();
            this.m_updateAll = false;
        } else {
            this.m_selectedProfiles.clear();
            this.m_selectedProfiles.selectProfile(a_profile);
        }
    }

    public void selectAllProfiles(boolean select) {
        Profile[] profiles = this.getAllProductProfiles();
        this.m_updateAll = select;
        if (select) {
            Profile[] profileArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                this.m_selectedProfiles.selectProfile(profile);
                ++n2;
            }
        } else {
            this.m_selectedProfiles.clear();
        }
    }

    public boolean isUpdateAllRequested() {
        return this.m_updateAll;
    }

    public CommandRecorder getCommandRecorder() {
        ArrayList<Object> allSelectedJobs = new ArrayList<Object>();
        List updateOfferingJobs = SortUtil.sortByProfileNameAndVersion(this.getSelectedJobs().toList(), (boolean)false);
        for (UpdateOfferingJob j : updateOfferingJobs) {
            j.setAcceptLicense(true);
            j.setSelected(true);
            allSelectedJobs.add(j);
        }
        List<InstallJob> installFixJobs = this.getSelectedInstallFixJobs().toList();
        for (InstallJob installFixJob : installFixJobs) {
            installFixJob.setAcceptLicense(true);
            installFixJob.setSelected(true);
            allSelectedJobs.add(installFixJob);
        }
        AgentJob[] jobsToUpdate = allSelectedJobs.toArray(new AgentJob[allSelectedJobs.size()]);
        CommandRecorder commandRecorder = new CommandRecorder();
        commandRecorder.recordJobs(jobsToUpdate, true);
        return commandRecorder;
    }

    public IStatus updateSelectedPackages() {
        Agent.getInstance().setSkipInstall(CmdLine.CL.containsCommand("-skipInstall"));
        IStatus return_value = ((ConManager)this.m_manager).getConsoleApp().run(this.getCommandRecorder().getRecordedCommand(), CmdLine.CL.getParam1StrVal("-record"));
        return return_value;
    }

    @Override
    public void dispose() {
        ConDataCtxtUtils.unprepareAndClear(this.m_selectedUpdateOfferingJobs);
        ConDataCtxtUtils.unprepareAndClear(this.m_selectedInstallFixJobs);
        super.dispose();
    }

    public JobListManager<UpdateOfferingJob> getSelectedJobs() {
        return this.m_selectedUpdateOfferingJobs;
    }

    public JobListManager<InstallJob> getSelectedInstallFixJobs() {
        return this.m_selectedInstallFixJobs;
    }

    public List<AgentJob> getAllSelectedJobs() {
        ArrayList<AgentJob> allSelectedJobs = new ArrayList<AgentJob>();
        allSelectedJobs.addAll(this.getSelectedJobs().toList());
        allSelectedJobs.addAll(this.getSelectedInstallFixJobs().toList());
        return allSelectedJobs;
    }
}

