/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsInternet;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsMain;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.downloads.INonsecureConnectionPrompter;
import com.ibm.cic.common.downloads.NonsecureConnectionManager;
import com.ibm.cic.common.downloads.NonsecureConnectionPrompter;
import com.ibm.cic.common.downloads.NonsecureConnectionSessionState;

public class ConDataCtxtPrefsSSL
extends ConDataCtxtPrefsInternet {
    private final ICicPreferenceConstants.PreferenceTag m_useNonSecureModeTag = ICicPreferenceConstants.SSL_NONSECURE_MODE;
    private boolean m_useNonSecureMode;
    private boolean m_sessionOnly;

    ConDataCtxtPrefsSSL(ConDataCtxtPrefsMain a_mainPreferenceDataContext) {
        super(a_mainPreferenceDataContext);
        this.determineInitialValues();
    }

    public boolean getUseNonSecureMode() {
        return this.m_useNonSecureMode;
    }

    public void setUseNonSecureMode(boolean useNonSecureMode) {
        this.m_useNonSecureMode = useNonSecureMode;
        this.m_preferencesChanged = true;
    }

    public void setSessionOnly(boolean sessionOnly) {
        this.m_sessionOnly = sessionOnly;
    }

    public boolean getSessionOnly() {
        return this.m_sessionOnly;
    }

    @Override
    public boolean isPreferenceEditable() {
        return SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)this.m_useNonSecureModeTag);
    }

    private void determineInitialValues() {
        this.m_useNonSecureMode = CicPreferenceManager.getInstance().getBoolean(this.m_useNonSecureModeTag.key());
        if (this.m_useNonSecureMode) {
            this.m_sessionOnly = false;
        } else if (NonsecureConnectionSessionState.INSTANCE.isNonsecureMode()) {
            this.m_useNonSecureMode = true;
            this.m_sessionOnly = true;
        } else {
            this.m_useNonSecureMode = false;
            this.m_sessionOnly = true;
        }
    }

    @Override
    protected void resetRepositoryConnection() {
        INonsecureConnectionPrompter previousPrompter = NonsecureConnectionPrompter.INSTANCE.getPrompter();
        NonsecureConnectionPrompter.INSTANCE.setPrompter(null);
        try {
            super.resetRepositoryConnection();
        }
        finally {
            NonsecureConnectionPrompter.INSTANCE.setPrompter(previousPrompter);
        }
    }

    @Override
    public void savePreferences() {
        if (this.m_useNonSecureMode) {
            if (this.m_sessionOnly) {
                NonsecureConnectionSessionState.INSTANCE.setNonsecureMode(true);
                this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(this.m_useNonSecureModeTag.key(), false);
            } else {
                NonsecureConnectionSessionState.INSTANCE.setNonsecureMode(false);
                this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(this.m_useNonSecureModeTag.key(), this.m_useNonSecureMode);
            }
        } else {
            NonsecureConnectionSessionState.INSTANCE.setNonsecureMode(false);
            this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(this.m_useNonSecureModeTag.key(), this.m_useNonSecureMode);
        }
        NonsecureConnectionManager.INSTANCE.dropConnections();
        super.savePreferences();
    }

    @Override
    public void restoreDefaults() {
        boolean permanentNonsecureMode = this.m_mainPrefDataContext.getDefaultPrefHandler().getBoolean(this.m_useNonSecureModeTag);
        if (permanentNonsecureMode) {
            this.m_useNonSecureMode = true;
            this.m_sessionOnly = true;
        } else {
            this.m_useNonSecureMode = false;
            this.m_sessionOnly = true;
        }
        NonsecureConnectionManager.INSTANCE.dropConnections();
        this.m_preferencesChanged = true;
    }
}

