/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.dialogs;

import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionExit;
import com.ibm.cic.common.core.console.dialogs.AConDialog;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.ConPageEnterPath;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.StatusUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConDataLocationDialog
extends AConDialog {
    public ConDataLocationDialog() {
        super(null, com.ibm.cic.agent.core.sharedUI.Messages.DataLocationDialog_Title);
    }

    protected AConDialog.AConDialogPage createPage() {
        return new DLPage(this);
    }

    private ActionEntry createActionEntry() {
        return new ActionEntry();
    }

    private class ActionEntry
    extends ConActionExit {
        private ActionEntry() {
        }

        public void run(IConManager manager) {
            ConDataLocationDialog.this.setReturnCode(this.getEntryIndex());
        }
    }

    protected static class DLPage
    extends AConDialog.AConDialogPage {
        private ConViewText locationText;
        private ConViewStatus m_status;

        public DLPage(ConDataLocationDialog dialog) {
            super((AConDialog)dialog);
        }

        protected void createContent() {
            this.m_status = new ConViewStatus();
            this.addView((IConView)this.m_status);
            this.addView((IConView)new ConViewText(com.ibm.cic.agent.core.sharedUI.Messages.DataLocationDialog_Message));
            this.addView((IConView)ConViewText.NEW_LINE);
            this.addView((IConView)new ConViewText(com.ibm.cic.agent.core.sharedUI.Messages.DataLocationDialog_Label));
            this.locationText = new ConViewText(CicCommonSettings.getApplicationDataLocation(), 4);
            this.addView((IConView)this.locationText);
            this.addView((IConView)ConViewText.NEW_LINE);
            ConViewList changeLocation = new ConViewList(Messages.General_Options, true);
            changeLocation.addEntry(Messages.ConDataLocationDialog_changeDataLocation, "M", (AConActionEntry)ConPageEnterPath.getEnterPathPageAction((String)Messages.ConDataLocationDialog_enterDataLocationHeader, (String)Messages.ConDataLocationDialog_enterDataLocationText, (ConPageEnterPath.ConActionEnterPath)new ConPageEnterPath.ConActionEnterPath(){

                protected IStatus processInput() {
                    return this.verifyLocation(this.getInput());
                }
            }));
            this.addView((IConView)changeLocation);
        }

        protected ConViewList createActions() {
            ConViewList listView = new ConViewList(null, false);
            ConDataLocationDialog dialog = (ConDataLocationDialog)this.getDialog();
            listView.addEntry(com.ibm.cic.common.core.console.Messages.General_Dlg_Ok, ConCommonCommandKeys.keys_OK, (AConActionEntry)dialog.createActionEntry());
            listView.addEntry(com.ibm.cic.common.core.console.Messages.General_Dlg_Cancel, ConCommonCommandKeys.keys_Cancel, (AConActionEntry)dialog.createActionEntry());
            listView.setNewLineAfterList(true);
            this.setSuggestedInput(ConCommonCommandKeys.keys_OK[0]);
            return listView;
        }

        protected String createHeader() {
            StringBuilder sb = new StringBuilder();
            sb.append(com.ibm.cic.agent.core.sharedUI.Messages.DataLocationDialog_ShellTitle);
            sb.append("> ");
            sb.append(com.ibm.cic.agent.core.sharedUI.Messages.DataLocationDialog_Title);
            return sb.toString();
        }

        private IStatus verifyLocation(String dataLocation) {
            IStatus status = SharedUIUtils.verifyDataLocation((String)dataLocation);
            if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
                this.m_status.setStatus(status);
                this.locationText.setText(dataLocation);
                status = Status.OK_STATUS;
            }
            return status;
        }
    }
}

