/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.commonNativeAdapterData;

import com.ibm.cic.common.commonNativeAdapterData.ZipCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.internal.Messages;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.AbstractArtifact;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.impl.MapToLegacyKeyUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class ZipArtifact
extends AbstractArtifact {
    public static final String ZIP_QUALIFIER = "zip";
    public static final String ARTIFACT_ID = "native";
    private final IArtifactKey key;
    private ArtifactCommonAttributes aca;
    private String xmlKey;
    private ZipCommonNativeData data = null;

    public ZipArtifact(IInstallableUnit iu, IPath path) {
        this.key = new ArtifactKey(path, ARTIFACT_ID, ZIP_QUALIFIER, iu.getIdentity(), iu.getVersion());
        this.xmlKey = ZipArtifact.getXMLKey(this.key);
    }

    public ZipArtifact(ArtifactCommonAttributes aca) {
        this.key = new ArtifactKey((IPath)Path.EMPTY, ARTIFACT_ID, ZIP_QUALIFIER, (IIdentity)new SimpleIdentity(aca.getId()), aca.getVersion());
        this.aca = aca;
    }

    public ZipArtifact(IInstallableUnit iu, String rawKey) {
        this.key = ZipArtifact.createKey(iu, rawKey);
        this.xmlKey = rawKey;
    }

    public ArtifactCommonAttributes getCommonAttributes() {
        return this.aca;
    }

    public String getLegacyXMLKeyString() {
        return this.xmlKey;
    }

    private static String getXMLKey(IArtifactKey key) {
        IPath path = key.getPath();
        if (!path.isEmpty()) {
            return path.toString();
        }
        MapToLegacyKeyUtil.ColonArtifactKeyInfo colonKey = new MapToLegacyKeyUtil.ColonArtifactKeyInfo();
        colonKey.setIdentity(key.getId().getId());
        colonKey.setVersion(key.getVersion().toString());
        colonKey.setQualns(key.getNamespace());
        return MapToLegacyKeyUtil.createKeyString((MapToLegacyKeyUtil.ColonArtifactKeyInfo)colonKey);
    }

    private static IArtifactKey createKey(IInstallableUnit iu, String rawKey) {
        MapToLegacyKeyUtil.ColonArtifactKeyInfo artifactColonKey = MapToLegacyKeyUtil.parseForColonArtifactKey((String)rawKey);
        if (artifactColonKey != null) {
            return new ArtifactKey((IPath)Path.EMPTY, ARTIFACT_ID, ZIP_QUALIFIER, (IIdentity)new SimpleIdentity(artifactColonKey.getIdentity()), new Version(artifactColonKey.getVersion()));
        }
        IPath path = MapToLegacyKeyUtil.parseForNonColonArtifactKey((String)rawKey);
        return new ArtifactKey(path, ARTIFACT_ID, ZIP_QUALIFIER, iu.getIdentity(), iu.getVersion());
    }

    public IArtifactKey getKey() {
        return this.key;
    }

    public static String toUserString(IArtifactKey key, int options) {
        String result;
        if (key == null) {
            return null;
        }
        if (options == 2) {
            result = NLS.bind((String)Messages.ICommonNativeData_zip_artifact_id_only, (Object)key.getId());
        } else {
            assert (options == 1);
            result = NLS.bind((String)Messages.ICommonNativeData_zip_artifact, (Object)key.getId(), (Object)key.getVersion());
        }
        if (!key.getPath().isEmpty()) {
            result = String.valueOf(result) + '/' + key.getPath().toString();
        }
        return result;
    }

    public String toUserString() {
        return ZipArtifact.toUserString(this.key, 1);
    }

    public ZipCommonNativeData getData() {
        return this.data;
    }

    public void setData(ZipCommonNativeData data) {
        this.data = data;
    }
}

