/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleInfo;
import com.ibm.cic.agent.internal.installAdaptors.BundleManager;
import com.ibm.cic.agent.internal.installAdaptors.ConfigurationContributorEditor;
import com.ibm.cic.agent.internal.installAdaptors.EclipseBundleOperation;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.agent.internal.installAdaptors.RemoveAgentBundleOperation;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.eclipseAdapterData.EclipseAgentBundleData;
import com.ibm.cic.common.eclipseAdapterData.EclipseArtifact;
import com.ibm.cic.common.eclipseAdapterData.EclipseBundleData;
import com.ibm.cic.common.logging.Logger;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class InstallAgentBundleOperation
extends EclipseBundleOperation {
    private final EclipseAgentBundleData bundleData;
    private final BundleManager bundleManager;
    private static final String ReferenceSegment = "reference:";

    public InstallAgentBundleOperation(EclipseAgentBundleData bundleData, BundleManager manager, Collection artifacts, IInstallableUnit unit, InstallContext context, ConfigurationContributorEditor targetedConfig, boolean configure) {
        super(artifacts, unit, context, targetedConfig, configure);
        this.bundleData = bundleData;
        this.bundleManager = manager;
        new RemoveAgentBundleOperation(manager);
    }

    protected CommonAdapterData getData() {
        return this.bundleData;
    }

    private Bundle getInstalledBundle(BundleContext bundleContext, String bundleId) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equals(bundleId)) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        BundleInfo bundle = this.getInfo((EclipseBundleData)this.bundleData);
        if (this.isConfigure()) {
            return this.install(bundle, monitor);
        }
        return this.uninstall(bundle, monitor);
    }

    private IStatus install(BundleInfo info, IProgressMonitor monitor) {
        if (AgentUserOptions.CIC_GIVE_QUALIFIER_BUNDLES_PRECEDENCE.isSet() && this.isWorkspaceVersionOfBundleAlreadyLoaded(info)) {
            return Status.OK_STATUS;
        }
        Bundle installed = this.bundleManager.getBundle(info, this.getUnit().getParent());
        if (installed != null) {
            return Status.OK_STATUS;
        }
        BundleContext bundleContext = Agent.getInstance().getAgentBundleContext();
        try {
            installed = bundleContext.installBundle(ReferenceSegment + info.getLocation());
            if (installed != null) {
                Bundle[] bundlesToRefresh = null;
                Bundle oldBundle = Platform.getBundle((String)info.getSymbolicName());
                bundlesToRefresh = oldBundle != null && installed.getVersion().compareTo(oldBundle.getVersion()) > 0 ? new Bundle[]{oldBundle, installed} : new Bundle[]{installed};
                InstallAgentBundleOperation.refreshPackages(bundlesToRefresh, bundleContext);
                int bundleState = installed.getState();
                if (bundleState == 2 || bundleState == 4 || bundleState == 8) {
                    this.bundleManager.addBundle(installed, this.getUnit().getParent());
                }
            }
        }
        catch (BundleException e) {
            String msg = NLS.bind((String)Messages.EclipseInstallAdaptor_error_installing_agent_bundle, (Object[])new Object[]{this.bundleData.getId(), this.bundleData.getVersion(), info.getLocation(), e.getLocalizedMessage()});
            Bundle installedBundle = this.getInstalledBundle(bundleContext, info.getSymbolicName());
            if (installedBundle == null) {
                return new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)e);
            }
            Logger.getLogger(((Object)((Object)this)).getClass()).log(4, (Throwable)e, msg, new Object[0]);
        }
        if (this.artifacts.size() > 0) {
            this.bundleManager.addArtifacts(this.artifacts);
        }
        return Status.OK_STATUS;
    }

    private IStatus uninstall(BundleInfo info, IProgressMonitor monitor) {
        Bundle bundle = this.bundleManager.removeBundle(info, this.getUnit().getParent());
        if (bundle != null) {
            RemoveAgentBundleOperation.uninstallBundle(bundle);
            BundleContext bundleContext = Agent.getInstance().getAgentBundleContext();
            InstallAgentBundleOperation.refreshPackages(new Bundle[]{bundle}, bundleContext);
        }
        return Status.OK_STATUS;
    }

    protected boolean isMatchingArtifact(IArtifact artifact) {
        return artifact instanceof EclipseArtifact && ((EclipseArtifact)artifact).getType() == 2;
    }

    private boolean isWorkspaceVersionOfBundleAlreadyLoaded(BundleInfo info) {
        Version loadedVersion;
        Bundle loadedBundle = Platform.getBundle((String)info.getSymbolicName());
        if (loadedBundle != null && "qualifier".equals((loadedVersion = loadedBundle.getVersion()).getQualifier())) {
            try {
                Version bundleInfoVersion = new Version(info.getVersion());
                if (loadedVersion.getMajor() == bundleInfoVersion.getMajor() && loadedVersion.getMinor() == bundleInfoVersion.getMinor() && loadedVersion.getMicro() == bundleInfoVersion.getMicro()) {
                    return true;
                }
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
        return false;
    }
}

