/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipse.qualification;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.eclipse.qualification.ModelUtils;
import com.ibm.cic.agent.internal.eclipse.qualification.NewProfileQualificationOperation;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.utils.NLS;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class NewOfferingQualificationOperation {
    private final Profile profile;
    private final IOffering offering;

    public NewOfferingQualificationOperation(Profile profile, IOffering offering) {
        this.profile = profile;
        this.offering = offering;
    }

    public IStatus qualifyNewOffering() {
        Version minVersion;
        Version version;
        String platformFeatureId = NewProfileQualificationOperation.getPlatformFeatureId();
        NewProfileQualificationOperation newProfileOp = new NewProfileQualificationOperation(this.profile);
        IStatus status = newProfileOp.determineEclipseProperties();
        if (!status.isOK()) {
            return status;
        }
        String versionText = this.profile.getData("existing.eclipse.ide.platform.version");
        if (versionText != null && (version = new Version(versionText)).compareTo(minVersion = this.getMinimumPlatformVersion(platformFeatureId)) < 0) {
            return new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, NLS.bind((String)Messages.EclipseQualificationOperation_platformVersionError, (Object)version, (Object)minVersion), null);
        }
        status = this.checkForFilteredProduct();
        if (!status.isOK()) {
            return status;
        }
        status = this.checkPlatformProperties(newProfileOp.getExistingEclipseWs(), newProfileOp.getExistingEclipseOs(), newProfileOp.getExistingEclipseArch());
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    private Version getMinimumPlatformVersion(String platformFeatureId) {
        String min = System.getProperty("minimum.eclipse.ide.platform.version");
        if (min != null) {
            return new Version(min);
        }
        Version version = this.findMinimumEclipseIdePlatformVersionProperty();
        if (version != null) {
            return version;
        }
        String suId = String.valueOf(platformFeatureId) + ".feature";
        version = this.findFeatureShareableUnitWithHighestVersion(suId);
        if (version != null) {
            return version;
        }
        return new Version(3, 2, 1);
    }

    private Version findMinimumEclipseIdePlatformVersionProperty() {
        String minVersion = this.offering.getProperties().getProperty("minimum.eclipse.ide.platform.version");
        if (minVersion == null) {
            return null;
        }
        Version version = new Version(minVersion);
        return version;
    }

    private Version findFeatureShareableUnitWithHighestVersion(String suId) {
        IShareableUnit su = ModelUtils.findOfferingShareableUnitWithHighestVersion(this.offering, suId);
        if (su == null) {
            return null;
        }
        Version version = su.getVersion();
        return new Version(version.getMajor(), version.getMinor(), version.getMicro());
    }

    private IStatus checkForFilteredProduct() {
        String[] filters;
        String productId = this.profile.getData("existing.eclipseproduct.id");
        String productName = this.profile.getData("existing.eclipseproduct.name");
        if (productId == null || productName == null) {
            return Status.OK_STATUS;
        }
        String filtersText = this.offering.getProperties().getProperty("eclipse.ide.product.id.filters");
        if (filtersText == null || filtersText.trim().length() == 0) {
            return Status.OK_STATUS;
        }
        String[] stringArray = filters = filtersText.split(",");
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            String regex = filter.trim();
            if (regex.length() != 0) {
                regex = regex.replaceAll("\\.", "\\\\.");
                regex = regex.replaceAll("\\*", ".*");
                if (productId.matches(regex = regex.replaceAll("\\?", "."))) {
                    return new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, NLS.bind((String)Messages.NewOfferingQualificationOperation_eclipseProductError, (Object[])new Object[]{this.offering.getName(), productName, productId}), null);
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkPlatformProperties(String ws, String os, String arch) {
        String platformString = NewOfferingQualificationOperation.toPlatformString(ws, os, arch);
        String profilePlatformString = NewOfferingQualificationOperation.toPlatformString(this.profile.getWS(), this.profile.getOS(), this.profile.getArch());
        if (!profilePlatformString.equals(platformString)) {
            return new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, NLS.bind((String)Messages.NewOfferingQualificationOperation_eclipsePlatformPropertiesError, (Object)platformString, (Object)profilePlatformString), null);
        }
        return Status.OK_STATUS;
    }

    private static String toPlatformString(String ws, String os, String arch) {
        return "(ws=" + ws + ", os=" + os + ", arch=" + arch + ")";
    }
}

