/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.commons.net;

import com.ibm.cic.common.core.internal.utils.CicCommonCoreDateTrace;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.downloads.DownloadTrace;
import com.ibm.cic.common.downloads.PreferencesHolder;
import com.ibm.cic.common.downloads.handlerImpl.FtpUrlEncodedLogin;
import com.ibm.cic.common.transports.commons.net.FTPClientCommandListener;
import com.ibm.cic.common.transports.commons.net.FTPClientUtil;
import com.ibm.cic.common.transports.commons.net.FtpConnectionManager;
import com.ibm.cic.common.transports.commons.net.FtpCredentialsProvider;
import com.ibm.cic.common.transports.commons.net.FtpException;
import com.ibm.cic.common.transports.commons.net.TimeoutSocketFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;

public class FTPClientConnections {
    protected static final CicCommonCoreTrace dlTrace = DownloadTrace.traceIssues;
    protected static final CicCommonCoreDateTrace dlTraceHappy = DownloadTrace.traceHappy;
    protected static final CicCommonCoreTrace traceMcpConnect = DownloadTrace.traceMcpConnect;
    protected static final CicCommonCoreTrace traceMcpLease = DownloadTrace.traceMcpLease;
    public static final FTPClientConnections INSTANCE = new FTPClientConnections();
    private final FtpConnectionManager cmgr = this.createConnectionManager();
    private final FtpConnectionManager.IFTPConnectionFactory factory = new FTPClientConnectionFactory();

    protected FtpConnectionManager createConnectionManager() {
        return new FtpConnectionManager();
    }

    public IFTPClientConnection getFtpConnection(URI uri) throws SocketException, IOException {
        return (IFTPClientConnection)((Object)this.cmgr.getFtpConnection(this.factory, uri));
    }

    public void releaseAll() {
        this.cmgr.releaseAll();
    }

    public void returnConnection(IFTPClientConnection connection) {
        this.cmgr.returnConnection((FtpConnectionManager.IFTPConnection)((Object)connection));
    }

    public static class FTPClientConnection
    implements FtpConnectionManager.IFTPConnection,
    IFTPClientConnection {
        private final URI uri;
        private final RevealingFTPClient ftpClient;

        public FTPClientConnection(URI uri) {
            this.uri = uri;
            this.ftpClient = new RevealingFTPClient();
            this.ftpClient.setSocketFactory(new TimeoutSocketFactory());
            int timeout = PreferencesHolder.INSTANCE.getReadTimeout() * 1000;
            this.ftpClient.setDataTimeout(timeout);
            this.ftpClient.setDefaultTimeout(timeout);
        }

        @Override
        public String getAuthority() {
            return this.uri.getAuthority();
        }

        @Override
        public FTPClient getFTPClient() {
            return this.ftpClient;
        }

        @Override
        public Socket getControlSocket() {
            return this.ftpClient.getControlSocket();
        }

        public void connect() throws SocketException, IOException {
            String host = this.uri.getHost();
            int port = this.uri.getPort();
            if (port == -1) {
                this.ftpClient.connect(host);
            } else {
                this.ftpClient.connect(host, port);
            }
            FTPClientUtil.checkNegativeReply(this.ftpClient);
        }

        public void login() throws IOException {
            FtpUrlEncodedLogin.login((URI)this.uri, (FtpUrlEncodedLogin.IFtpLogin)new FtpUrlEncodedLogin.IFtpLogin(){
                FtpException exception;

                public boolean login(String username, String password) throws IOException {
                    boolean ok = ftpClient.login(username, password);
                    if (!ok) {
                        this.exception = new FtpException(ftpClient.getReplyCode(), ftpClient.getReplyStrings());
                    }
                    return ok;
                }

                public void throwExceptionForLastResponse() throws IOException {
                    throw this.exception;
                }
            }, (FtpUrlEncodedLogin.IFtpCredentialProvider)FtpCredentialsProvider.INSTANCE);
            if (FTPClientConnections.dlTraceHappy.enabled) {
                this.ftpClient.addProtocolCommandListener(new FTPClientCommandListener((CicCommonCoreTrace)dlTraceHappy));
            }
            this.ftpClient.setFileType(2);
            FTPClientUtil.checkNegativeReply(this.ftpClient);
            this.ftpClient.enterLocalPassiveMode();
        }

        @Override
        public void disconnect() {
            if (this.ftpClient.isConnected()) {
                if (FTPClientConnections.traceMcpConnect.enabled) {
                    traceMcpConnect.getLog().debug("disconnecting {0}", new Object[]{this});
                }
                try {
                    this.ftpClient.disconnect();
                    if (FTPClientConnections.traceMcpConnect.enabled) {
                        traceMcpConnect.getLog().debug("disconnecting {0} done", new Object[]{this});
                    }
                }
                catch (IOException e) {
                    traceMcpConnect.getLog().debug("exception disconnecting {0}: {1}", new Object[]{this.getControlSocket(), e});
                }
            } else if (FTPClientConnections.traceMcpConnect.enabled) {
                traceMcpConnect.getLog().debug("disconnecting {0}: already disconnected", new Object[]{this});
            }
        }

        @Override
        public void assureConnected() throws IOException {
            try {
                this.ftpClient.noop();
            }
            catch (FTPConnectionClosedException e) {
                traceMcpConnect.getLog().debug("reconnection closed connection: {0}", new Object[]{e});
                FTPClientConnectionFactory.connect(this);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("authority=");
            sb.append(this.getAuthority());
            sb.append(" socket=");
            sb.append(this.ftpClient.getControlSocket());
            return sb.toString();
        }

        static class RevealingFTPClient
        extends FTPClient {
            public Socket getControlSocket() {
                return this._socket_;
            }
        }
    }

    static class FTPClientConnectionFactory
    implements FtpConnectionManager.IFTPConnectionFactory {
        FTPClientConnectionFactory() {
        }

        static void connect(FTPClientConnection ftp) throws IOException {
            try {
                ftp.connect();
                ftp.login();
            }
            catch (IOException e) {
                traceMcpConnect.getLog().debug("Exception during connection of {0}: {2}", new Object[]{ftp, e});
                try {
                    ftp.disconnect();
                }
                catch (Throwable t) {
                    traceMcpConnect.getLog().debug("Exception during disconnect of {0}: {2}", new Object[]{ftp, t});
                }
                throw e;
            }
        }

        @Override
        public FtpConnectionManager.IFTPConnection createConnection(URI uri) throws SocketException, IOException {
            FTPClientConnection ftp = new FTPClientConnection(uri);
            FTPClientConnectionFactory.connect(ftp);
            return ftp;
        }
    }

    public static interface IFTPClientConnection {
        public FTPClient getFTPClient();

        public Socket getControlSocket();

        public void disconnect() throws IOException;
    }
}

