/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.nativeAdapterData.win32;

import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.nativeAdapterData.win32.RegistryKeyNativeData;

public class RegistryNativeData
extends RegistryKeyNativeData {
    private final boolean replace;
    private final String accessMask;

    public RegistryNativeData(String name, String value, String type, boolean replace, String a_accessMask) {
        super(name, value, type);
        this.replace = replace;
        this.accessMask = a_accessMask;
    }

    public boolean replace() {
        return this.replace;
    }

    @Override
    public String getElementName() {
        return "registry";
    }

    @Override
    protected CommonAdapterData.NameValuePairs getAttrNameValuePairs() {
        return super.getAttrNameValuePairs().addIfTrue("replace", this.replace).add("accessMask", (Object)this.accessMask);
    }

    public static boolean isValidAccessMask(String a_accessMask) {
        if (a_accessMask == null || a_accessMask.length() == 0) {
            return true;
        }
        if ("KEY_WOW64_32KEY".equals(a_accessMask)) {
            return true;
        }
        if ("KEY_WOW64_64KEY".equals(a_accessMask)) {
            return true;
        }
        return "KEY_NO_MASK".equals(a_accessMask);
    }

    public int getAccessMaskIntValue() {
        return "KEY_WOW64_64KEY".equals(this.accessMask) ? 256 : 512;
    }
}

