/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.template;

import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.internal.template.TemplateBinding;
import com.ibm.cic.common.xml.core.model.IProcessingInstruction;
import com.ibm.cic.common.xml.core.model.IXMLElementVisitor;
import com.ibm.cic.common.xml.core.model.IXMLModel;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import com.ibm.cic.common.xml.core.template.ITemplateBinding;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class TemplateProcessingVisitor
implements IXMLElementVisitor {
    private final IXMLModel fDoc;
    private final TemplateBinding fBinding;
    private final IXMLModel fTarget;
    private final MultiStatus fStatus;
    private HashMap fTemplateToOutput;
    private ArrayList fSkip;

    public TemplateProcessingVisitor(ITemplateBinding binding, IXMLModel target) {
        this.fBinding = (TemplateBinding)binding;
        this.fTarget = target;
        this.fDoc = binding.getTemplate().getModel();
        this.fTemplateToOutput = new HashMap();
        this.fTemplateToOutput.put(this.fDoc, target);
        this.fSkip = new ArrayList();
        this.fStatus = new MultiStatus("com.ibm.cic.common.xml.core", 0, "", null);
    }

    private TemplateProcessingVisitor(ITemplateBinding binding, IXMLModel target, HashMap elementMap, ArrayList skip) {
        this(binding, target);
        this.fTemplateToOutput = elementMap;
        this.fSkip = skip;
    }

    @Override
    public boolean visit(IXMLTextModelItem item) {
        if (this.fSkip.contains(item)) {
            return false;
        }
        IXMLTextModelItem parent = (IXMLTextModelItem)this.fTemplateToOutput.get(item.getParent());
        if (parent == null) {
            IXMLTextModelItem cP = item.getParent();
            while (cP != null) {
                parent = (IXMLTextModelItem)this.fTemplateToOutput.get(cP);
                if (parent != null) break;
                cP = cP.getParent();
            }
        }
        if (parent == null) {
            return false;
        }
        String name = item.getName();
        try {
            if (name.startsWith("T:")) {
                return this.doTemplate(name.substring("T:".length()), item, parent);
            }
            this.shallowWrite(item, parent);
        }
        catch (CoreException e) {
            String msg = MessageFormat.format(String.valueOf(e.getMessage()) + Messages.TemplateProcessingVisitor_formattedError, item.toString(), String.valueOf(item.getStartLineNumber()));
            Status err = new Status(e.getStatus().getSeverity(), e.getStatus().getPlugin(), msg, e.getCause());
            this.fStatus.add(e.getStatus());
            this.fStatus.add((IStatus)err);
            return false;
        }
        return true;
    }

    private boolean doTemplate(String tFunction, IXMLTextModelItem item, IXMLTextModelItem targetParent) throws CoreException {
        if ("for-each".equals(tFunction)) {
            String select = item.getAttributeValue("select");
            this.checkField("select", select, item);
            Iterator iter = this.fBinding.forEachTemplate(select, item.getAttributeValue("args"));
            this.doForEach(item, iter);
            return false;
        }
        if ("for".equals(tFunction)) {
            String select = item.getAttributeValue("select");
            this.checkField("select", select, item);
            TemplateBinding[] forBindings = this.fBinding.forTemplate(select, item.getAttributeValue("args"));
            this.doFor(item, forBindings);
            return false;
        }
        if ("emit".equals(tFunction)) {
            String select = item.getAttributeValue("select");
            this.checkField("select", select, item);
            this.doEmit(item, targetParent);
            return false;
        }
        if ("processing-instruction".equals(tFunction)) {
            String target = item.getAttributeValue("target");
            this.checkField("target", target, item);
            target = this.fBinding.processScriptString(target);
            String[] attrs = item.getAttributeNames();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < attrs.length) {
                if (!"target".equals(attrs[i])) {
                    String val = item.getAttributeValue(attrs[i]);
                    val = this.fBinding.processScriptString(val);
                    buf.append(attrs[i]);
                    buf.append('=');
                    buf.append('\'');
                    buf.append(val);
                    buf.append('\'');
                    if (i < attrs.length + 1) {
                        buf.append(' ');
                    }
                }
                ++i;
            }
            IProcessingInstruction procInst = CicXMLCore.getDefault().createProcessionInstruction(target, buf.toString());
            this.fTarget.addProcessingInstruction(procInst);
            return false;
        }
        if ("if".equals(tFunction)) {
            this.fSkip.clear();
            String test = item.getAttributeValue("test");
            this.checkField("test", test, item);
            IXMLTextModelItem elseItem = null;
            IXMLTextModelItem parent = item.getParent();
            IXMLTextModelItem[] children = parent.getChildren();
            int i = 0;
            while (i < children.length - 1) {
                if (children[i] == item && i + 1 < children.length && children[i + 1].getName().equals("T:else")) {
                    elseItem = children[i + 1];
                    break;
                }
                ++i;
            }
            if (this.fBinding.doIf(test, item.getAttributeValue("args"))) {
                if (elseItem != null) {
                    this.fSkip.add(elseItem);
                }
                return true;
            }
            if (elseItem != null) {
                this.fSkip.add(elseItem);
                this.doElse(elseItem);
                return false;
            }
            return false;
        }
        if ("else".equals(tFunction)) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateProcessingVisitor_errMisplacedElse, (Object)item.getName())));
        }
        if ("select".equals(tFunction)) {
            String select = item.getAttributeValue("select");
            this.checkField("select", select, item);
            TemplateBinding binding = this.fBinding.selectTemplate(select, item.getAttributeValue("args"));
            this.doSelect(item, binding);
            return false;
        }
        if ("attribute".equals(tFunction)) {
            String name = this.fBinding.processScriptString(item.getAttributeValue("name"));
            this.checkField("name", name, item);
            String val = this.fBinding.processScriptString(item.getAttributeValue("value"));
            this.checkField("value", val, item);
            targetParent.setAttributeValue(name, val);
            return false;
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateProcessingVisitor_errUnknownFunc, (Object)item.getName())));
    }

    private void doEmit(IXMLTextModelItem emitItem, IXMLTextModelItem targetParent) throws CoreException {
        IXMLTextModelItem item = this.fBinding.emitTemplate(emitItem.getAttributeValue("select"), emitItem.getAttributeValue("args"));
        targetParent.addChild(item);
        item.setParent(targetParent);
    }

    private void doElse(IXMLTextModelItem elseItem) throws CoreException {
        IXMLTextModelItem[] children;
        TemplateProcessingVisitor v = new TemplateProcessingVisitor(this.fBinding, this.fTarget, this.fTemplateToOutput, this.fSkip);
        IXMLTextModelItem[] iXMLTextModelItemArray = children = elseItem.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IXMLTextModelItem element = iXMLTextModelItemArray[n2];
            element.visit(v);
            IStatus s = v.getStatus();
            if (!s.isOK()) {
                throw new CoreException(s);
            }
            ++n2;
        }
    }

    private void checkField(String attrName, String value, IXMLTextModelItem templateItem) throws CoreException {
        if (value == null || value.length() == 0) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateProcessingVisitor_errMissingAttr, (Object)attrName, (Object)templateItem.getName())));
        }
    }

    private void doForEach(IXMLTextModelItem item, Iterator iter) throws CoreException {
        IXMLTextModelItem[] children = item.getChildren();
        while (iter.hasNext()) {
            ITemplateBinding binding = (ITemplateBinding)iter.next();
            IXMLTextModelItem[] iXMLTextModelItemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IXMLTextModelItem element = iXMLTextModelItemArray[n2];
                TemplateProcessingVisitor v = new TemplateProcessingVisitor(binding, this.fTarget, this.fTemplateToOutput, this.fSkip);
                element.visit(v);
                IStatus s = v.getStatus();
                if (!s.isOK()) {
                    throw new CoreException(s);
                }
                ++n2;
            }
        }
    }

    private void doFor(IXMLTextModelItem item, TemplateBinding[] bindings) throws CoreException {
        IXMLTextModelItem[] children = item.getChildren();
        TemplateBinding[] templateBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateBinding binding = templateBindingArray[n2];
            IXMLTextModelItem[] iXMLTextModelItemArray = children;
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IXMLTextModelItem element = iXMLTextModelItemArray[n4];
                TemplateProcessingVisitor v = new TemplateProcessingVisitor(binding, this.fTarget, this.fTemplateToOutput, this.fSkip);
                element.visit(v);
                IStatus s = v.getStatus();
                if (!s.isOK()) {
                    throw new CoreException(s);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void doSelect(IXMLTextModelItem item, TemplateBinding selection) throws CoreException {
        IXMLTextModelItem[] children;
        IXMLTextModelItem[] iXMLTextModelItemArray = children = item.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IXMLTextModelItem element = iXMLTextModelItemArray[n2];
            TemplateProcessingVisitor v = new TemplateProcessingVisitor(selection, this.fTarget, this.fTemplateToOutput, this.fSkip);
            element.visit(v);
            IStatus s = v.getStatus();
            if (!s.isOK()) {
                throw new CoreException(s);
            }
            ++n2;
        }
    }

    private IXMLTextModelItem shallowWrite(IXMLTextModelItem item, IXMLTextModelItem targetParent) throws CoreException {
        String[] attrs;
        IXMLTextModelItem newItem = CicXMLCore.getDefault().createItem(item.getName());
        String[] stringArray = attrs = item.getAttributeNames();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            String val = item.getAttributeValue(attr);
            val = this.fBinding.processScriptString(val);
            newItem.setAttributeValue(attr, val);
            ++n2;
        }
        if (item.getElementCDATA() != null) {
            newItem.setElementCDATA(this.fBinding.processScriptString(item.getElementCDATA()));
        }
        targetParent.addChild(newItem);
        newItem.setParent(targetParent);
        this.fTemplateToOutput.put(item, newItem);
        return newItem;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }
}

