/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema;

import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.internal.model.schema.BooleanType;
import com.ibm.cic.common.xml.core.internal.model.schema.IntegerType;
import com.ibm.cic.common.xml.core.internal.model.schema.SchemaDefinition;
import com.ibm.cic.common.xml.core.internal.model.schema.SchemaFactory;
import com.ibm.cic.common.xml.core.internal.model.schema.StringType;
import com.ibm.cic.common.xml.core.model.schema.IElementDefinition;
import com.ibm.cic.common.xml.core.model.schema.IReferencable;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import com.ibm.cic.common.xml.core.model.schema.ISchemaResolver;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaResolver
implements ISchemaResolver {
    private Document fDocument;
    private String fNamespace;
    private Node fSchemaRoot;
    private final HashMap fTypes = new HashMap();
    private ArrayList fTopElements;
    private SchemaDefinition fSchema;
    private final HashMap fNSRefs;
    private static final String NS_PREFIX = "xmlns:";

    public SchemaResolver() {
        BooleanType bool = new BooleanType(null);
        this.fTypes.put(bool.getReferenceName(), bool);
        StringType str = new StringType(null);
        this.fTypes.put(str.getReferenceName(), str);
        IntegerType intType = new IntegerType(null);
        this.fTypes.put(intType.getReferenceName(), intType);
        this.fNSRefs = new HashMap();
    }

    public void resolve(Document schema) {
        this.fDocument = schema;
        this.fTopElements = new ArrayList();
        this.readNamespaces();
        if (this.fNamespace == null) {
            this.fNamespace = "";
        }
        this.fSchema = new SchemaDefinition(this.fNamespace, this);
        this.walkDOM();
        for (Element elem : this.fTopElements) {
            IElementDefinition def = SchemaFactory.createElement(elem, this.fSchema);
            this.fTypes.put(def.getReferenceName(), def);
            this.fSchema.addElement(def);
        }
    }

    private void walkDOM() {
        if (this.fSchemaRoot == null) {
            System.out.println("Schema root not found");
            return;
        }
        NodeList nodes = this.fSchemaRoot.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 1) {
                this.handleElementNode((Element)n);
            }
            ++i;
        }
    }

    public ISchema getSchema() {
        return this.fSchema;
    }

    private void handleElementNode(Element node) {
        String name = node.getNodeName();
        if ("element".equals(name)) {
            this.fTopElements.add(node);
            return;
        }
        IReferencable ref = SchemaFactory.createType(node, this.fSchema);
        if (ref != null) {
            this.fTypes.put(ref.getReferenceName(), ref);
        } else {
            if ("annotation".equals(name) || "import".equals(name)) {
                return;
            }
            System.out.println("Unhandled Schema ElementDefinition Found: " + name);
        }
    }

    private void readNamespaces() {
        String targetNamespace = null;
        NodeList _root = this.fDocument.getChildNodes();
        int i = 0;
        while (i < _root.getLength()) {
            Node _n = _root.item(i);
            String name = _n.getNodeName();
            if ("schema".equals(name)) {
                this.fSchemaRoot = _n;
                Element root = (Element)_n;
                targetNamespace = root.getAttribute("targetNamespace");
                NamedNodeMap _attrs = _n.getAttributes();
                int t = 0;
                while (t < _attrs.getLength()) {
                    Node _a = _attrs.item(t);
                    String aName = _a.getNodeName();
                    if (aName != null && aName.startsWith(NS_PREFIX)) {
                        String nsUrl = root.getAttribute(aName);
                        if (targetNamespace.equals(nsUrl)) {
                            this.fNamespace = aName.substring(NS_PREFIX.length());
                        } else {
                            ISchema ref = CicXMLCore.getDefault().getReferenceSchema(nsUrl);
                            this.addReferencedNamespace(aName.substring(NS_PREFIX.length()), ref);
                        }
                    }
                    ++t;
                }
            }
            ++i;
        }
    }

    private void addReferencedNamespace(String ns, ISchema schema) {
        this.fNSRefs.put(ns, schema);
    }

    public IReferencable findTypeReference(String typeName) {
        return (IReferencable)this.fTypes.get(typeName);
    }

    @Override
    public IElementDefinition findElementReference(String elementQName) {
        return this.fSchema.getElement(elementQName);
    }

    @Override
    public IReferencable lookupType(String refName) {
        if (refName.indexOf(58) > 1) {
            String ns = refName.substring(0, refName.indexOf(58));
            String type = refName.substring(refName.indexOf(58) + 1);
            if ("xs".equals(ns)) {
                return (IReferencable)this.fTypes.get(type);
            }
            if (this.fNamespace.equals(ns)) {
                return (IReferencable)this.fTypes.get(refName);
            }
            ISchema schema = (ISchema)this.fNSRefs.get(ns);
            if (schema != null) {
                ISchemaResolver resolver = schema.getResolver();
                return resolver.lookupType(refName);
            }
        }
        return (IReferencable)this.fTypes.get(refName);
    }
}

