/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema;

import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.internal.model.schema.IValueRefinement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;

public class PatternRefinement
implements IValueRefinement {
    private final String fRegex;
    private boolean fValid;
    private Pattern fPattern;

    public PatternRefinement(Element element) {
        this.fRegex = element.getAttribute("value");
        try {
            this.fPattern = Pattern.compile(this.fRegex);
            this.fValid = true;
        }
        catch (PatternSyntaxException ex) {
            CicXMLCore.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.cic.common.xml.core", 0, Messages.bind((String)Messages.intErr_invalid_pattern, (Object)this.fRegex), (Throwable)ex));
            this.fValid = false;
        }
    }

    @Override
    public String getFailureMessage(String attribute, String value) {
        return Messages.bind((String)Messages.err_pattern_rule, (Object)attribute, (Object)this.fRegex);
    }

    @Override
    public boolean isValueValid(String value) {
        if (this.fValid) {
            Matcher match = this.fPattern.matcher(value);
            return match.matches();
        }
        return true;
    }
}

