/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema;

import com.ibm.cic.common.xml.core.internal.model.schema.XMLUtility;

public class Multiplicity {
    private int fMin = 1;
    private int fMax = 1;
    private boolean fUnbounded = false;

    public Multiplicity() {
    }

    public Multiplicity(int min, int max, boolean unbounded) {
        this.fMin = min;
        this.fMax = max;
        this.fUnbounded = unbounded;
    }

    public Multiplicity(Multiplicity copy) {
        this.fMin = copy.fMin;
        this.fMax = copy.fMax;
        this.fUnbounded = copy.fUnbounded;
    }

    public int check(int count) {
        if (count < this.fMin) {
            return -1;
        }
        if (!this.fUnbounded && count > this.fMax) {
            return 1;
        }
        return 0;
    }

    public void setMin(String minStr) {
        if (!XMLUtility.isEmpty(minStr)) {
            this.fMin = Integer.parseInt(minStr);
        }
    }

    public void setMin(int min) {
        this.fMin = min;
    }

    public void setMax(String value) {
        if (!XMLUtility.isEmpty(value)) {
            if ("unbounded".equals(value)) {
                this.fUnbounded = true;
            } else {
                this.fMax = Integer.parseInt(value);
            }
        }
    }

    public int getMax() {
        return this.fMax;
    }

    public int getMin() {
        return this.fMin;
    }

    public void setMax(int max) {
        this.fMax = max;
    }

    public void setUnbounded(boolean value) {
        this.fUnbounded = value;
    }

    public boolean isUnbounded() {
        return this.fUnbounded;
    }

    public void applyParent(Multiplicity multi) {
        this.fMax *= multi.fMax;
        this.fMin *= multi.fMin;
        if (multi.fUnbounded) {
            this.fUnbounded = true;
        }
    }
}

