/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.delta;

import com.ibm.cic.common.xml.core.delta.ElementDelta;
import com.ibm.cic.common.xml.core.delta.IXMLDelta;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import java.util.ArrayList;
import java.util.List;

public class XMLDeltaProcessor {
    public static final int DEPTH_INFINITE = Integer.MAX_VALUE;
    private final ArrayList fIgnores = new ArrayList(2);

    public IXMLDelta compute(IXMLTextModelItem source, IXMLTextModelItem target) {
        ElementDelta delta = new ElementDelta(source, target, null, this.fIgnores);
        return delta;
    }

    public void addGloballyIgnoredAttribute(String attribute) {
        this.fIgnores.add(attribute);
    }

    public void descend(IXMLDelta delta, IXMLDeltaMatcher matcher, int depth) {
        IXMLTextModelItem src = delta.getSource();
        IXMLTextModelItem targ = delta.getTarget();
        IXMLTextModelItem[] sChild = new IXMLTextModelItem[]{};
        IXMLTextModelItem[] tChild = new IXMLTextModelItem[]{};
        if (src != null) {
            sChild = src.getChildren();
        }
        if (targ != null) {
            tChild = targ.getChildren();
        }
        if (sChild.length == 0) {
            IXMLTextModelItem[] iXMLTextModelItemArray = tChild;
            int n = tChild.length;
            int n2 = 0;
            while (n2 < n) {
                IXMLTextModelItem element = iXMLTextModelItemArray[n2];
                ElementDelta newDelta = new ElementDelta(null, element, delta, this.fIgnores);
                if (depth > 0 || depth == Integer.MAX_VALUE) {
                    this.descend(newDelta, matcher, depth == Integer.MAX_VALUE ? Integer.MAX_VALUE : depth - 1);
                }
                ++n2;
            }
        } else {
            IXMLTextModelItem element;
            ArrayList<IXMLTextModelItem> possible = new ArrayList<IXMLTextModelItem>(tChild.length);
            IXMLTextModelItem[] iXMLTextModelItemArray = tChild;
            int n = tChild.length;
            int n3 = 0;
            while (n3 < n) {
                element = iXMLTextModelItemArray[n3];
                possible.add(element);
                ++n3;
            }
            iXMLTextModelItemArray = sChild;
            n = sChild.length;
            n3 = 0;
            while (n3 < n) {
                element = iXMLTextModelItemArray[n3];
                IXMLTextModelItem match = matcher.getMatch(element, targ, possible);
                if (match != null) {
                    possible.remove(match);
                }
                ElementDelta newDelta = new ElementDelta(element, match, delta, this.fIgnores);
                if (depth > 0 || depth == Integer.MAX_VALUE) {
                    this.descend(newDelta, matcher, depth == Integer.MAX_VALUE ? Integer.MAX_VALUE : depth - 1);
                }
                ++n3;
            }
            for (IXMLTextModelItem targetChild : possible) {
                ElementDelta newDelta = new ElementDelta(null, targetChild, delta, this.fIgnores);
                if (depth <= 0 && depth != Integer.MAX_VALUE) continue;
                this.descend(newDelta, matcher, depth == Integer.MAX_VALUE ? Integer.MAX_VALUE : depth - 1);
            }
        }
    }

    public static interface IXMLDeltaMatcher {
        public IXMLTextModelItem getMatch(IXMLTextModelItem var1, IXMLTextModelItem var2, List var3);
    }
}

