/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core;

import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.xml.core.model.IProblem;

public class TextProblem
implements IProblem {
    private final String fMessage;
    private final int fOffset;
    private int fLength;
    private final int fSev;
    private int fLine;
    private byte fCat;

    public TextProblem(int severity, String message, int offset, int length, int line) {
        this.fSev = severity;
        this.fMessage = message;
        this.fOffset = offset;
        this.fLine = line;
        this.fLength = length < 0 ? 0 : length;
        this.fCat = 1;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public String getMessage() {
        return this.fMessage;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public int getSeverity() {
        return this.fSev;
    }

    public void setLineNumber(int line) {
        this.fLine = line;
    }

    @Override
    public int getLineNumber() {
        return this.fLine;
    }

    @Override
    public byte getCategory() {
        return this.fCat;
    }

    @Override
    public void setCategory(byte category) {
        this.fCat = category;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextProblem) {
            TextProblem input = (TextProblem)obj;
            return input.fCat == this.fCat && input.fLength == this.fLength && input.fLine == this.fLine && input.fOffset == this.fOffset && input.fSev == this.fSev && (this.fMessage == null && input.fMessage == null || this.fMessage != null && this.fMessage.equals(input.fMessage) || input.fMessage != null && input.fMessage.equals(this.fMessage));
        }
        return false;
    }

    public int hashCode() {
        return Util.hashCode((Object[])new Object[]{this.fCat, this.fLength, this.fLine, this.fOffset, this.fSev, this.fMessage});
    }
}

