/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core;

import com.ibm.cic.common.xml.core.ISourceConverter;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import com.ibm.cic.common.xml.core.model.schema.BaseRule;
import com.ibm.cic.common.xml.core.model.schema.IAttributeDefinition;
import com.ibm.cic.common.xml.core.model.schema.IReferencable;
import com.ibm.cic.common.xml.core.model.schema.IValueRestriction;

public abstract class BaseAttributeRule
extends BaseRule {
    private static final String COMMA_SPACE = ", ";

    public void checkAttribute(IXMLTextModelItem item, IAttributeDefinition attr, String val, ISourceConverter converter) {
        IValueRestriction restrict;
        IReferencable type;
        if (attr.isRequired() && val == null) {
            this.reportError(Messages.bind((String)Messages.err_element_missing_attribute, (Object)item.getName(), (Object)attr.getName()), item.getTextSpan().getOffset() + 1, item.getName().length(), item.getStartLineNumber(), item);
        }
        if (attr.isProhibited() && val != null) {
            this.reportAttributeError(Messages.bind((String)Messages.err_prohibited_attribute, (Object)attr.getName(), (Object)item.getName()), item, attr.getName(), item.getAttributeValue(attr.getName()), converter);
        }
        if (val != null && (type = attr.getAttributeType()) instanceof IValueRestriction && !(restrict = (IValueRestriction)((Object)type)).isValueValid(attr.getName(), val)) {
            StringBuffer buf = new StringBuffer(Messages.bind((String)Messages.err_attr_invalid_value, (Object)attr.getName()));
            String detail = restrict.getFailureMessage(attr.getName(), val);
            buf.append(' ');
            if (detail != null) {
                buf.append(detail);
                buf.append(' ');
            }
            if (restrict.isFixedValueSet()) {
                buf.append(Messages.err_valid_values);
                String[] vals = restrict.getValues();
                int i = 0;
                while (i < vals.length) {
                    buf.append(vals[i]);
                    if (i + 1 < vals.length) {
                        buf.append(COMMA_SPACE);
                    }
                    ++i;
                }
            }
            this.reportAttributeError(buf.toString(), item, attr.getName(), val, converter);
        }
    }
}

