/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.AbstractLicPlatformPolicyFactory;
import com.ibm.cic.licensing.common.util.LicPlatformUtils;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.Logger;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

class PPLicUserUtils
extends AbstractLicPlatformPolicyFactory {
    static PPLicUserUtils m_factory = new PPLicUserUtils();

    PPLicUserUtils() {
    }

    @Override
    protected Object createLinuxPolicy() {
        return new PPLinux();
    }

    @Override
    protected Object createWindowsPolicy() {
        return new PPWindows();
    }

    static PPCommon getPolicy() {
        return (PPCommon)m_factory.getPlatformPolicy();
    }

    abstract class PPCommon {
        protected static final String USERHOME = "user.home";
        protected static final String PRODUCT = "Installation Manager";
        protected static final String PRODUCT_P2 = "p2";
        protected static final String APPDATA = "Application Data";
        protected static final String IBM_UPPERCASE = "IBM";
        protected static final String DOT_IBM = ".ibm";
        protected static final String PRODUCT_NO_SPACE = "InstallationManager";
        protected static final String IBM_LOWERCASE = "ibm";

        PPCommon() {
        }

        abstract IPath getUserHomeDirectory();

        abstract IPath getCommChannelDir();

        abstract IPath getUserLicenseLocation();

        abstract IPath getAllUserProductLocation();

        abstract IPath getAllUserDirectory();

        abstract String getIBMDirName();

        abstract IPath getUserAppDataLocation();
    }

    class PPLinux
    extends PPCommon {
        PPLinux() {
        }

        @Override
        IPath getUserHomeDirectory() {
            String userHome = System.getProperty("user.home");
            if (userHome == null || userHome.length() == 0) {
                userHome = LicPlatformUtils.getEnvironmentVariable("HOME");
            }
            return new Path(userHome);
        }

        @Override
        IPath getUserLicenseLocation() {
            IPath return_value = this.getUserHomeDirectory();
            return_value = LicUserUtils.P2_INSTALL ? return_value.append(".ibm").append("p2").append("license") : return_value.append(".ibm").append("InstallationManager").append("license");
            Logger.trace("User license location=" + return_value.toOSString());
            return return_value;
        }

        @Override
        IPath getAllUserProductLocation() {
            IPath return_value = this.getAllUserDirectory();
            return_value = return_value.append("ibm").append("InstallationManager");
            return return_value;
        }

        @Override
        IPath getAllUserDirectory() {
            IPath userhome = PPLicUserUtils.getPolicy().getUserHomeDirectory();
            try {
                return new Path("/var");
            }
            catch (Exception e) {
                Logger.logNtrace("Error getting to all users directory", e);
                return userhome;
            }
        }

        @Override
        IPath getCommChannelDir() {
            return this.getAllUserProductLocation();
        }

        @Override
        String getIBMDirName() {
            return "ibm";
        }

        @Override
        IPath getUserAppDataLocation() {
            return this.getUserHomeDirectory().append("var");
        }
    }

    class PPWindows
    extends PPCommon {
        PPWindows() {
        }

        @Override
        IPath getUserHomeDirectory() {
            String userHome = System.getProperty("user.home");
            if (userHome == null || userHome.length() == 0) {
                userHome = LicPlatformUtils.getEnvironmentVariable("USERPROFILE");
            }
            return new Path(userHome);
        }

        @Override
        IPath getUserLicenseLocation() {
            IPath return_value = this.getUserHomeDirectory();
            return_value = LicUserUtils.P2_INSTALL ? return_value.append("Application Data").append("IBM").append("p2").append("license") : return_value.append("Application Data").append("IBM").append("Installation Manager").append("license");
            return return_value;
        }

        @Override
        IPath getAllUserProductLocation() {
            IPath return_value = this.getAllUserDirectory();
            return_value = return_value.append("Application Data").append("IBM").append("Installation Manager");
            return return_value;
        }

        @Override
        IPath getAllUserDirectory() {
            IPath userhome = PPLicUserUtils.getPolicy().getUserHomeDirectory();
            try {
                String allUsersDir = LicPlatformUtils.getEnvironmentVariable("ALLUSERSPROFILE");
                if (allUsersDir != null) {
                    return new Path(allUsersDir);
                }
                File userparent = userhome.toFile().getParentFile();
                IPath allUserPath = new Path(userparent.getCanonicalPath()).append("All Users");
                if (!allUserPath.toFile().exists()) {
                    allUserPath.toFile().mkdirs();
                }
                return allUserPath;
            }
            catch (Exception e) {
                Logger.logNtrace("Error getting to all users directory", e);
                return userhome;
            }
        }

        @Override
        IPath getCommChannelDir() {
            return this.getAllUserDirectory();
        }

        @Override
        String getIBMDirName() {
            return "IBM";
        }

        @Override
        IPath getUserAppDataLocation() {
            return new Path(LicPlatformUtils.getEnvironmentVariable("APPDATA"));
        }
    }
}

