/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.ILicUserActivityEventListener;
import com.ibm.cic.licensing.common.util.ILicUserActivityEventManager;
import com.ibm.cic.licensing.common.util.LicUserActivityEvent;
import com.ibm.cic.licensing.common.util.Logger;
import org.eclipse.core.runtime.ListenerList;

public class LicUserActivityEventManager
implements ILicUserActivityEventManager {
    private static LicUserActivityEventManager instance;
    private ListenerList userActivityListeners = new ListenerList();

    private LicUserActivityEventManager() {
    }

    public static LicUserActivityEventManager getInstance() {
        if (instance == null) {
            instance = new LicUserActivityEventManager();
        }
        return instance;
    }

    @Override
    public void addLicUserActivityListener(ILicUserActivityEventListener listener) {
        if (listener != null) {
            this.userActivityListeners.add((Object)listener);
        }
    }

    @Override
    public void removeLicUserActivityListener(ILicUserActivityEventListener listener) {
        if (listener != null) {
            this.userActivityListeners.remove((Object)listener);
        }
    }

    @Override
    public void fireAfterUserActivityChange(LicUserActivityEvent event) {
        if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.logNtrace("fireAfterUserActivityChange() fired. block hearbeat: " + event.isBlock());
        }
        Object[] listeners = this.userActivityListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ILicUserActivityEventListener listener = (ILicUserActivityEventListener)listeners[i];
            listener.handleLicUserActivityEvent(event);
            ++i;
        }
    }
}

