/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.utils;

import com.ibm.cic.common.core.utils.AbstractPlatformPolicyFactory;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;

class PPPlatformUtils
extends AbstractPlatformPolicyFactory {
    static PPPlatformUtils m_factory = new PPPlatformUtils();

    PPPlatformUtils() {
    }

    protected Object createLinuxPolicy() {
        return new PPLinux();
    }

    protected Object createWindowsPolicy() {
        return new PPWindows();
    }

    static PPCommon getPolicy() {
        return (PPCommon)m_factory.getPlatformPolicy();
    }

    abstract class PPCommon {
        PPCommon() {
        }

        public String getWS() {
            return Platform.getWS();
        }
    }

    class PPLinux
    extends PPCommon {
        PPLinux() {
        }

        @Override
        public String getWS() {
            String return_value = super.getWS();
            if ("gtk".equals(return_value)) {
                Class<?> os = null;
                try {
                    os = Class.forName("org.eclipse.swt.internal.gtk.OS");
                    if (os != null) {
                        Method maj = os.getMethod("gtk_major_version", new Class[0]);
                        Integer major = (Integer)maj.invoke(null, new Object[0]);
                        Method min = os.getMethod("gtk_minor_version", new Class[0]);
                        Integer minor = (Integer)min.invoke(null, new Object[0]);
                        Method mic = os.getMethod("gtk_micro_version", new Class[0]);
                        Integer micro = (Integer)mic.invoke(null, new Object[0]);
                        return_value = String.valueOf(return_value) + " " + major + "." + minor + "." + micro;
                    }
                }
                catch (ClassNotFoundException e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    ExceptionUtil.debugLogToReview((Throwable)e);
                }
            }
            return return_value;
        }
    }

    class PPWindows
    extends PPCommon {
        PPWindows() {
        }
    }
}

