/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.preferences;

import com.ibm.cic.common.core.auth.AuthorizationInfoFromSecureStorage;
import com.ibm.cic.common.core.auth.PasswordChangeDirection;
import com.ibm.cic.common.core.auth.PasswordManager;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.internal.dialogs.ChangePasswordWizardDialog;
import com.ibm.cic.common.ui.services.UiServices;
import org.eclipse.equinox.internal.security.storage.friends.ReEncrypter;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class StoragePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button checkUseMasterPassword;
    private Button buttonChangePassword;
    private Button buttonResetStore;
    private Label pageDescriptionLabel;
    private Text textLocation;

    public StoragePreferencePage() {
        if (!PasswordManager.INSTANCE.isPasswordFromFile()) {
            this.setDescription(com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_NormalDescription);
        } else {
            this.setDescription(com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_passwordFileIsUsedDescription);
        }
        this.noDefaultAndApplyButton();
    }

    protected Label createDescriptionLabel(Composite parent) {
        this.pageDescriptionLabel = super.createDescriptionLabel(parent);
        return this.pageDescriptionLabel;
    }

    protected Control createContents(Composite parent) {
        this.updateDescriptionLabelLayout();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout());
        if (!PasswordManager.INSTANCE.isPasswordFromFile()) {
            this.createPasswordGroupContents(composite);
            this.createStorageGroupContents(composite);
        }
        return parent;
    }

    private void createPasswordGroupContents(Composite composite) {
        Group passwordGroup = new Group(composite, 0);
        passwordGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        passwordGroup.setLayout((Layout)new GridLayout(2, false));
        passwordGroup.setText(Messages.StoragePreferencePage_passwordGroupLabel);
        this.checkUseMasterPassword = new Button((Composite)passwordGroup, 32);
        this.checkUseMasterPassword.setText(Messages.SecureStoragePreferencePage_UseMasterPassword_label);
        GridData checkboxData = new GridData(4, 0x1000000, true, false);
        checkboxData.horizontalSpan = 1;
        this.checkUseMasterPassword.setLayoutData((Object)checkboxData);
        this.checkUseMasterPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StoragePreferencePage.this.updatePasswordChangeDirection();
                StoragePreferencePage.this.changePasswordNoWizard();
                StoragePreferencePage.this.loadWidgets();
            }
        });
        this.buttonChangePassword = new Button((Composite)passwordGroup, 8);
        this.buttonChangePassword.setText(com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_buttonChangePasswordLabel);
        GridData buttonChangePasswordData = new GridData(131072, 0x1000000, true, false);
        this.buttonChangePassword.setLayoutData((Object)buttonChangePasswordData);
        this.buttonChangePassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StoragePreferencePage.this.onChangePassword();
            }
        });
        Label labelUseMaster = new Label((Composite)passwordGroup, 64);
        GridData labelUseMasterData = new GridData(4, 0x1000000, true, false);
        labelUseMasterData.widthHint = 250;
        labelUseMasterData.horizontalSpan = 2;
        labelUseMaster.setLayoutData((Object)labelUseMasterData);
        labelUseMaster.setText(com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_UseMasterExplanationLabel);
    }

    void updatePasswordChangeDirection() {
        if (this.checkUseMasterPassword.getSelection()) {
            PasswordManager.INSTANCE.setChangeDirection(PasswordChangeDirection.TO_ANY);
        } else {
            PasswordManager.INSTANCE.setChangeDirection(PasswordChangeDirection.TO_DEFAULT);
        }
    }

    private void createStorageGroupContents(Composite composite) {
        Group storageGroup = new Group(composite, 0);
        storageGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        storageGroup.setLayout((Layout)new GridLayout(2, false));
        storageGroup.setText(Messages.StoragePreferencePage_storageGroupLabel);
        Label labelReset = new Label((Composite)storageGroup, 64);
        GridData labelResetData = new GridData(4, 0x1000000, true, false);
        labelResetData.widthHint = 250;
        labelResetData.horizontalSpan = 2;
        labelReset.setLayoutData((Object)labelResetData);
        labelReset.setText(com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_ResetExplanationLabel);
        this.buttonResetStore = new Button((Composite)storageGroup, 8);
        this.buttonResetStore.setText(com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_buttonResetLabel);
        GridData buttonResetStoreData = new GridData(131072, 0x1000000, true, false);
        this.buttonResetStore.setLayoutData((Object)buttonResetStoreData);
        this.buttonResetStore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StoragePreferencePage.this.resetStorage();
            }
        });
        Label labelLocation = new Label((Composite)storageGroup, 64);
        GridData labelLocationData = new GridData(4, 0x1000000, true, false);
        labelLocationData.widthHint = 250;
        labelLocationData.horizontalSpan = 2;
        labelLocation.setLayoutData((Object)labelLocationData);
        labelLocation.setText(Messages.StoragePreferencePage_locationLabel);
        this.textLocation = new Text((Composite)storageGroup, 8);
        this.textLocation.setLayoutData((Object)labelLocationData);
    }

    void updateDescriptionLabelLayout() {
        GridData labelData = new GridData(4, 0x1000000, true, false);
        labelData.widthHint = 250;
        this.pageDescriptionLabel.setLayoutData((Object)labelData);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CicCommonUiPlugin.getDefault().getPreferenceStore());
    }

    void loadWidgets() {
        boolean defaultPasswordUsed = false;
        try {
            defaultPasswordUsed = PasswordManager.INSTANCE.loadPasswordUsage();
        }
        catch (StorageException storageException) {
            // empty catch block
        }
        this.checkUseMasterPassword.setSelection(!defaultPasswordUsed);
        this.updatePasswordChangeDirection();
        this.buttonChangePassword.setEnabled(this.checkUseMasterPassword.getSelection());
        this.textLocation.setText(AuthorizationInfoFromSecureStorage.getStorageFile().getAbsolutePath());
    }

    void resetStorage() {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_resetConfirmationTitle, (String)com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_resetConfirmationQuestion)) {
            AuthorizationInfoFromSecureStorage.deleteStorage();
            PasswordManager.INSTANCE.useDefault(false);
            try {
                PasswordManager.INSTANCE.savePasswordUsage();
            }
            catch (StorageException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_resetConfirmationTitle, (String)NLS.bind((String)com.ibm.cic.common.core.sharedUI.Messages.ChangePasswordWizardDialog_errorSavingExtraData, (Object)e.getMessage()));
            }
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.StoragePreferencePage_storageDeletedTitle, (String)Messages.StoragePreferencePage_StorageDeletedMessage)) {
                UiServices.getInstance().restartWorkbench();
            } else {
                this.loadWidgets();
            }
        }
    }

    void onChangePassword() {
        ChangePasswordWizardDialog dialog = new ChangePasswordWizardDialog(this.getShell(), SecurePreferencesFactory.getDefault(), "com.ibm.cic.security.storage.capilanopasswordprovider");
        dialog.open();
        this.loadWidgets();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !PasswordManager.INSTANCE.isPasswordFromFile()) {
            this.loadWidgets();
        }
    }

    boolean changePasswordNoWizard() {
        MessageBox messageBox;
        ISecurePreferences startNode = SecurePreferencesFactory.getDefault();
        if (!PasswordManager.INSTANCE.triggerPasswordPrompt(startNode)) {
            return false;
        }
        Shell shell = this.getShell();
        ReEncrypter reEncrypter = new ReEncrypter(startNode, "com.ibm.cic.security.storage.capilanopasswordprovider");
        if (!reEncrypter.decrypt()) {
            messageBox = new MessageBox(shell, 200);
            messageBox.setText(com.ibm.cic.common.core.sharedUI.Messages.changePasswordWizardTitle);
            messageBox.setMessage(com.ibm.cic.common.core.sharedUI.Messages.wizardDecodeWarning);
            if (messageBox.open() == 64) {
                return false;
            }
        }
        if (!reEncrypter.switchToNewPassword()) {
            if (!PasswordManager.INSTANCE.isPasswordDialogCanceled()) {
                messageBox = new MessageBox(shell, 33);
                messageBox.setText(com.ibm.cic.common.core.sharedUI.Messages.changePasswordWizardTitle);
                messageBox.setMessage(com.ibm.cic.common.core.sharedUI.Messages.wizardSwitchError);
                messageBox.open();
            }
            return false;
        }
        reEncrypter.encrypt();
        try {
            PasswordManager.INSTANCE.savePasswordUsage();
        }
        catch (StorageException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.changePasswordWizardTitle, (String)NLS.bind((String)com.ibm.cic.common.core.sharedUI.Messages.ChangePasswordWizardDialog_errorSavingExtraData, (Object)e.getMessage()));
        }
        return true;
    }
}

